/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.i2c.impl;

import com.pi4j.io.i2c.I2CBus;
import com.pi4j.io.i2c.I2CDevice;
import com.pi4j.jni.I2C;
import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class I2CDeviceImpl
implements I2CDevice {
    private I2CBus bus;
    private int deviceAddress;
    private static final Lock lock = new ReentrantLock(true);

    public I2CDeviceImpl(I2CBus bus, int address) {
        this.bus = bus;
        this.deviceAddress = address;
    }

    @Override
    public void write(byte data) throws IOException {
        lock.lock();
        try {
            int ret = I2C.i2cWriteByteDirect(this.bus.getFileDescriptor(), this.deviceAddress, data);
            if (ret < 0) {
                throw new IOException("Error writing to " + this.makeDescription() + ". Got " + ret + ".");
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] buffer, int offset, int size) throws IOException {
        lock.lock();
        try {
            int ret = I2C.i2cWriteBytesDirect(this.bus.getFileDescriptor(), this.deviceAddress, size, offset, buffer);
            if (ret < 0) {
                throw new IOException("Error writing to " + this.makeDescription() + ". Got " + ret + ".");
            }
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void write(byte[] buffer) throws IOException {
        this.write(buffer, 0, buffer.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int address, byte data) throws IOException {
        lock.lock();
        try {
            int ret = I2C.i2cWriteByte(this.bus.getFileDescriptor(), this.deviceAddress, address, data);
            if (ret < 0) {
                throw new IOException("Error writing to " + this.makeDescription(address) + ". Got " + ret + ".");
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int address, byte[] buffer, int offset, int size) throws IOException {
        lock.lock();
        try {
            int ret = I2C.i2cWriteBytes(this.bus.getFileDescriptor(), this.deviceAddress, address, size, offset, buffer);
            if (ret < 0) {
                throw new IOException("Error writing to " + this.makeDescription(address) + ". Got " + ret + ".");
            }
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void write(int address, byte[] buffer) throws IOException {
        this.write(address, buffer, 0, buffer.length);
    }

    @Override
    public int read() throws IOException {
        lock.lock();
        try {
            int ret = I2C.i2cReadByteDirect(this.bus.getFileDescriptor(), this.deviceAddress);
            if (ret < 0) {
                throw new IOException("Error reading from " + this.makeDescription() + ". Got " + ret + ".");
            }
            int n = ret;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] buffer, int offset, int size) throws IOException {
        lock.lock();
        try {
            int ret = I2C.i2cReadBytesDirect(this.bus.getFileDescriptor(), this.deviceAddress, size, offset, buffer);
            if (ret < 0) {
                throw new IOException("Error reading from " + this.makeDescription() + ". Got " + ret + ".");
            }
            int n = ret;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(int address) throws IOException {
        lock.lock();
        try {
            int ret = I2C.i2cReadByte(this.bus.getFileDescriptor(), this.deviceAddress, address);
            if (ret < 0) {
                throw new IOException("Error reading from " + this.makeDescription(address) + ". Got " + ret + ".");
            }
            int n = ret;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(int address, byte[] buffer, int offset, int size) throws IOException {
        lock.lock();
        try {
            int ret = I2C.i2cReadBytes(this.bus.getFileDescriptor(), this.deviceAddress, address, size, offset, buffer);
            if (ret < 0) {
                throw new IOException("Error reading from " + this.makeDescription(address) + ". Got " + ret + ".");
            }
            int n = ret;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] writeBuffer, int writeOffset, int writeSize, byte[] readBuffer, int readOffset, int readSize) throws IOException {
        lock.lock();
        try {
            int ret = I2C.i2cWriteAndReadBytes(this.bus.getFileDescriptor(), this.deviceAddress, writeSize, writeOffset, writeBuffer, readSize, readOffset, readBuffer);
            if (ret < 0) {
                throw new IOException("Error reading from " + this.makeDescription() + ". Got " + ret + ".");
            }
            int n = ret;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    protected String makeDescription() {
        return this.bus.getFileName() + " at address 0x" + Integer.toHexString(this.deviceAddress);
    }

    protected String makeDescription(int address) {
        return this.bus.getFileName() + " at address 0x" + Integer.toHexString(this.deviceAddress) + " to address 0x" + Integer.toHexString(address);
    }
}

