/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.gpio.impl;

import com.pi4j.io.gpio.GpioController;
import com.pi4j.io.gpio.GpioFactory;
import com.pi4j.io.gpio.GpioPin;
import com.pi4j.io.gpio.GpioPinAnalog;
import com.pi4j.io.gpio.GpioPinAnalogInput;
import com.pi4j.io.gpio.GpioPinAnalogOutput;
import com.pi4j.io.gpio.GpioPinDigital;
import com.pi4j.io.gpio.GpioPinDigitalInput;
import com.pi4j.io.gpio.GpioPinDigitalMultipurpose;
import com.pi4j.io.gpio.GpioPinDigitalOutput;
import com.pi4j.io.gpio.GpioPinInput;
import com.pi4j.io.gpio.GpioPinPwmOutput;
import com.pi4j.io.gpio.GpioPinShutdown;
import com.pi4j.io.gpio.GpioProvider;
import com.pi4j.io.gpio.Pin;
import com.pi4j.io.gpio.PinMode;
import com.pi4j.io.gpio.PinPullResistance;
import com.pi4j.io.gpio.PinState;
import com.pi4j.io.gpio.event.GpioPinListener;
import com.pi4j.io.gpio.exception.GpioPinExistsException;
import com.pi4j.io.gpio.exception.GpioPinNotProvisionedException;
import com.pi4j.io.gpio.exception.PinProviderException;
import com.pi4j.io.gpio.exception.UnsupportedPinEventsException;
import com.pi4j.io.gpio.impl.GpioPinImpl;
import com.pi4j.io.gpio.trigger.GpioTrigger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class GpioControllerImpl
implements GpioController {
    private final List<GpioPin> pins = Collections.synchronizedList(new ArrayList());
    private final GpioProvider defaultProvider;
    private boolean isshutdown = false;

    public GpioControllerImpl() {
        this(GpioFactory.getDefaultProvider());
    }

    public GpioControllerImpl(GpioProvider provider) {
        this.defaultProvider = provider;
        Runtime.getRuntime().addShutdownHook(new ShutdownHook());
    }

    @Override
    public Collection<GpioPin> getProvisionedPins() {
        return this.pins;
    }

    @Override
    public void unexportAll() {
        for (GpioPin pin : this.pins) {
            if (!pin.isExported()) continue;
            pin.unexport();
        }
    }

    @Override
    public void export(PinMode mode, GpioPin ... pin) {
        this.export(mode, (PinState)null, pin);
    }

    @Override
    public void export(PinMode mode, PinState defaultState, GpioPin ... pin) {
        if (pin == null || pin.length == 0) {
            throw new IllegalArgumentException("Missing pin argument.");
        }
        for (GpioPin p : pin) {
            if (!this.pins.contains(p)) {
                throw new GpioPinNotProvisionedException(p.getPin());
            }
            p.export(mode, defaultState);
        }
    }

    @Override
    public boolean isExported(GpioPin ... pin) {
        if (pin == null || pin.length == 0) {
            throw new IllegalArgumentException("Missing pin argument.");
        }
        for (GpioPin p : pin) {
            if (!this.pins.contains(p)) {
                throw new GpioPinNotProvisionedException(p.getPin());
            }
            if (p.isExported()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void unexport(GpioPin ... pin) {
        if (pin == null || pin.length == 0) {
            throw new IllegalArgumentException("Missing pin argument.");
        }
        for (GpioPin p : pin) {
            if (!this.pins.contains(p)) {
                throw new GpioPinNotProvisionedException(p.getPin());
            }
            p.unexport();
        }
    }

    @Override
    public PinMode getMode(GpioPin pin) {
        if (!this.pins.contains(pin)) {
            throw new GpioPinNotProvisionedException(pin.getPin());
        }
        return pin.getMode();
    }

    @Override
    public boolean isMode(PinMode mode, GpioPin ... pin) {
        if (pin == null || pin.length == 0) {
            throw new IllegalArgumentException("Missing pin argument.");
        }
        for (GpioPin p : pin) {
            if (p.isMode(mode)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setMode(PinMode mode, GpioPin ... pin) {
        if (pin == null || pin.length == 0) {
            throw new IllegalArgumentException("Missing pin argument.");
        }
        for (GpioPin p : pin) {
            if (!this.pins.contains(p)) {
                throw new GpioPinNotProvisionedException(p.getPin());
            }
            p.setMode(mode);
        }
    }

    @Override
    public void setPullResistance(PinPullResistance resistance, GpioPin ... pin) {
        if (pin == null || pin.length == 0) {
            throw new IllegalArgumentException("Missing pin argument.");
        }
        for (GpioPin p : pin) {
            if (!this.pins.contains(p)) {
                throw new GpioPinNotProvisionedException(p.getPin());
            }
            p.setPullResistance(resistance);
        }
    }

    @Override
    public PinPullResistance getPullResistance(GpioPin pin) {
        if (!this.pins.contains(pin)) {
            throw new GpioPinNotProvisionedException(pin.getPin());
        }
        return pin.getPullResistance();
    }

    @Override
    public boolean isPullResistance(PinPullResistance resistance, GpioPin ... pin) {
        if (pin == null || pin.length == 0) {
            throw new IllegalArgumentException("Missing pin argument.");
        }
        for (GpioPin p : pin) {
            if (!this.pins.contains(p)) {
                throw new GpioPinNotProvisionedException(p.getPin());
            }
            if (p.isPullResistance(resistance)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void high(GpioPinDigitalOutput ... pin) {
        if (pin == null || pin.length == 0) {
            throw new IllegalArgumentException("Missing pin argument.");
        }
        for (GpioPinDigitalOutput p : pin) {
            if (!this.pins.contains(p)) {
                throw new GpioPinNotProvisionedException(p.getPin());
            }
            p.high();
        }
    }

    @Override
    public void low(GpioPinDigitalOutput ... pin) {
        if (pin == null || pin.length == 0) {
            throw new IllegalArgumentException("Missing pin argument.");
        }
        for (GpioPinDigitalOutput p : pin) {
            if (!this.pins.contains(p)) {
                throw new GpioPinNotProvisionedException(p.getPin());
            }
            p.low();
        }
    }

    @Override
    public boolean isHigh(GpioPinDigital ... pin) {
        if (pin == null || pin.length == 0) {
            throw new IllegalArgumentException("Missing pin argument.");
        }
        for (GpioPinDigital p : pin) {
            if (!p.isLow()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isLow(GpioPinDigital ... pin) {
        if (pin == null || pin.length == 0) {
            throw new IllegalArgumentException("Missing pin argument.");
        }
        for (GpioPinDigital p : pin) {
            if (!p.isHigh()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void toggle(GpioPinDigitalOutput ... pin) {
        if (pin == null || pin.length == 0) {
            throw new IllegalArgumentException("Missing pin argument.");
        }
        for (GpioPinDigitalOutput p : pin) {
            if (!this.pins.contains(p)) {
                throw new GpioPinNotProvisionedException(p.getPin());
            }
            p.toggle();
        }
    }

    @Override
    public void pulse(long milliseconds, GpioPinDigitalOutput ... pin) {
        if (pin == null || pin.length == 0) {
            throw new IllegalArgumentException("Missing pin argument.");
        }
        for (GpioPinDigitalOutput p : pin) {
            if (!this.pins.contains(p)) {
                throw new GpioPinNotProvisionedException(p.getPin());
            }
            p.pulse(milliseconds);
        }
    }

    @Override
    public void setState(PinState state, GpioPinDigitalOutput ... pin) {
        if (pin == null || pin.length == 0) {
            throw new IllegalArgumentException("Missing pin argument.");
        }
        for (GpioPinDigitalOutput p : pin) {
            if (!this.pins.contains(p)) {
                throw new GpioPinNotProvisionedException(p.getPin());
            }
            p.setState(state);
        }
    }

    @Override
    public void setState(boolean state, GpioPinDigitalOutput ... pin) {
        this.setState(state ? PinState.HIGH : PinState.LOW, pin);
    }

    @Override
    public PinState getState(GpioPinDigital pin) {
        if (!this.pins.contains(pin)) {
            throw new GpioPinNotProvisionedException(pin.getPin());
        }
        return pin.getState();
    }

    @Override
    public boolean isState(PinState state, GpioPinDigital ... pin) {
        if (pin == null || pin.length == 0) {
            throw new IllegalArgumentException("Missing pin argument.");
        }
        for (GpioPinDigital p : pin) {
            if (p.isState(state)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setValue(double value, GpioPinAnalogOutput ... pin) {
        if (pin == null || pin.length == 0) {
            throw new IllegalArgumentException("Missing pin argument.");
        }
        for (GpioPinAnalogOutput p : pin) {
            if (!this.pins.contains(p)) {
                throw new GpioPinNotProvisionedException(p.getPin());
            }
            p.setValue(value);
        }
    }

    @Override
    public double getValue(GpioPinAnalog pin) {
        return pin.getValue();
    }

    @Override
    public synchronized void addListener(GpioPinListener listener, GpioPinInput ... pin) {
        if (pin == null || pin.length == 0) {
            throw new IllegalArgumentException("Missing pin argument.");
        }
        for (GpioPinInput p : pin) {
            if (!this.pins.contains(p)) {
                throw new GpioPinNotProvisionedException(p.getPin());
            }
            if (!p.getPin().supportsPinEvents()) {
                throw new UnsupportedPinEventsException(p.getPin());
            }
            p.addListener(listener);
        }
    }

    @Override
    public synchronized void addListener(GpioPinListener[] listeners, GpioPinInput ... pin) {
        if (pin == null || pin.length == 0) {
            throw new IllegalArgumentException("Missing pin argument.");
        }
        for (GpioPinListener listener : listeners) {
            this.addListener(listener, pin);
        }
    }

    @Override
    public synchronized void removeListener(GpioPinListener listener, GpioPinInput ... pin) {
        if (pin == null || pin.length == 0) {
            throw new IllegalArgumentException("Missing pin argument.");
        }
        for (GpioPinInput p : pin) {
            if (!this.pins.contains(p)) {
                throw new GpioPinNotProvisionedException(p.getPin());
            }
            if (!p.getPin().supportsPinEvents()) {
                throw new UnsupportedPinEventsException(p.getPin());
            }
            p.removeListener(listener);
        }
    }

    @Override
    public synchronized void removeListener(GpioPinListener[] listeners, GpioPinInput ... pin) {
        if (pin == null || pin.length == 0) {
            throw new IllegalArgumentException("Missing pin argument.");
        }
        for (GpioPinListener listener : listeners) {
            this.removeListener(listener, pin);
        }
    }

    @Override
    public synchronized void removeAllListeners() {
        for (GpioPin pin : this.pins) {
            if (!(pin instanceof GpioPinInput)) continue;
            ((GpioPinInput)pin).removeAllListeners();
        }
    }

    @Override
    public synchronized void addTrigger(GpioTrigger trigger, GpioPinInput ... pin) {
        if (pin == null || pin.length == 0) {
            throw new IllegalArgumentException("Missing pin argument.");
        }
        for (GpioPinInput p : pin) {
            if (!this.pins.contains(p)) {
                throw new GpioPinNotProvisionedException(p.getPin());
            }
            p.addTrigger(trigger);
        }
    }

    @Override
    public synchronized void addTrigger(GpioTrigger[] triggers, GpioPinInput ... pin) {
        if (pin == null || pin.length == 0) {
            throw new IllegalArgumentException("Missing pin argument.");
        }
        for (GpioTrigger trigger : triggers) {
            this.addTrigger(trigger, pin);
        }
    }

    @Override
    public synchronized void removeTrigger(GpioTrigger trigger, GpioPinInput ... pin) {
        if (pin == null || pin.length == 0) {
            throw new IllegalArgumentException("Missing pin argument.");
        }
        for (GpioPinInput p : pin) {
            if (!this.pins.contains(p)) {
                throw new GpioPinNotProvisionedException(p.getPin());
            }
            p.removeTrigger(trigger);
        }
    }

    @Override
    public synchronized void removeTrigger(GpioTrigger[] triggers, GpioPinInput ... pin) {
        if (pin == null || pin.length == 0) {
            throw new IllegalArgumentException("Missing pin argument.");
        }
        for (GpioTrigger trigger : triggers) {
            this.removeTrigger(trigger, pin);
        }
    }

    @Override
    public synchronized void removeAllTriggers() {
        for (GpioPin pin : this.pins) {
            if (!(pin instanceof GpioPinInput)) continue;
            ((GpioPinInput)pin).removeAllTriggers();
        }
    }

    @Override
    public GpioPin provisionPin(GpioProvider provider, Pin pin, PinMode mode) {
        return this.provisionPin(provider, pin, pin.getName(), mode);
    }

    @Override
    public GpioPin provisionPin(GpioProvider provider, Pin pin, String name, PinMode mode) {
        return this.provisionPin(provider, pin, name, mode, null);
    }

    @Override
    public GpioPin provisionPin(GpioProvider provider, Pin pin, String name, PinMode mode, PinState defaultState) {
        if (!provider.getName().equals(pin.getProvider())) {
            throw new PinProviderException(provider, pin);
        }
        for (GpioPin p : this.pins) {
            if (!p.getProvider().equals(provider) || !p.getPin().equals(pin)) continue;
            throw new GpioPinExistsException(pin);
        }
        GpioPinImpl gpioPin = new GpioPinImpl(this, provider, pin);
        if (name != null) {
            gpioPin.setName(name);
        }
        gpioPin.export(mode, defaultState);
        this.pins.add(gpioPin);
        return gpioPin;
    }

    @Override
    public GpioPin provisionPin(Pin pin, String name, PinMode mode) {
        return this.provisionPin(this.defaultProvider, pin, name, mode);
    }

    @Override
    public GpioPin provisionPin(Pin pin, PinMode mode) {
        return this.provisionPin(this.defaultProvider, pin, mode);
    }

    @Override
    public GpioPinDigitalMultipurpose provisionDigitalMultipurposePin(GpioProvider provider, Pin pin, String name, PinMode mode) {
        return (GpioPinDigitalMultipurpose)this.provisionPin(provider, pin, name, mode);
    }

    @Override
    public GpioPinDigitalMultipurpose provisionDigitalMultipurposePin(GpioProvider provider, Pin pin, PinMode mode) {
        return (GpioPinDigitalMultipurpose)this.provisionPin(provider, pin, mode);
    }

    @Override
    public GpioPinDigitalMultipurpose provisionDigitalMultipurposePin(Pin pin, String name, PinMode mode) {
        return this.provisionDigitalMultipurposePin(this.defaultProvider, pin, name, mode);
    }

    @Override
    public GpioPinDigitalMultipurpose provisionDigitalMultipurposePin(Pin pin, PinMode mode) {
        return this.provisionDigitalMultipurposePin(this.defaultProvider, pin, mode);
    }

    @Override
    public GpioPinDigitalMultipurpose provisionDigitalMultipurposePin(GpioProvider provider, Pin pin, PinMode mode, PinPullResistance resistance) {
        return this.provisionDigitalMultipurposePin(provider, pin, pin.getName(), mode, resistance);
    }

    @Override
    public GpioPinDigitalMultipurpose provisionDigitalMultipurposePin(GpioProvider provider, Pin pin, String name, PinMode mode, PinPullResistance resistance) {
        GpioPinDigitalMultipurpose gpioPin = this.provisionDigitalMultipurposePin(provider, pin, name, mode);
        if (resistance != null) {
            gpioPin.setPullResistance(resistance);
        }
        return gpioPin;
    }

    @Override
    public GpioPinDigitalMultipurpose provisionDigitalMultipurposePin(Pin pin, String name, PinMode mode, PinPullResistance resistance) {
        return this.provisionDigitalMultipurposePin(this.defaultProvider, pin, name, mode, resistance);
    }

    @Override
    public GpioPinDigitalMultipurpose provisionDigitalMultipurposePin(Pin pin, PinMode mode, PinPullResistance resistance) {
        return this.provisionDigitalMultipurposePin(this.defaultProvider, pin, mode, resistance);
    }

    @Override
    public GpioPinDigitalInput provisionDigitalInputPin(GpioProvider provider, Pin pin, String name) {
        return (GpioPinDigitalInput)this.provisionPin(provider, pin, name, PinMode.DIGITAL_INPUT);
    }

    @Override
    public GpioPinDigitalInput provisionDigitalInputPin(GpioProvider provider, Pin pin) {
        return (GpioPinDigitalInput)this.provisionPin(provider, pin, PinMode.DIGITAL_INPUT);
    }

    @Override
    public GpioPinDigitalInput provisionDigitalInputPin(Pin pin, String name) {
        return this.provisionDigitalInputPin(this.defaultProvider, pin, name);
    }

    @Override
    public GpioPinDigitalInput provisionDigitalInputPin(Pin pin) {
        return this.provisionDigitalInputPin(this.defaultProvider, pin);
    }

    @Override
    public GpioPinDigitalInput provisionDigitalInputPin(GpioProvider provider, Pin pin, PinPullResistance resistance) {
        return this.provisionDigitalInputPin(provider, pin, pin.getName(), resistance);
    }

    @Override
    public GpioPinDigitalInput provisionDigitalInputPin(GpioProvider provider, Pin pin, String name, PinPullResistance resistance) {
        GpioPinDigitalInput gpioPin = this.provisionDigitalInputPin(provider, pin, name);
        if (resistance != null) {
            gpioPin.setPullResistance(resistance);
        }
        return gpioPin;
    }

    @Override
    public GpioPinDigitalInput provisionDigitalInputPin(Pin pin, String name, PinPullResistance resistance) {
        return this.provisionDigitalInputPin(this.defaultProvider, pin, name, resistance);
    }

    @Override
    public GpioPinDigitalInput provisionDigitalInputPin(Pin pin, PinPullResistance resistance) {
        return this.provisionDigitalInputPin(this.defaultProvider, pin, resistance);
    }

    @Override
    public GpioPinDigitalOutput provisionDigitalOutputPin(GpioProvider provider, Pin pin, String name) {
        return (GpioPinDigitalOutput)this.provisionPin(provider, pin, name, PinMode.DIGITAL_OUTPUT);
    }

    @Override
    public GpioPinDigitalOutput provisionDigitalOutputPin(GpioProvider provider, Pin pin) {
        return (GpioPinDigitalOutput)this.provisionPin(provider, pin, PinMode.DIGITAL_OUTPUT);
    }

    @Override
    public GpioPinDigitalOutput provisionDigitalOutputPin(Pin pin, String name) {
        return this.provisionDigitalOutputPin(this.defaultProvider, pin, name);
    }

    @Override
    public GpioPinDigitalOutput provisionDigitalOutputPin(Pin pin) {
        return this.provisionDigitalOutputPin(this.defaultProvider, pin);
    }

    @Override
    public GpioPinDigitalOutput provisionDigitalOutputPin(GpioProvider provider, Pin pin, PinState defaultState) {
        return this.provisionDigitalOutputPin(provider, pin, pin.getName(), defaultState);
    }

    @Override
    public GpioPinDigitalOutput provisionDigitalOutputPin(GpioProvider provider, Pin pin, String name, PinState defaultState) {
        GpioPinDigitalOutput gpioPin = (GpioPinDigitalOutput)this.provisionPin(provider, pin, name, PinMode.DIGITAL_OUTPUT, defaultState);
        if (defaultState != null) {
            gpioPin.setState(defaultState);
        }
        return gpioPin;
    }

    @Override
    public GpioPinDigitalOutput provisionDigitalOutputPin(Pin pin, String name, PinState defaultState) {
        return this.provisionDigitalOutputPin(this.defaultProvider, pin, name, defaultState);
    }

    @Override
    public GpioPinDigitalOutput provisionDigitalOutputPin(Pin pin, PinState defaultState) {
        return this.provisionDigitalOutputPin(this.defaultProvider, pin, defaultState);
    }

    @Override
    public GpioPinAnalogInput provisionAnalogInputPin(GpioProvider provider, Pin pin, String name) {
        return (GpioPinAnalogInput)this.provisionPin(provider, pin, name, PinMode.ANALOG_INPUT);
    }

    @Override
    public GpioPinAnalogInput provisionAnalogInputPin(GpioProvider provider, Pin pin) {
        return (GpioPinAnalogInput)this.provisionPin(provider, pin, PinMode.ANALOG_INPUT);
    }

    @Override
    public GpioPinAnalogInput provisionAnalogInputPin(Pin pin, String name) {
        return this.provisionAnalogInputPin(this.defaultProvider, pin, name);
    }

    @Override
    public GpioPinAnalogInput provisionAnalogInputPin(Pin pin) {
        return this.provisionAnalogInputPin(this.defaultProvider, pin);
    }

    @Override
    public GpioPinAnalogOutput provisionAnalogOutputPin(GpioProvider provider, Pin pin, String name) {
        return (GpioPinAnalogOutput)this.provisionPin(provider, pin, name, PinMode.ANALOG_OUTPUT);
    }

    @Override
    public GpioPinAnalogOutput provisionAnalogOutputPin(GpioProvider provider, Pin pin) {
        return (GpioPinAnalogOutput)this.provisionPin(provider, pin, PinMode.ANALOG_OUTPUT);
    }

    @Override
    public GpioPinAnalogOutput provisionAnalogOutputPin(Pin pin, String name) {
        return this.provisionAnalogOutputPin(this.defaultProvider, pin, name);
    }

    @Override
    public GpioPinAnalogOutput provisionAnalogOutputPin(Pin pin) {
        return this.provisionAnalogOutputPin(this.defaultProvider, pin);
    }

    @Override
    public GpioPinAnalogOutput provisionAnalogOutputPin(GpioProvider provider, Pin pin, double defaultValue) {
        return this.provisionAnalogOutputPin(provider, pin, pin.getName(), defaultValue);
    }

    @Override
    public GpioPinAnalogOutput provisionAnalogOutputPin(GpioProvider provider, Pin pin, String name, double defaultValue) {
        GpioPinAnalogOutput gpioPin = this.provisionAnalogOutputPin(provider, pin, name);
        gpioPin.setValue(defaultValue);
        return gpioPin;
    }

    @Override
    public GpioPinAnalogOutput provisionAnalogOutputPin(Pin pin, String name, double defaultValue) {
        return this.provisionAnalogOutputPin(this.defaultProvider, pin, name, defaultValue);
    }

    @Override
    public GpioPinAnalogOutput provisionAnalogOutputPin(Pin pin, double defaultValue) {
        return this.provisionAnalogOutputPin(this.defaultProvider, pin, defaultValue);
    }

    @Override
    public GpioPinPwmOutput provisionPwmOutputPin(GpioProvider provider, Pin pin, String name) {
        return (GpioPinPwmOutput)this.provisionPin(provider, pin, name, PinMode.PWM_OUTPUT);
    }

    @Override
    public GpioPinPwmOutput provisionPwmOutputPin(GpioProvider provider, Pin pin) {
        return (GpioPinPwmOutput)this.provisionPin(provider, pin, PinMode.PWM_OUTPUT);
    }

    @Override
    public GpioPinPwmOutput provisionPwmOutputPin(Pin pin, String name) {
        return this.provisionPwmOutputPin(this.defaultProvider, pin, name);
    }

    @Override
    public GpioPinPwmOutput provisionPwmOutputPin(Pin pin) {
        return this.provisionPwmOutputPin(this.defaultProvider, pin);
    }

    @Override
    public GpioPinPwmOutput provisionPwmOutputPin(GpioProvider provider, Pin pin, int defaultValue) {
        return this.provisionPwmOutputPin(provider, pin, pin.getName(), defaultValue);
    }

    @Override
    public GpioPinPwmOutput provisionPwmOutputPin(GpioProvider provider, Pin pin, String name, int defaultValue) {
        GpioPinPwmOutput gpioPin = this.provisionPwmOutputPin(provider, pin, name);
        gpioPin.setPwm(defaultValue);
        return gpioPin;
    }

    @Override
    public GpioPinPwmOutput provisionPwmOutputPin(Pin pin, String name, int defaultValue) {
        return this.provisionPwmOutputPin(this.defaultProvider, pin, name, defaultValue);
    }

    @Override
    public GpioPinPwmOutput provisionPwmOutputPin(Pin pin, int defaultValue) {
        return this.provisionPwmOutputPin(this.defaultProvider, pin, defaultValue);
    }

    @Override
    public GpioPinPwmOutput provisionSoftPwmOutputPin(GpioProvider provider, Pin pin, String name) {
        return (GpioPinPwmOutput)this.provisionPin(provider, pin, name, PinMode.SOFT_PWM_OUTPUT);
    }

    @Override
    public GpioPinPwmOutput provisionSoftPwmOutputPin(GpioProvider provider, Pin pin) {
        return (GpioPinPwmOutput)this.provisionPin(provider, pin, PinMode.SOFT_PWM_OUTPUT);
    }

    @Override
    public GpioPinPwmOutput provisionSoftPwmOutputPin(Pin pin, String name) {
        return this.provisionSoftPwmOutputPin(this.defaultProvider, pin, name);
    }

    @Override
    public GpioPinPwmOutput provisionSoftPwmOutputPin(Pin pin) {
        return this.provisionSoftPwmOutputPin(this.defaultProvider, pin);
    }

    @Override
    public GpioPinPwmOutput provisionSoftPwmOutputPin(GpioProvider provider, Pin pin, int defaultValue) {
        return this.provisionSoftPwmOutputPin(provider, pin, pin.getName(), defaultValue);
    }

    @Override
    public GpioPinPwmOutput provisionSoftPwmOutputPin(GpioProvider provider, Pin pin, String name, int defaultValue) {
        GpioPinPwmOutput gpioPin = this.provisionSoftPwmOutputPin(provider, pin, name);
        gpioPin.setPwm(defaultValue);
        return gpioPin;
    }

    @Override
    public GpioPinPwmOutput provisionSoftPwmOutputPin(Pin pin, String name, int defaultValue) {
        return this.provisionSoftPwmOutputPin(this.defaultProvider, pin, name, defaultValue);
    }

    @Override
    public GpioPinPwmOutput provisionSoftPwmOutputPin(Pin pin, int defaultValue) {
        return this.provisionSoftPwmOutputPin(this.defaultProvider, pin, defaultValue);
    }

    @Override
    public void unprovisionPin(GpioPin ... pin) {
        if (pin == null || pin.length == 0) {
            throw new IllegalArgumentException("Missing pin argument.");
        }
        for (int index = pin.length - 1; index >= 0; --index) {
            GpioPin p = pin[index];
            if (!this.pins.contains(p)) {
                throw new GpioPinNotProvisionedException(p.getPin());
            }
            if (p instanceof GpioPinInput) {
                ((GpioPinInput)p).removeAllListeners();
                ((GpioPinInput)p).removeAllTriggers();
            }
            this.pins.remove(p);
        }
    }

    @Override
    public void setShutdownOptions(GpioPinShutdown options, GpioPin ... pin) {
        for (GpioPin p : pin) {
            if (!this.pins.contains(p)) {
                throw new GpioPinNotProvisionedException(p.getPin());
            }
            p.setShutdownOptions(options);
        }
    }

    @Override
    public void setShutdownOptions(Boolean unexport, GpioPin ... pin) {
        for (GpioPin p : pin) {
            if (!this.pins.contains(p)) {
                throw new GpioPinNotProvisionedException(p.getPin());
            }
            p.setShutdownOptions(unexport);
        }
    }

    @Override
    public void setShutdownOptions(Boolean unexport, PinState state, GpioPin ... pin) {
        for (GpioPin p : pin) {
            if (!this.pins.contains(p)) {
                throw new GpioPinNotProvisionedException(p.getPin());
            }
            p.setShutdownOptions(unexport, state);
        }
    }

    @Override
    public void setShutdownOptions(Boolean unexport, PinState state, PinPullResistance resistance, GpioPin ... pin) {
        for (GpioPin p : pin) {
            if (!this.pins.contains(p)) {
                throw new GpioPinNotProvisionedException(p.getPin());
            }
            p.setShutdownOptions(unexport, state, resistance);
        }
    }

    @Override
    public void setShutdownOptions(Boolean unexport, PinState state, PinPullResistance resistance, PinMode mode, GpioPin ... pin) {
        for (GpioPin p : pin) {
            if (!this.pins.contains(p)) {
                throw new GpioPinNotProvisionedException(p.getPin());
            }
            p.setShutdownOptions(unexport, state, resistance, mode);
        }
    }

    @Override
    public boolean isShutdown() {
        return this.isshutdown;
    }

    @Override
    public synchronized void shutdown() {
        if (this.isShutdown()) {
            return;
        }
        GpioFactory.getExecutorServiceFactory().shutdown();
        for (GpioPin pin : this.pins) {
            GpioPinShutdown shutdownOptions;
            if (!pin.getProvider().isShutdown()) {
                pin.getProvider().shutdown();
            }
            if ((shutdownOptions = pin.getShutdownOptions()) == null) continue;
            PinState state = shutdownOptions.getState();
            PinMode mode = shutdownOptions.getMode();
            PinPullResistance resistance = shutdownOptions.getPullResistor();
            Boolean unexport = shutdownOptions.getUnexport();
            if (state != null && pin instanceof GpioPinDigitalOutput) {
                ((GpioPinDigitalOutput)pin).setState(state);
            }
            if (resistance != null) {
                pin.setPullResistance(resistance);
            }
            if (mode != null) {
                pin.setMode(mode);
            }
            if (unexport == null || unexport != Boolean.TRUE) continue;
            pin.unexport();
        }
        this.isshutdown = true;
    }

    private class ShutdownHook
    extends Thread {
        private ShutdownHook() {
        }

        @Override
        public void run() {
            GpioControllerImpl.this.shutdown();
        }
    }
}

