/*
 * Decompiled with CFR 0.152.
 */
package com.wabit.uecs.util;

public class HortCalculator {
    private static final double ZERO_C = 273.15;

    private HortCalculator() {
    }

    public static double getSWVP(double temp) {
        double atemp = temp + 273.15;
        return Math.pow(2.71828182845904, -6096.9385 * Math.pow(atemp, -1.0) + 21.2409642 - 2.711193 * Math.pow(10.0, -2.0) * atemp + 1.673952 * Math.pow(10.0, -5.0) * Math.pow(atemp, 2.0) + 2.433502 * Math.log(atemp));
    }

    public static double getWVP(double temp, double humid) {
        return HortCalculator.getSWVP(temp) * humid / 100.0;
    }

    public static double getAbsoluteHumidity(double temp, double humid) {
        return 2.17 * HortCalculator.getWVP(temp, humid) / (temp + 273.15);
    }

    public static double getHumidityDeficit(double temp, double humid) {
        return 2.17 * ((100.0 - humid) / 100.0 * HortCalculator.getSWVP(temp) / (temp + 273.15));
    }

    public static double getDewPoint(double temp, double humid) {
        double wvp = HortCalculator.getWVP(temp, humid);
        return 13.715 * Math.log(wvp / 611.213) + 0.8426199999999999 * Math.pow(Math.log(wvp / 611.213), 2.0) + 0.019048 * Math.pow(Math.log(wvp / 611.213), 3.0) + 0.0078158 * Math.pow(Math.log(wvp / 611.213), 4.0);
    }
}

