/*
 * Decompiled with CFR 0.152.
 */
package com.wabit.uecs.protocol;

import com.wabit.uecs.CcmID;
import com.wabit.uecs.protocol.XmlCcm;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ServerCcm
extends XmlCcm {
    public static final String TAG_SERVER = "SERVER";
    private InetAddress ipAddress;

    public InetAddress getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(InetAddress address) {
        this.ipAddress = address;
    }

    @Override
    void appendXml(StringBuilder sb) {
        sb.append("<").append(TAG_SERVER);
        if (this.getType() != null) {
            sb.append(" ").append("type").append("=\"").append(ServerCcm.escape(this.getType())).append("\"");
        }
        if (this.getRoom() > -1) {
            sb.append(" ").append("room").append("=\"").append(this.getRoom()).append("\"");
        }
        if (this.getRegion() > -1) {
            sb.append(" ").append("region").append("=\"").append(this.getRegion()).append("\"");
        }
        if (this.getOrder() > -1) {
            sb.append(" ").append("order").append("=\"").append(this.getOrder()).append("\"");
        }
        if (this.getPriority() > -1) {
            sb.append(" ").append("priority").append("=\"").append(this.getPriority()).append("\"");
        }
        if (this.ipAddress != null) {
            sb.append(">");
            sb.append(this.ipAddress.getHostAddress());
            sb.append("</").append(TAG_SERVER).append(">");
        } else {
            sb.append("/>");
        }
    }

    @Override
    void importXml(Document doc) throws Exception {
        Element elm = (Element)doc.getElementsByTagName(TAG_SERVER).item(0);
        String val = elm.getAttribute("type");
        if (val.length() != 0) {
            this.setType(new CcmID(val));
        }
        if ((val = elm.getAttribute("room")).length() != 0) {
            this.setRoom(Integer.parseInt(val));
        } else {
            this.setRoom(0);
        }
        val = elm.getAttribute("region");
        if (val.length() != 0) {
            this.setRegion(Integer.parseInt(val));
        } else {
            this.setRegion(0);
        }
        val = elm.getAttribute("order");
        if (val.length() != 0) {
            this.setOrder(Integer.parseInt(val));
        } else {
            this.setOrder(0);
        }
        val = elm.getAttribute("priority");
        if (val.length() != 0) {
            this.setPriority(Integer.parseInt(val));
        } else {
            this.setPriority(0);
        }
        val = elm.getFirstChild().getNodeValue();
        if (val != null && val.length() != 0) {
            this.setIpAddress(InetAddress.getByName(val));
        }
    }

    @Override
    public int getPort() {
        return 16521;
    }

    @Override
    void setXmlAttributes(String tagName, Attributes attributes) {
        if (TAG_SERVER.equals(tagName)) {
            String val = attributes.getValue("type");
            if (val.length() != 0) {
                this.setType(new CcmID(val));
            }
            if ((val = attributes.getValue("room")).length() != 0) {
                this.setRoom(Integer.parseInt(val));
            } else {
                this.setRoom(0);
            }
            val = attributes.getValue("region");
            if (val.length() != 0) {
                this.setRegion(Integer.parseInt(val));
            } else {
                this.setRegion(0);
            }
            val = attributes.getValue("order");
            if (val.length() != 0) {
                this.setOrder(Integer.parseInt(val));
            } else {
                this.setOrder(0);
            }
            val = attributes.getValue("priority");
            if (val.length() != 0) {
                this.setPriority(Integer.parseInt(val));
            } else {
                this.setPriority(0);
            }
        }
    }

    @Override
    void setXmlValue(String tagName, String value) throws SAXException {
        if (TAG_SERVER.equals(tagName) && value != null && value.length() != 0) {
            try {
                this.setIpAddress(InetAddress.getByName(value));
            }
            catch (UnknownHostException e) {
                throw new SAXException(e);
            }
        }
    }
}

