/*
 * Decompiled with CFR 0.152.
 */
package com.wabit.uecs;

import com.wabit.uecs.ActionMode;
import com.wabit.uecs.Ccm;
import com.wabit.uecs.CcmService;
import com.wabit.uecs.ICcmServiceListener;
import com.wabit.uecs.IUecsNode;
import com.wabit.uecs.IUecsNodeListener;
import com.wabit.uecs.IUecsProtocolHandler;
import com.wabit.uecs.NodeConfig;
import com.wabit.uecs.NodeRuntimeException;
import com.wabit.uecs.UecsRequest;
import com.wabit.uecs.UecsResponse;
import com.wabit.uecs.ccm.CndCcm;
import com.wabit.uecs.device.IDevice;
import com.wabit.uecs.protocol.DataCcm;
import com.wabit.uecs.util.PropertyConfig;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public abstract class AbstractUecsNode<T extends NodeConfig>
implements IUecsNode<T> {
    private static final String DELAY_TIME = "delay_time";
    private static final long DEFAULT_DELAY = 50L;
    private String uecsVersion;
    private InetAddress broadcastAddress;
    private InetAddress ipAddress;
    private byte[] macAddress;
    private String vender;
    private String uecsID;
    private DatagramSocket sendSocket = null;
    private T config;
    private String name;
    private boolean isActive = false;
    private int status = 0;
    private CcmService cndCcmService;
    private ScheduledExecutorService cycleExecutor;
    private ExecutorService eventExecutor;
    private List<CcmService> ccmList = Collections.synchronizedList(new ArrayList());
    private List<UdpServer> servers = Collections.synchronizedList(new ArrayList());
    private List<IUecsProtocolHandler> protocols = Collections.synchronizedList(new ArrayList());
    private Map<String, IDevice<?>> deviceMap = Collections.synchronizedMap(new LinkedHashMap());
    private Set<IUecsNodeListener> listeners = Collections.synchronizedSet(new HashSet());

    public AbstractUecsNode(T conf) {
        this.config = conf;
    }

    @Override
    public void addListener(IUecsNodeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public List<IUecsNodeListener> getListeners() {
        return new ArrayList<IUecsNodeListener>(this.listeners);
    }

    @Override
    public boolean removeListener(IUecsNodeListener listener) {
        return this.listeners.remove(listener);
    }

    @Override
    public void addCcmService(CcmService ccm) {
        if (ccm != null) {
            ccm.setNode(this);
            this.ccmList.add(ccm);
        }
    }

    @Override
    public void clearCcmServices() {
        for (CcmService sv : this.ccmList) {
            sv.setNode(null);
        }
        this.ccmList.clear();
    }

    @Override
    public void addProtocol(IUecsProtocolHandler protocol) {
        if (protocol != null) {
            this.protocols.add(protocol);
        }
    }

    @Override
    public void clearProtocols() {
        this.protocols.clear();
    }

    @Override
    public int countCcm() {
        return this.ccmList.size();
    }

    void executeTask(Runnable task) {
        this.eventExecutor.execute(task);
    }

    @Override
    public InetAddress getBroadcastAddress() {
        return this.broadcastAddress;
    }

    @Override
    public int getCcmIndex(CcmService ccm) {
        return this.ccmList.indexOf(ccm);
    }

    @Override
    public CcmService getCcmService(int index) {
        if (index < 0 || index > this.ccmList.size() - 1) {
            return null;
        }
        return this.ccmList.get(index);
    }

    @Override
    public T getConfig() {
        return this.config;
    }

    @Override
    public InetAddress getIpAddress() {
        return this.ipAddress;
    }

    @Override
    public byte[] getMacAddress() {
        return this.macAddress;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getUecsID() {
        return this.uecsID;
    }

    @Override
    public String getUecsVersion() {
        return this.uecsVersion;
    }

    @Override
    public String getVender() {
        return this.vender;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public ActionMode getActionMode() {
        int modeBits = this.status & 0xF0000;
        return ActionMode.getMode(modeBits);
    }

    @Override
    public void setActionMode(ActionMode mode) {
        int modeBits = this.status & 0xF0000;
        this.status -= modeBits;
        this.status += mode.getBits();
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public List<CcmService> listCcmService() {
        return new ArrayList<CcmService>(this.ccmList);
    }

    @Override
    public CcmService removeCcmService(int index) {
        CcmService sv = this.ccmList.remove(index);
        if (sv != null) {
            sv.setNode(null);
        }
        return sv;
    }

    @Override
    public IDevice<?> getDevice(String deviceId) {
        return this.deviceMap.get(deviceId);
    }

    @Override
    public void addDevice(IDevice<?> device) {
        if (device != null) {
            this.deviceMap.put(device.getId(), device);
        }
    }

    @Override
    public void clearDevices() {
        this.deviceMap.clear();
    }

    @Override
    public List<IDevice<?>> listDevices() {
        return new ArrayList(this.deviceMap.values());
    }

    @Override
    public <U extends IDevice<?>> List<U> listDevices(Class<U> cls) {
        ArrayList list = new ArrayList();
        for (IDevice<?> compo : this.listDevices()) {
            if (!cls.isInstance(compo)) continue;
            list.add(compo);
        }
        return list;
    }

    @Override
    public void removeDevice(IDevice<?> device) {
        this.deviceMap.remove(device);
    }

    @Override
    public void sendPacket(InetAddress address, int port, byte[] data) {
        if (this.sendSocket == null) {
            return;
        }
        try {
            DatagramPacket packet = new DatagramPacket(data, data.length, address, port);
            this.sendSocket.send(packet);
        }
        catch (IOException e) {
            throw new NodeRuntimeException(e);
        }
    }

    public void setBroadcastAddress(InetAddress broadcastAddress) {
        this.broadcastAddress = broadcastAddress;
    }

    public void setIpAddress(InetAddress ipAddress) {
        this.ipAddress = ipAddress;
        if (ipAddress == null) {
            this.macAddress = null;
        } else {
            try {
                NetworkInterface nic = NetworkInterface.getByInetAddress(ipAddress);
                if (nic != null) {
                    this.macAddress = nic.getHardwareAddress();
                }
            }
            catch (SocketException e) {
                throw new NodeRuntimeException(e);
            }
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setUecsID(String uecsID) {
        this.uecsID = uecsID;
    }

    public void setUecsVersion(String uecsVersion) {
        this.uecsVersion = uecsVersion;
        for (CcmService sv : this.ccmList) {
            sv.getCcm().setUecsVersion(uecsVersion);
        }
    }

    public void setVender(String vender) {
        this.vender = vender;
    }

    @Override
    public void setStatus(int status) {
        this.status = status;
    }

    @Override
    public void onStatus(int onBits) {
        this.status |= onBits;
    }

    @Override
    public void offStatus(int offBits) {
        this.status &= ~offBits;
    }

    @Override
    public void setup() {
        if (this.isActive()) {
            NodeRuntimeException e = new NodeRuntimeException("node is active.");
            this.notifyException(e);
            throw e;
        }
        this.clearCcmServices();
        this.clearDevices();
        this.setUecsVersion(((PropertyConfig)this.config).getString("UecsVersion", "1.00-E10"));
        this.setUecsID(((PropertyConfig)this.config).getString("UecsId", ""));
        this.setName(((PropertyConfig)this.config).getString("NodeName", ""));
        this.setVender(((PropertyConfig)this.config).getString("Vender", ""));
        CndCcm cndCcm = new CndCcm(this, ((PropertyConfig)this.config).getString("NodeType", "cXX"));
        cndCcm.setRoom(((PropertyConfig)this.config).getInt("Room", 0));
        cndCcm.setRegion(((PropertyConfig)this.config).getInt("Region", 0));
        cndCcm.setOrder(((PropertyConfig)this.config).getInt("Order", 0));
        cndCcm.setPriority(((PropertyConfig)this.config).getInt("Priority", 0));
        this.cndCcmService = new CcmService(cndCcm);
        this.cndCcmService.setEnable(true);
        this.cndCcmService.setName(this.getName());
        this.cndCcmService.setValue(System.currentTimeMillis(), 0);
        this.addCcmService(this.cndCcmService);
        this.setStatus(0);
        try {
            String ip = ((PropertyConfig)this.config).getString("IpAddress", "");
            InetAddress iadr = null;
            if (ip.length() > 0) {
                iadr = InetAddress.getByName(ip);
            } else {
                InetAddress tmp_adr = null;
                Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
                block4: while (nics.hasMoreElements() && iadr == null) {
                    NetworkInterface nic = nics.nextElement();
                    Enumeration<InetAddress> adds = nic.getInetAddresses();
                    while (adds.hasMoreElements()) {
                        InetAddress adr = adds.nextElement();
                        if (!(adr instanceof Inet4Address) || adr.isLoopbackAddress()) continue;
                        tmp_adr = adr;
                        if (!adr.getHostAddress().startsWith("192.168.")) continue;
                        iadr = adr;
                        continue block4;
                    }
                }
                if (iadr == null && tmp_adr != null) {
                    iadr = tmp_adr;
                }
            }
            if (iadr == null) {
                try {
                    iadr = InetAddress.getLocalHost();
                }
                catch (Exception tmp_adr) {
                    // empty catch block
                }
            }
            this.setIpAddress(iadr);
            String bc = ((PropertyConfig)this.config).getString("BroadcastAddress", "");
            if (bc.length() != 0) {
                InetAddress badr = InetAddress.getByName(bc);
                this.setBroadcastAddress(badr);
            } else {
                this.setBroadcastAddress(InetAddress.getByAddress(new byte[]{-1, -1, -1, -1}));
            }
        }
        catch (Throwable t) {
            this.onStatus(0x4000000);
            NodeRuntimeException e = new NodeRuntimeException(t);
            this.notifyException(e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void start() {
        if (this.isActive) {
            return;
        }
        AbstractUecsNode abstractUecsNode = this;
        synchronized (abstractUecsNode) {
            ArrayList safeDevices = new ArrayList();
            for (IDevice<?> iDevice : this.deviceMap.values()) {
                try {
                    iDevice.init(this);
                    safeDevices.add(iDevice);
                }
                catch (Exception e) {
                    this.onStatus(0x4000000);
                    this.notifyException(e);
                }
            }
            for (IDevice<Object> iDevice : safeDevices) {
                try {
                    iDevice.start();
                }
                catch (Exception e) {
                    this.onStatus(0x4000000);
                    this.notifyException(e);
                }
            }
            try {
                this.eventExecutor = Executors.newFixedThreadPool(3);
                this.sendSocket = new DatagramSocket();
                this.sendSocket.setBroadcast(true);
                for (IUecsProtocolHandler iUecsProtocolHandler : this.protocols) {
                    UdpServer server = new UdpServer(iUecsProtocolHandler);
                    server.start();
                    this.servers.add(server);
                }
                this.cycleExecutor = Executors.newSingleThreadScheduledExecutor();
                boolean bl = false;
                for (CcmService ccmsv : this.ccmList) {
                    void var3_10;
                    ccmsv.onStart(this);
                    long time = ccmsv.getCcm().getLevel().getCycleTime();
                    if (time <= 0L) continue;
                    this.cycleExecutor.scheduleAtFixedRate(new CycleTask(ccmsv), ((PropertyConfig)this.config).getLong(DELAY_TIME, 50L) * (long)(++var3_10), time, TimeUnit.MILLISECONDS);
                }
                this.isActive = true;
            }
            catch (Throwable throwable) {
                this.onStatus(0x4000000);
                NodeRuntimeException e = new NodeRuntimeException(throwable);
                this.notifyException(e);
                throw e;
            }
        }
        for (IUecsNodeListener listener : this.listeners) {
            listener.nodeStarted(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (!this.isActive) {
            return;
        }
        this.isActive = false;
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
        AbstractUecsNode abstractUecsNode = this;
        synchronized (abstractUecsNode) {
            for (UdpServer udpServer : this.servers) {
                try {
                    udpServer.stop();
                }
                catch (Exception e) {
                    exceptions.add(e);
                }
            }
            this.servers.clear();
            try {
                this.eventExecutor.shutdown();
                this.eventExecutor = null;
            }
            catch (Throwable throwable) {
                exceptions.add(throwable);
            }
            for (CcmService ccmService : this.ccmList) {
                try {
                    ccmService.onStop(this);
                }
                catch (Exception e) {
                    exceptions.add(e);
                }
            }
            try {
                this.cycleExecutor.shutdown();
                this.cycleExecutor = null;
            }
            catch (Throwable throwable) {
                exceptions.add(throwable);
            }
            try {
                if (this.sendSocket != null && !this.sendSocket.isClosed()) {
                    this.sendSocket.close();
                    this.sendSocket = null;
                }
            }
            catch (Throwable throwable) {
                exceptions.add(throwable);
            }
        }
        abstractUecsNode = this;
        synchronized (abstractUecsNode) {
            for (IDevice iDevice : this.deviceMap.values()) {
                try {
                    iDevice.stop();
                }
                catch (Throwable t) {
                    exceptions.add(t);
                }
            }
        }
        if (exceptions.size() > 0) {
            for (Throwable t : exceptions) {
                this.notifyException(new NodeRuntimeException(t));
            }
        }
        for (IUecsNodeListener listener : this.listeners) {
            listener.nodeStopped(this);
        }
    }

    protected void notifyException(Exception e) {
        for (IUecsNodeListener listener : this.listeners) {
            listener.handleNodeException(this, e);
        }
    }

    private class CycleTask
    implements Runnable {
        private CcmService sv;

        private CycleTask(CcmService def) {
            this.sv = def;
        }

        @Override
        public void run() {
            if (this.sv.isEnable()) {
                Ccm ccm = this.sv.getCcm();
                if ('S' == ccm.getSide()) {
                    if (ccm.getNumberValue() != null) {
                        try {
                            DataCcm dccm = this.sv.createDataCcm(ccm);
                            AbstractUecsNode.this.sendPacket(AbstractUecsNode.this.getBroadcastAddress(), dccm.getPort(), dccm.toXmlBytes());
                            for (ICcmServiceListener lsn : this.sv.getListeners()) {
                                lsn.ccmSent(this.sv, dccm);
                            }
                            AbstractUecsNode.this.offStatus(0x8000000);
                        }
                        catch (Exception e) {
                            AbstractUecsNode.this.onStatus(0x8000000);
                            AbstractUecsNode.this.notifyException(e);
                        }
                    }
                } else if ('R' == ccm.getSide()) {
                    this.sv.checkExpiration();
                }
            }
        }
    }

    private class ReceiveTask
    implements Runnable {
        private IUecsProtocolHandler handler;
        private UecsRequest req;

        private ReceiveTask(IUecsProtocolHandler handler, byte[] data, InetAddress from) {
            this.handler = handler;
            this.req = new UecsRequest(from, handler.getPort(), data, System.currentTimeMillis());
        }

        @Override
        public void run() {
            UecsResponse res = new UecsResponse();
            try {
                this.handler.handle(this.req, res);
                if (res.isValid()) {
                    AbstractUecsNode.this.sendPacket(res.getAddress(), res.getPort(), res.getData());
                }
            }
            catch (Exception e) {
                AbstractUecsNode.this.onStatus(0x100000);
                this.handler.handleException(this.req, res, e);
            }
        }
    }

    private class UdpServer
    implements Runnable {
        private DatagramSocket receiveSocket;
        private Thread thread;
        private IUecsProtocolHandler handler;

        public UdpServer(IUecsProtocolHandler handler) {
            this.handler = handler;
        }

        @Override
        public void run() {
            byte[] buffer = new byte[512];
            DatagramPacket packet = new DatagramPacket(buffer, 512);
            while (true) {
                try {
                    while (true) {
                        this.receiveSocket.receive(packet);
                        int start = packet.getOffset();
                        int len = packet.getLength();
                        int i = len - 1;
                        while (i >= 0) {
                            if (buffer[i] != 0) break;
                            --len;
                            --i;
                        }
                        byte[] data = new byte[len];
                        System.arraycopy(buffer, start, data, 0, len);
                        InetAddress address = packet.getAddress();
                        AbstractUecsNode.this.eventExecutor.execute(new ReceiveTask(this.handler, data, address));
                        AbstractUecsNode.this.offStatus(0x100000);
                    }
                }
                catch (SocketException e) {
                }
                catch (Exception e) {
                    AbstractUecsNode.this.onStatus(0x100000);
                    AbstractUecsNode.this.notifyException(e);
                    continue;
                }
                break;
            }
        }

        public synchronized void start() {
            try {
                this.receiveSocket = new DatagramSocket(this.handler.getPort());
                this.receiveSocket.setReuseAddress(true);
                this.thread = new Thread(this);
                this.thread.start();
            }
            catch (SocketException e) {
                AbstractUecsNode.this.onStatus(0x4000000);
                AbstractUecsNode.this.notifyException(e);
                throw new NodeRuntimeException(e);
            }
        }

        public synchronized void stop() {
            if (this.receiveSocket != null && !this.receiveSocket.isClosed()) {
                this.receiveSocket.close();
            }
            this.receiveSocket = null;
            this.thread = null;
        }
    }
}

