/*
 * Decompiled with CFR 0.152.
 */
package com.wabit.uecs.protocol;

import com.wabit.uecs.Ccm;
import java.io.UnsupportedEncodingException;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;

public abstract class XmlCcm
extends Ccm {
    public static final String TAG_UECS = "UECS";
    public static final String ATTR_VER = "ver";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_ROOM = "room";
    public static final String ATTR_REGION = "region";
    public static final String ATTR_ORDER = "order";
    public static final String ATTR_PRIORITY = "priority";
    private long receivedTime = Long.MIN_VALUE;

    public long getReceivedTime() {
        return this.receivedTime;
    }

    public void setReceivedTime(long receivedTime) {
        this.receivedTime = receivedTime;
    }

    public String toXml() {
        StringBuilder sb = new StringBuilder(480);
        sb.append("<?xml version=\"1.0\"?>");
        sb.append("<").append(TAG_UECS);
        if (this.getUecsVersion() != null && this.getUecsVersion().length() > 0) {
            sb.append(" ").append(ATTR_VER).append("=\"").append(this.getUecsVersion()).append("\"");
        }
        sb.append(">");
        this.appendXml(sb);
        sb.append("</UECS>");
        return sb.toString();
    }

    static final String escape(Object obj) {
        if (obj == null) {
            return "";
        }
        String val = obj.toString();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < val.length()) {
            char c = val.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    break;
                }
                case '>': {
                    sb.append("&gt;");
                    break;
                }
                case '&': {
                    sb.append("&amp;");
                    break;
                }
                case '\'': {
                    sb.append("&apos;");
                    break;
                }
                case '\"': {
                    sb.append("&quot;");
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public String toString() {
        return this.toXml();
    }

    public byte[] toXmlBytes() {
        try {
            return this.toXml().getBytes("iso-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public abstract int getPort();

    abstract void appendXml(StringBuilder var1);

    abstract void importXml(Document var1) throws Exception;

    abstract void setXmlAttributes(String var1, Attributes var2) throws Exception;

    abstract void setXmlValue(String var1, String var2) throws Exception;
}

