/*
 * Decompiled with CFR 0.152.
 */
package com.wabit.uecs.device.actuator;

import com.wabit.uecs.device.actuator.ActuatorComponent;
import com.wabit.uecs.device.actuator.ICyclicAction;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public abstract class AbstractCyclicAction
implements ICyclicAction {
    private long initialDelay;
    private long interval;
    private ScheduledExecutorService executor;

    public AbstractCyclicAction(long checkInterval) {
        this.interval = checkInterval;
    }

    public AbstractCyclicAction(long checkInterval, long initialDelay) {
        this.interval = checkInterval;
        this.initialDelay = initialDelay;
    }

    @Override
    public long getInterval() {
        return this.interval;
    }

    @Override
    public void onStart(ActuatorComponent<?> component) throws Exception {
        if (this.executor == null) {
            this.executor = Executors.newSingleThreadScheduledExecutor();
        }
        Task task = new Task(component);
        this.executor.scheduleAtFixedRate(task, this.initialDelay, this.getInterval(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void onStop(ActuatorComponent<?> component) throws Exception {
        if (this.executor != null && !this.executor.isShutdown()) {
            this.executor.shutdown();
            this.executor = null;
        }
    }

    private class Task
    implements Runnable {
        private ActuatorComponent<?> comp;

        public Task(ActuatorComponent<?> dev) {
            this.comp = dev;
        }

        @Override
        public void run() {
            try {
                AbstractCyclicAction.this.execute(this.comp);
            }
            catch (Exception e) {
                if (this.comp instanceof ActuatorComponent) {
                    this.comp.notifyException(e);
                }
                e.printStackTrace();
            }
        }
    }
}

