/*
 * Decompiled with CFR 0.152.
 */
package com.wabit.uecs.pi.webui.top;

import com.wabit.uecs.device.IComponent;
import com.wabit.uecs.device.IDevice;
import com.wabit.uecs.device.actuator.ActuatorComponent;
import com.wabit.uecs.device.controller.ControllerComponent;
import com.wabit.uecs.device.sensor.SensorComponent;
import com.wabit.uecs.pi.UecsPiNode;
import com.wabit.uecs.pi.webui.LayoutPage;
import com.wabit.uecs.pi.webui.WebUIApplication;
import com.wabit.uecs.pi.webui.top.ActuatorsPanel;
import com.wabit.uecs.pi.webui.top.ControllersPanel;
import com.wabit.uecs.pi.webui.top.SensorsPanel;
import java.io.Serializable;
import java.util.Date;
import org.apache.wicket.Component;
import org.apache.wicket.authroles.authorization.strategies.role.annotations.AuthorizeInstantiation;
import org.apache.wicket.datetime.markup.html.basic.DateLabel;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.StatelessForm;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;

@AuthorizeInstantiation(value={"ADMIN"})
public class TopPage
extends LayoutPage {
    private static final String ITEM_STATUS_NORMAL = "item.statusNormal";
    private static final String ITEM_STATUS_ATTENTION = "item.statusAttention";
    private static final String ITEM_STATUS_ALERT = "item.statusAlert";
    private static final String ITEM_STATUS_STOPPED = "item.statusStopped";
    private static final String ITEM_STATUS_DATETIME = "item.statusDatetime";
    private static final String ITEM_CONFIG_EDITING = "item.configEditing";
    private static final long serialVersionUID = 2987526883703489279L;

    protected void onInitialize() {
        super.onInitialize();
        StatelessForm<TopPage> form = new StatelessForm<TopPage>("form"){
            private static final long serialVersionUID = 1L;

            protected void onSubmit() {
                this.setResponsePage(((Object)((Object)TopPage.this)).getClass());
            }
        };
        this.add(new Component[]{form});
        form.setDefaultModel((IModel)new CompoundPropertyModel((Object)this));
        UecsPiNode node = WebUIApplication.getNodeInstance();
        this.add(new Component[]{new Label("ipAddress", node.getIpAddress().toString().replace("/", ""))});
        this.add(new Component[]{DateLabel.forDatePattern((String)"currentDate", (IModel)Model.of((Serializable)new Date()), (String)"yyyy-MM-dd HH:mm:ss z")});
        if (node.isConfigEditing()) {
            this.add(new Component[]{new Label("alert", (IModel)new ResourceModel(ITEM_CONFIG_EDITING))});
            this.add(new Component[]{new Label("normal", "")});
        } else if (node.isActive()) {
            int st = node.getStatus();
            if ((st & 0x7C000000) > 0) {
                this.add(new Component[]{new Label("alert", (IModel)new ResourceModel(ITEM_STATUS_ALERT))});
                this.add(new Component[]{new Label("normal", "")});
            } else if ((st & 0x3F00000) > 0) {
                if ((st & 0x200000) > 0) {
                    this.add(new Component[]{new Label("alert", (IModel)new ResourceModel(ITEM_STATUS_DATETIME))});
                } else {
                    this.add(new Component[]{new Label("alert", (IModel)new ResourceModel(ITEM_STATUS_ATTENTION))});
                }
                this.add(new Component[]{new Label("normal", "")});
            } else {
                this.add(new Component[]{new Label("normal", (IModel)new ResourceModel(ITEM_STATUS_NORMAL))});
                this.add(new Component[]{new Label("alert", "")});
            }
        } else {
            this.add(new Component[]{new Label("alert", (IModel)new ResourceModel(ITEM_STATUS_STOPPED))});
            this.add(new Component[]{new Label("normal", "")});
        }
        boolean sensorEnabled = false;
        boolean actuatorEnabled = false;
        boolean controllerEnabled = false;
        block0: for (IDevice device : node.listDevices()) {
            for (IComponent compo : device.listComponents()) {
                if (compo instanceof SensorComponent) {
                    sensorEnabled = true;
                }
                if (compo instanceof ActuatorComponent) {
                    actuatorEnabled = true;
                }
                if (compo instanceof ControllerComponent) {
                    controllerEnabled = true;
                }
                if (sensorEnabled && actuatorEnabled && controllerEnabled) continue block0;
            }
        }
        if (sensorEnabled) {
            this.add(new Component[]{new SensorsPanel("sensorList")});
        } else {
            this.add(new Component[]{new Label("sensorList")});
        }
        if (actuatorEnabled) {
            this.add(new Component[]{new ActuatorsPanel("actuatorList")});
        } else {
            this.add(new Component[]{new Label("actuatorList")});
        }
        if (controllerEnabled) {
            this.add(new Component[]{new ControllersPanel("controllerList")});
        } else {
            this.add(new Component[]{new Label("controllerList")});
        }
    }
}

