/*
 * Decompiled with CFR 0.152.
 */
package com.wabit.uecs.pi.util;

import java.io.UnsupportedEncodingException;

public class BytesUtils {
    public static void printHex(byte[] bytes) {
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            System.out.printf("'%s'(%02X) ", Character.valueOf((char)b), b);
            ++n2;
        }
        System.out.println("]");
    }

    public static String toHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            sb.append(String.format("%02X", b));
            ++n2;
        }
        return sb.toString();
    }

    public static String toHexString(byte[] bytes, String splitter) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < bytes.length) {
            if (i != 0) {
                sb.append(splitter);
            }
            sb.append(String.format("%02X", bytes[i]));
            ++i;
        }
        return sb.toString();
    }

    public static byte[] toHexBytes(String hex) {
        if (hex == null || hex.length() % 2 != 0) {
            throw new IllegalArgumentException("illegal string : " + hex);
        }
        byte[] bytes = new byte[hex.length() / 2];
        int index = 0;
        while (index < bytes.length) {
            bytes[index] = (byte)Integer.parseInt(hex.substring(index * 2, (index + 1) * 2), 16);
            ++index;
        }
        return bytes;
    }

    public static String toString(byte[] bytes, String charset) {
        if (bytes == null) {
            return null;
        }
        try {
            return new String(bytes, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String toString(byte[] bytes, int offset, int length, String charset) {
        if (bytes == null) {
            return null;
        }
        try {
            return new String(bytes, offset, length, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] toBytes(String val, String charset) {
        if (val == null) {
            return null;
        }
        try {
            return val.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

