/*
 * Decompiled with CFR 0.152.
 */
package com.wabit.uecs.pi.device.spi;

import com.pi4j.io.spi.SpiChannel;
import com.pi4j.io.spi.SpiDevice;
import com.pi4j.io.spi.SpiFactory;
import com.pi4j.io.spi.SpiMode;
import com.pi4j.io.spi.impl.SpiDeviceImpl;
import com.wabit.uecs.pi.device.PiDeviceBase;
import com.wabit.uecs.pi.device.i2c.PiI2CDeviceMockImpl;
import com.wabit.uecs.pi.device.spi.PiSpiDeviceMockImpl;
import com.wabit.uecs.pi.device.spi.SpiDeviceConfig;
import com.wabit.uecs.pi.device.spi.SpiReader;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class SpiDeviceBase<T extends SpiDeviceConfig>
extends PiDeviceBase<T>
implements SpiReader {
    public static SpiDevice spiDevice = null;
    public static byte INIT_CMD = (byte)-48;
    private static ScheduledExecutorService executorService;

    public SpiDeviceBase(String deviceId, T config) {
        super(deviceId, config);
    }

    @Override
    protected void onInit() throws Exception {
        super.onInit();
        String clsClass = ((SpiDeviceConfig)this.getConfig()).getString("SpiClientClass");
        if (clsClass == null || PiI2CDeviceMockImpl.class.getName().equals(clsClass)) {
            spiDevice = new PiSpiDeviceMockImpl();
        } else if (SpiDeviceImpl.class.getName().equals(clsClass)) {
            int cs = ((SpiDeviceConfig)this.getConfig()).getInt("SpiChipSelect", 0);
            int speed = ((SpiDeviceConfig)this.getConfig()).getInt("SpiSpeed", 1000000);
            int mode = ((SpiDeviceConfig)this.getConfig()).getInt("SpiMode", 0);
            spiDevice = SpiFactory.getInstance((SpiChannel)SpiChannel.getByNumber((int)cs), (int)speed, (SpiMode)SpiMode.getByNumber((int)mode));
        } else {
            spiDevice = (SpiDevice)Class.forName(clsClass).newInstance();
        }
    }

    @Override
    protected void onStart() throws Exception {
        int period;
        if (executorService == null) {
            executorService = Executors.newSingleThreadScheduledExecutor();
        }
        if ((period = ((SpiDeviceConfig)this.getConfig()).getInt("SenseInterval", 0)) > 0) {
            this.addSpiReaderTask(this, period, TimeUnit.SECONDS);
        }
    }

    public void addSpiReaderTask(SpiReader reader, long period, TimeUnit unit) {
        executorService.scheduleAtFixedRate(new SenseTask(reader), 0L, period, unit);
    }

    @Override
    public void onReadProcess(SpiDevice spiDevice) throws Exception {
    }

    @Override
    public void onReadError(Exception e) {
    }

    private class SenseTask
    implements Runnable {
        private SpiReader reader;

        SenseTask(SpiReader reader) {
            this.reader = reader;
        }

        @Override
        public void run() {
            try {
                this.reader.onReadProcess(spiDevice);
            }
            catch (Exception e) {
                this.reader.onReadError(e);
                SpiDeviceBase.this.notifyException(e);
            }
        }
    }
}

