/*
 * Decompiled with CFR 0.152.
 */
package com.wabit.uecs.pi.device.serial;

import com.wabit.uecs.pi.device.serial.SerialPortClientBase;
import com.wabit.uecs.pi.device.serial.SerialPortDeviceConfig;
import com.wabit.uecs.pi.util.BytesUtils;
import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SerialPortClientGnuIoImpl
extends SerialPortClientBase
implements SerialPortEventListener {
    private SerialPort serialPort;
    private InputStream input;
    private OutputStream output;
    private Log logger = LogFactory.getLog(this.getClass());
    private String port;
    private int speed;

    @Override
    public void init(SerialPortDeviceConfig conf) throws Exception {
        this.port = conf.getString("SerialPortId");
        if (this.port != null) {
            this.logger.info((Object)("port ID=" + this.port));
        }
        this.speed = conf.getInt("SerialPortSpeed", 9600);
    }

    @Override
    public void open() throws Exception {
        if (this.serialPort != null) {
            return;
        }
        CommPortIdentifier portId = CommPortIdentifier.getPortIdentifier((String)this.port);
        this.logger.info((Object)"open.");
        this.serialPort = (SerialPort)portId.open("SerialPortClient", 1500);
        this.serialPort.setSerialPortParams(this.speed, 8, 1, 0);
        this.serialPort.setFlowControlMode(0);
        this.input = this.serialPort.getInputStream();
        this.output = this.serialPort.getOutputStream();
        this.serialPort.addEventListener((SerialPortEventListener)this);
        this.serialPort.notifyOnDataAvailable(true);
    }

    @Override
    public void close() throws Exception {
        try {
            try {
                if (this.input != null) {
                    this.input.close();
                    this.input = null;
                }
                if (this.output != null) {
                    this.output.close();
                    this.output = null;
                }
            }
            catch (Exception e) {
                this.logger.warn((Object)e, (Throwable)e);
                throw e;
            }
        }
        finally {
            if (this.serialPort != null) {
                this.serialPort.notifyOnDataAvailable(false);
                this.serialPort.close();
                this.serialPort = null;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public void sendData(byte[] data) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("write data : " + BytesUtils.toHexString(data)));
        }
        this.output.write(data);
        this.output.flush();
    }

    public void serialEvent(SerialPortEvent event) {
        if (1 != event.getEventType()) {
            return;
        }
        try {
            int size;
            byte[] data = null;
            while ((size = this.input.available()) > 0) {
                data = new byte[size];
                this.input.read(data, 0, size);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("read size : " + size + "bytes"));
                    this.logger.debug((Object)("read data : " + BytesUtils.toHexString(data)));
                }
                this.fireDataAvailableEvent(data);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
    }
}

