/*
 * Decompiled with CFR 0.152.
 */
package com.wabit.uecs.pi.device.gpio;

import com.wabit.uecs.Ccm;
import com.wabit.uecs.CcmService;
import com.wabit.uecs.device.actuator.AbstractCcmListenerAction;
import com.wabit.uecs.device.actuator.ActuatorComponent;
import com.wabit.uecs.pi.device.IPositioner;
import com.wabit.uecs.pi.device.ISwitcher;
import com.wabit.uecs.pi.device.gpio.DigitalPositioningActuator;

public class RcMListenerAction
extends AbstractCcmListenerAction {
    public void onStart(ActuatorComponent<?> component) throws Exception {
        this.execute(component);
    }

    public void execute(ActuatorComponent<?> component) throws Exception {
        CcmService ccmSv = component.getActiveRcMService();
        if (ccmSv == null || ccmSv.getCcm() == null) {
            return;
        }
        Ccm rcM = ccmSv.getCcm();
        Number num = rcM.getNumberValue();
        if (component instanceof DigitalPositioningActuator) {
            DigitalPositioningActuator posAct = (DigitalPositioningActuator)component;
            if (num.intValue() > 0) {
                posAct.upPosition(rcM.getLevel().getAvailableTime());
            } else if (num.intValue() < 0) {
                posAct.downPosition(rcM.getLevel().getAvailableTime());
            } else {
                posAct.stopPosition();
            }
        } else if (component instanceof IPositioner) {
            int pos;
            IPositioner posAct = (IPositioner)component;
            int npos = pos = posAct.getPosition();
            if (num.intValue() > 0) {
                ++npos;
            } else if (num.intValue() < 0) {
                --npos;
            }
            if (npos < 0) {
                npos = 0;
            } else if (npos > 100) {
                npos = 100;
            }
            if (pos != npos) {
                component.setValue((Number)npos);
            }
        } else if (component instanceof ISwitcher) {
            component.setValue(num);
        }
    }
}

