/*
 * Decompiled with CFR 0.152.
 */
package com.wabit.uecs.pi.device.gpio;

import com.pi4j.io.gpio.GpioController;
import com.pi4j.io.gpio.GpioFactory;
import com.pi4j.io.gpio.GpioPin;
import com.pi4j.io.gpio.GpioPinAnalogInput;
import com.pi4j.io.gpio.GpioPinAnalogOutput;
import com.pi4j.io.gpio.GpioPinDigitalInput;
import com.pi4j.io.gpio.GpioPinDigitalOutput;
import com.pi4j.io.gpio.GpioPinInput;
import com.pi4j.io.gpio.GpioPinPwmOutput;
import com.pi4j.io.gpio.Pin;
import com.pi4j.io.gpio.PinPullResistance;
import com.pi4j.io.gpio.PinState;
import com.pi4j.io.gpio.RaspiPin;
import com.pi4j.io.gpio.event.GpioPinListener;
import com.wabit.uecs.pi.UecsPiNode;
import com.wabit.uecs.pi.UecsPiNodeConfig;
import com.wabit.uecs.pi.device.gpio.GpioDeviceBase;
import com.wabit.uecs.pi.device.gpio.GpioDeviceConfig;
import com.wabit.uecs.pi.webui.WebUIApplication;
import java.util.Arrays;
import java.util.List;

public class RaspiGpioDevice<T extends GpioDeviceConfig>
extends GpioDeviceBase<T> {
    private static final Pin[] RASPI_PINS_ALL = new Pin[]{RaspiPin.GPIO_00, RaspiPin.GPIO_01, RaspiPin.GPIO_02, RaspiPin.GPIO_03, RaspiPin.GPIO_04, RaspiPin.GPIO_05, RaspiPin.GPIO_06, RaspiPin.GPIO_07, RaspiPin.GPIO_08, RaspiPin.GPIO_09, RaspiPin.GPIO_10, RaspiPin.GPIO_11, RaspiPin.GPIO_12, RaspiPin.GPIO_13, RaspiPin.GPIO_14, RaspiPin.GPIO_15, RaspiPin.GPIO_16, RaspiPin.GPIO_17, RaspiPin.GPIO_18, RaspiPin.GPIO_19, RaspiPin.GPIO_20, RaspiPin.GPIO_21, RaspiPin.GPIO_22, RaspiPin.GPIO_23, RaspiPin.GPIO_24, RaspiPin.GPIO_25, RaspiPin.GPIO_26, RaspiPin.GPIO_27, RaspiPin.GPIO_28, RaspiPin.GPIO_29};
    private static final Pin[] RASPI_PINS_MODEL_B = new Pin[]{RaspiPin.GPIO_00, RaspiPin.GPIO_01, RaspiPin.GPIO_02, RaspiPin.GPIO_03, RaspiPin.GPIO_04, RaspiPin.GPIO_05, RaspiPin.GPIO_06, RaspiPin.GPIO_07, RaspiPin.GPIO_17, RaspiPin.GPIO_18, RaspiPin.GPIO_19, RaspiPin.GPIO_20};
    private static final Pin[] RASPI_PINS_MODEL_B_PLUS = new Pin[]{RaspiPin.GPIO_00, RaspiPin.GPIO_01, RaspiPin.GPIO_02, RaspiPin.GPIO_03, RaspiPin.GPIO_04, RaspiPin.GPIO_05, RaspiPin.GPIO_06, RaspiPin.GPIO_07, RaspiPin.GPIO_21, RaspiPin.GPIO_22, RaspiPin.GPIO_23, RaspiPin.GPIO_24, RaspiPin.GPIO_25, RaspiPin.GPIO_26, RaspiPin.GPIO_27, RaspiPin.GPIO_28, RaspiPin.GPIO_29};
    private GpioController gpioController;

    protected RaspiGpioDevice(String deviceId, T config) {
        super(deviceId, config);
    }

    @Override
    protected void onInit() throws Exception {
        super.onInit();
    }

    @Override
    protected void onStart() throws Exception {
        super.onStart();
        if (!WebUIApplication.getNodeInstance().isDevelopmentMode() && this.gpioController == null) {
            this.gpioController = GpioFactory.getInstance();
        }
    }

    @Override
    protected void onStop() throws Exception {
        WebUIApplication.getNodeInstance().isDevelopmentMode();
        super.onStop();
    }

    @Override
    public Pin getPin(String pinName) {
        Pin[] pinArray = RASPI_PINS_ALL;
        int n = RASPI_PINS_ALL.length;
        int n2 = 0;
        while (n2 < n) {
            Pin pin = pinArray[n2];
            if (pin.getName().equals(pinName)) {
                return pin;
            }
            ++n2;
        }
        return null;
    }

    public List<Pin> getControlPins() {
        UecsPiNode node = WebUIApplication.getNodeInstance();
        String model = ((UecsPiNodeConfig)node.getConfig()).getString("RaspiModel", "Model B");
        List<Pin> pins = null;
        pins = "Model B".equals(model) ? Arrays.asList(RASPI_PINS_MODEL_B) : Arrays.asList(RASPI_PINS_MODEL_B_PLUS);
        return pins;
    }

    public GpioPinDigitalInput getProvisionedGpioPinInput(Pin pin) {
        for (GpioPin gpioPin : this.gpioController.getProvisionedPins()) {
            if (!gpioPin.getPin().equals(pin) || !(gpioPin instanceof GpioPinDigitalInput)) continue;
            return (GpioPinDigitalInput)gpioPin;
        }
        return null;
    }

    public GpioPinDigitalOutput getProvisionedGpioPinOutput(Pin pin) {
        for (GpioPin gpioPin : this.gpioController.getProvisionedPins()) {
            if (!gpioPin.getPin().equals(pin) || !(gpioPin instanceof GpioPinDigitalOutput)) continue;
            return (GpioPinDigitalOutput)gpioPin;
        }
        return null;
    }

    @Override
    public void addListener(GpioPinListener listener, GpioPinInput pin) {
        this.gpioController.addListener(listener, new GpioPinInput[]{pin});
    }

    @Override
    public void removeListener(GpioPinListener listener, GpioPinInput pin) {
        this.gpioController.removeListener(listener, new GpioPinInput[]{pin});
    }

    @Override
    public GpioPinDigitalInput provisionDigitalInputPin(Pin pin, PinPullResistance registance) {
        return this.gpioController.provisionDigitalInputPin(pin, registance);
    }

    @Override
    public GpioPinDigitalOutput provisionDigitalOutputPin(Pin pin, PinState state) {
        return this.gpioController.provisionDigitalOutputPin(pin, state);
    }

    @Override
    public GpioPinAnalogInput provisionAnalogInputPin(Pin pin) {
        return this.gpioController.provisionAnalogInputPin(pin);
    }

    @Override
    public GpioPinAnalogOutput provisionAnalogOutputPin(Pin pin) {
        return this.gpioController.provisionAnalogOutputPin(pin);
    }

    @Override
    public GpioPinPwmOutput provisionPwmOutputPin(Pin pin) {
        return this.gpioController.provisionPwmOutputPin(pin);
    }

    @Override
    public void unprovisionPin(GpioPin ... paramVarArgs) {
        this.gpioController.unprovisionPin(paramVarArgs);
    }
}

