/*
 * Decompiled with CFR 0.152.
 */
package com.wabit.uecs.pi.device.gpio;

import com.j256.ormlite.dao.Dao;
import com.pi4j.io.gpio.GpioPin;
import com.pi4j.io.gpio.GpioPinDigitalInput;
import com.pi4j.io.gpio.GpioPinDigitalOutput;
import com.pi4j.io.gpio.Pin;
import com.pi4j.io.gpio.PinPullResistance;
import com.pi4j.io.gpio.PinState;
import com.wabit.uecs.ActionMode;
import com.wabit.uecs.pi.db.ComponentConfigEntity;
import com.wabit.uecs.pi.db.ComponentEntity;
import com.wabit.uecs.pi.db.DatabaseManager;
import com.wabit.uecs.pi.device.IPositioner;
import com.wabit.uecs.pi.device.gpio.DigitalPositioningActuatorConfig;
import com.wabit.uecs.pi.device.gpio.DigitalPositioningInterlockAction;
import com.wabit.uecs.pi.device.gpio.FixedPositioningAction;
import com.wabit.uecs.pi.device.gpio.GpioActuatorBase;
import com.wabit.uecs.pi.device.gpio.GpioDeviceBase;
import com.wabit.uecs.pi.webui.WebUIApplication;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DigitalPositioningActuator<T extends DigitalPositioningActuatorConfig>
extends GpioActuatorBase<T>
implements IPositioner {
    public static final int UP = 1;
    public static final int DOWN = -1;
    public static final int STOP = 0;
    private GpioPinDigitalOutput gpioPinUpOutput;
    private GpioPinDigitalOutput gpioPinDownOutput;
    private GpioPinDigitalInput gpioPinUpInput;
    private GpioPinDigitalInput gpioPinDownInput;
    private Log logger = LogFactory.getLog(this.getClass());
    private long maxTimeMillis;
    private ScheduledExecutorService executor;
    private int actionStatus;
    private long actionStartTime;
    private double actionStartPosition;
    private double currentPosition;
    private long actionInterval;
    private boolean correctionEnabled;

    public DigitalPositioningActuator(String id, T config) {
        super(id, config);
    }

    int getActionStatus() {
        return this.actionStatus;
    }

    public Pin getUpOutputPin() {
        String pinName = ((DigitalPositioningActuatorConfig)this.getConfig()).getString("GpioPinUpOut");
        if (pinName != null && !pinName.isEmpty()) {
            return ((GpioDeviceBase)this.getDevice()).getPin(pinName);
        }
        return null;
    }

    public Pin getUpInputPin() {
        String pinName = ((DigitalPositioningActuatorConfig)this.getConfig()).getString("GpioPinUpIn");
        if (pinName != null && !pinName.isEmpty()) {
            return ((GpioDeviceBase)this.getDevice()).getPin(pinName);
        }
        return null;
    }

    public Pin getDownOutputPin() {
        String pinName = ((DigitalPositioningActuatorConfig)this.getConfig()).getString("GpioPinDownOut");
        if (pinName != null && !pinName.isEmpty()) {
            return ((GpioDeviceBase)this.getDevice()).getPin(pinName);
        }
        return null;
    }

    public Pin getDownInputPin() {
        String pinName = ((DigitalPositioningActuatorConfig)this.getConfig()).getString("GpioPinDownIn");
        if (pinName != null && !pinName.isEmpty()) {
            return ((GpioDeviceBase)this.getDevice()).getPin(pinName);
        }
        return null;
    }

    @Override
    protected void onInit() throws Exception {
        super.onInit();
        if (this.getValue() != null) {
            this.currentPosition = this.getValue().doubleValue();
            this.logger.debug((Object)("init position : " + this.currentPosition));
        }
        DigitalPositioningActuatorConfig config = (DigitalPositioningActuatorConfig)this.getConfig();
        this.correctionEnabled = config.getBoolean("GapCorrection", false);
        this.maxTimeMillis = config.getLong("MaxPositionTime", 0L) * 1000L;
        this.actionStatus = 0;
        this.setAction(ActionMode.Interlock, new DigitalPositioningInterlockAction());
        FixedPositioningAction stdAction = new FixedPositioningAction();
        stdAction.setPosition(((DigitalPositioningActuatorConfig)this.getConfig()).getInt("DefaultValue", 0));
        this.setAction(ActionMode.Standalone, stdAction);
    }

    @Override
    protected void onStart() throws Exception {
        GpioDeviceBase device = (GpioDeviceBase)this.getDevice();
        if (!WebUIApplication.getNodeInstance().isDevelopmentMode()) {
            Pin pin = this.getUpOutputPin();
            if (pin != null && this.gpioPinUpOutput == null) {
                this.gpioPinUpOutput = device.provisionDigitalOutputPin(pin, PinState.getState((boolean)this.isInverse()));
                if (this.gpioPinUpOutput == null) {
                    throw new Exception("GPIO pin not found : " + this.gpioPinUpOutput);
                }
            }
            this.logger.debug((Object)("up_pin(OUTPUT) : " + this.gpioPinUpOutput));
            pin = this.getDownOutputPin();
            if (pin != null && this.gpioPinDownOutput == null) {
                this.gpioPinDownOutput = device.provisionDigitalOutputPin(pin, PinState.getState((boolean)this.isInverse()));
                if (this.gpioPinDownOutput == null) {
                    throw new Exception("GPIO pin not found : " + this.gpioPinDownOutput);
                }
            }
            this.logger.debug((Object)("down_pin(OUTPUT) : " + this.gpioPinDownOutput));
            pin = this.getUpInputPin();
            if (pin != null && this.gpioPinUpInput == null) {
                this.gpioPinUpInput = device.provisionDigitalInputPin(pin, PinPullResistance.PULL_UP);
                if (this.gpioPinUpInput == null) {
                    throw new Exception("GPIO pin not found : " + this.gpioPinUpInput);
                }
            }
            this.logger.debug((Object)("up_pin(INPUT) : " + this.gpioPinUpOutput));
            pin = this.getDownInputPin();
            if (pin != null && this.gpioPinDownInput == null) {
                this.gpioPinDownInput = device.provisionDigitalInputPin(pin, PinPullResistance.PULL_UP);
                if (this.gpioPinDownInput == null) {
                    throw new Exception("GPIO pin not found : " + this.gpioPinDownInput);
                }
            }
            this.logger.debug((Object)("down_pin(INPUT) : " + this.gpioPinDownInput));
        }
        if (this.maxTimeMillis <= 0L) {
            return;
        }
        long interval = this.maxTimeMillis / 100L;
        this.executor = Executors.newSingleThreadScheduledExecutor();
        this.executor.scheduleAtFixedRate(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                DigitalPositioningActuator digitalPositioningActuator = DigitalPositioningActuator.this;
                synchronized (digitalPositioningActuator) {
                    if (DigitalPositioningActuator.this.actionStatus == 0) {
                        return;
                    }
                    if (DigitalPositioningActuator.this.actionStartTime == 0L) {
                        DigitalPositioningActuator.this.actionStartTime = System.currentTimeMillis();
                        DigitalPositioningActuator.this.actionStartPosition = DigitalPositioningActuator.this.currentPosition;
                        if (DigitalPositioningActuator.this.actionStatus == 1) {
                            DigitalPositioningActuator.this.doUpPosition();
                        } else if (DigitalPositioningActuator.this.actionStatus == -1) {
                            DigitalPositioningActuator.this.doDownPosition();
                        }
                        return;
                    }
                    long delay = System.currentTimeMillis() - DigitalPositioningActuator.this.actionStartTime;
                    if (delay >= DigitalPositioningActuator.this.actionInterval) {
                        DigitalPositioningActuator.this.stopPosition();
                    } else {
                        DigitalPositioningActuator.this.detectPosition();
                    }
                }
            }
        }, 0L, interval, TimeUnit.MILLISECONDS);
        super.onStart();
    }

    @Override
    protected void onStop() throws Exception {
        if (this.executor != null && !this.executor.isShutdown()) {
            this.executor.shutdownNow();
            this.executor = null;
        }
        this.stopPosition();
        DatabaseManager.callInTransaction(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Dao compDao = DatabaseManager.createDao(ComponentEntity.class);
                if (compDao.queryForId((Object)DigitalPositioningActuator.this.getId()) != null) {
                    Dao confDao = DatabaseManager.createDao(ComponentConfigEntity.class);
                    ComponentConfigEntity ent = new ComponentConfigEntity();
                    ent.setComponentId(DigitalPositioningActuator.this.getId());
                    ent.setId(String.valueOf(DigitalPositioningActuator.this.getId()) + "." + "LastValue");
                    ent.setKey("LastValue");
                    ent.setValue(Integer.toString(DigitalPositioningActuator.this.getPosition()));
                    confDao.createOrUpdate((Object)ent);
                }
                return null;
            }
        });
        GpioDeviceBase device = (GpioDeviceBase)this.getDevice();
        if (this.gpioPinUpOutput != null) {
            device.unprovisionPin(new GpioPin[]{this.gpioPinUpOutput});
            this.gpioPinUpOutput = null;
        }
        if (this.gpioPinDownOutput != null) {
            device.unprovisionPin(new GpioPin[]{this.gpioPinDownOutput});
            this.gpioPinDownOutput = null;
        }
        if (this.gpioPinUpInput != null) {
            device.unprovisionPin(new GpioPin[]{this.gpioPinUpInput});
            this.gpioPinUpInput = null;
        }
        if (this.gpioPinDownInput != null) {
            device.unprovisionPin(new GpioPin[]{this.gpioPinDownInput});
            this.gpioPinDownInput = null;
        }
        super.onStop();
    }

    @Override
    public int getPosition() {
        return Math.round((float)this.currentPosition);
    }

    @Override
    public synchronized void setPosition(int pos) {
        if (pos < 0 || pos > 100) {
            throw new IllegalArgumentException("out of range (0-100) : " + pos);
        }
        if (this.correctionEnabled && pos == 0 && this.currentPosition != (double)pos) {
            this.downPosition((long)((double)this.maxTimeMillis * 1.05));
        } else if (this.correctionEnabled && pos == 100 && this.currentPosition != (double)pos) {
            this.upPosition((long)((double)this.maxTimeMillis * 1.05));
        } else {
            double diff = (double)pos - this.currentPosition;
            long executeTime = (long)((double)this.maxTimeMillis / 100.0 * diff);
            if (executeTime > 0L) {
                this.upPosition(executeTime);
            } else if (executeTime < 0L) {
                this.downPosition(executeTime * -1L);
            }
        }
    }

    public synchronized void resetPosition() {
        this.stopPosition();
        this.setValue(0);
        this.currentPosition = 0.0;
    }

    public synchronized void upPosition(long executeTime) {
        switch (this.actionStatus) {
            case 1: {
                long delay = System.currentTimeMillis() - this.actionStartTime;
                if (delay >= executeTime) break;
                this.actionInterval += executeTime - delay;
                break;
            }
            case -1: {
                this.stopPosition();
            }
            case 0: {
                this.actionInterval = executeTime;
                this.actionStatus = 1;
            }
        }
    }

    public synchronized void downPosition(long executeTime) {
        switch (this.actionStatus) {
            case -1: {
                long delay = System.currentTimeMillis() - this.actionStartTime;
                if (delay >= executeTime) break;
                this.actionInterval += executeTime - delay;
                break;
            }
            case 1: {
                this.stopPosition();
            }
            case 0: {
                this.actionInterval = executeTime;
                this.actionStatus = -1;
            }
        }
    }

    public synchronized void stopPosition() {
        if (this.actionStatus == 0) {
            return;
        }
        this.doStopPosition();
        this.detectPosition();
        this.actionStatus = 0;
        this.actionStartTime = 0L;
        this.actionInterval = 0L;
    }

    private void detectPosition() {
        if (this.actionStartTime > 0L) {
            long delay = System.currentTimeMillis() - this.actionStartTime;
            this.currentPosition = (double)this.actionStatus * ((double)delay / (double)this.maxTimeMillis) * 100.0 + this.actionStartPosition;
            if (this.currentPosition <= 0.0) {
                this.currentPosition = 0.0;
            } else if (this.currentPosition >= 100.0) {
                this.currentPosition = 100.0;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("actionStart=" + this.actionStartTime + ", delay=" + delay + ", start_pos=" + Math.round((float)this.actionStartPosition) + ", current_pos=" + Math.round((float)this.currentPosition)));
            }
            this.setValue(Math.round((float)this.currentPosition));
        }
    }

    GpioPinDigitalInput getGpioUpInputPin() {
        return this.gpioPinUpInput;
    }

    GpioPinDigitalInput getGpioDownInputPin() {
        return this.gpioPinDownInput;
    }

    private void doUpPosition() {
        if (this.gpioPinDownOutput != null) {
            this.gpioPinDownOutput.setState(this.isInverse());
        }
        if (this.gpioPinUpOutput != null) {
            this.gpioPinUpOutput.setState(!this.isInverse());
        }
    }

    private void doDownPosition() {
        if (this.gpioPinUpOutput != null) {
            this.gpioPinUpOutput.setState(this.isInverse());
        }
        if (this.gpioPinDownOutput != null) {
            this.gpioPinDownOutput.setState(!this.isInverse());
        }
    }

    private void doStopPosition() {
        if (this.gpioPinUpOutput != null) {
            this.gpioPinUpOutput.setState(this.isInverse());
        }
        if (this.gpioPinDownOutput != null) {
            this.gpioPinDownOutput.setState(this.isInverse());
        }
    }
}

