/*
 * Decompiled with CFR 0.152.
 */
package com.wabit.uecs.pi.device;

import com.wabit.uecs.device.IComponent;
import com.wabit.uecs.device.IComponentListener;
import com.wabit.uecs.device.sensor.SensorComponent;
import com.wabit.uecs.pi.UecsPiLogger;
import com.wabit.uecs.pi.db.DatabaseManager;
import com.wabit.uecs.pi.db.DatabaseUtils;
import com.wabit.uecs.pi.device.PiSensorConfig;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class PiSensorBase<T extends PiSensorConfig>
extends SensorComponent<T> {
    private String detectMethod;
    private long detectInterval;
    private String convertType;
    private double coeffA;
    private double coeffB;
    private double coeffC;
    private double pullupR;
    private double stdR;
    private double stdTemp;
    private double constB;
    private double powerV;
    private long recInterval;
    private long lastRecTime;
    private double limitMin = Double.NEGATIVE_INFINITY;
    private double limitMax = Double.POSITIVE_INFINITY;
    private List<TsValue> values = new LinkedList<TsValue>();
    private Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());

    public PiSensorBase(String id, T config) {
        super(id, config);
        this.addListener(new SensorListener());
    }

    protected void onInit() throws Exception {
        PiSensorConfig config = (PiSensorConfig)this.getConfig();
        this.detectMethod = config.getString("DetectionMethod", "MOMENT");
        this.detectInterval = config.getLong("DetectionInterval", 0L) * 1000L;
        this.convertType = config.getString("ConversionType", "QUADRATIC");
        this.coeffA = config.getDouble("Coeff2", 0.0);
        this.coeffB = config.getDouble("Coeff1", 1.0);
        this.coeffC = config.getDouble("Coeff0", 0.0);
        this.pullupR = config.getDouble("PullupR", 0.0);
        this.stdR = config.getDouble("StdR", 0.0);
        this.stdTemp = config.getDouble("StdTemp", 0.0);
        this.constB = config.getDouble("ConstB", 0.0);
        this.powerV = config.getDouble("PowerV", 0.0);
        this.limitMin = config.getDouble("LimitMin", Double.NEGATIVE_INFINITY);
        this.limitMax = config.getDouble("LimitMax", Double.POSITIVE_INFINITY);
    }

    public synchronized void setValue(Number num) {
        if (num == null) {
            super.setValue(num);
            return;
        }
        double value = num.doubleValue();
        if (this.convertType.equals("QUADRATIC")) {
            value = this.coeffA * value * value + this.coeffB * value + this.coeffC;
        } else if (this.convertType.equals("THERMISTOR")) {
            value = PiSensorBase.calcTemperature(value, this.pullupR, this.stdR, this.stdTemp, this.constB, this.powerV);
        }
        if (value < this.limitMin) {
            value = this.limitMin;
        } else if (value > this.limitMax) {
            value = this.limitMax;
        }
        if (!this.detectMethod.equals("MOMENT")) {
            TsValue curVal = new TsValue();
            curVal.time = System.currentTimeMillis();
            curVal.value = value;
            TsValue[] tsValueArray = this.values.toArray(new TsValue[0]);
            int n = tsValueArray.length;
            int n2 = 0;
            while (n2 < n) {
                TsValue tv = tsValueArray[n2];
                if (tv.time < curVal.time - this.detectInterval) {
                    this.values.remove(tv);
                }
                ++n2;
            }
            this.values.add(curVal);
            if (this.detectMethod.equals("SMA")) {
                value = 0.0;
                for (TsValue tv : this.values) {
                    value += tv.value;
                }
                value /= (double)this.values.size();
            } else if (this.detectMethod.equals("WMA")) {
                value = 0.0;
                int div = 0;
                int n3 = 0;
                for (TsValue tv : this.values) {
                    value += tv.value * (double)(++n3);
                    div += n3;
                }
                value /= (double)div;
            }
        }
        super.setValue((Number)value);
    }

    private static double calcTemperature(double vth, double r, double r0, double t0, double b, double vp) {
        if (vth > 0.0 && vp - vth > 0.0 && r > 0.0 && r0 > 0.0 && t0 > -273.15 && b > 0.0 && vp > 0.0) {
            double rth = r * vth / (vp - vth);
            double tth = 1.0 / (1.0 / b * Math.log(rth / r0) + 1.0 / (t0 * 1.0 + 273.15));
            return tth - 273.15;
        }
        throw new IllegalArgumentException();
    }

    private class SensorListener
    implements IComponentListener {
        private SensorListener() {
        }

        public void componentStarted(IComponent<?> component) {
            if (PiSensorBase.this.logger.isDebugEnabled()) {
                PiSensorBase.this.logger.debug((Object)("ID=" + component.getId()));
            }
            PiSensorBase.this.recInterval = component.getConfig().getLong("RecordInterval", -1L) * 1000L;
            PiSensorBase.this.lastRecTime = component.getConfig().getLong("LastRecordedTime", 0L);
        }

        public void componentStopped(IComponent<?> component) {
            if (PiSensorBase.this.logger.isDebugEnabled()) {
                PiSensorBase.this.logger.debug((Object)("ID=" + component.getId()));
            }
        }

        public void componentValueUpdated(IComponent<?> component) {
            final String compoId = component.getId();
            final Number value = component.getValue();
            if (PiSensorBase.this.logger.isDebugEnabled()) {
                PiSensorBase.this.logger.debug((Object)("ID=" + compoId + ", value=" + value));
            }
            if (PiSensorBase.this.recInterval < 0L || value == null || PiSensorBase.this.lastRecTime == Long.MIN_VALUE) {
                return;
            }
            final long time = System.currentTimeMillis();
            if (time - PiSensorBase.this.lastRecTime >= PiSensorBase.this.recInterval) {
                try {
                    DatabaseManager.callInTransaction(new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            DatabaseUtils.saveComponentData(compoId, time, value);
                            DatabaseUtils.saveComponentConfig(compoId, "LastRecordedTime", Long.toString(time));
                            PiSensorBase.this.lastRecTime = time;
                            return null;
                        }
                    });
                }
                catch (SQLException e) {
                    PiSensorBase.this.logger.error((Object)("Data save failed. ID=" + compoId), (Throwable)e);
                    UecsPiLogger.log("DEVICE", "message.sensorError", component.getConfig().getString("ComponentName"), e);
                    component.getDevice().getNode().onStatus(0xC000000);
                }
            }
        }

        public void handleComponentException(IComponent<?> component, Exception e) {
            PiSensorBase.this.logger.error((Object)("ID=" + component.getId()), (Throwable)e);
            UecsPiLogger.log("DEVICE", "message.sensorError", component.getConfig().getString("ComponentName"), e);
            component.getDevice().getNode().onStatus(0xC000000);
        }
    }

    private static class TsValue {
        long time;
        double value;

        private TsValue() {
        }
    }
}

