/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.convert.converter;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.wicket.util.convert.converter.AbstractNumberConverter;

public abstract class AbstractDecimalConverter<N extends Number>
extends AbstractNumberConverter<N> {
    private static final long serialVersionUID = 1L;
    private final Map<Locale, NumberFormat> numberFormats = new ConcurrentHashMap<Locale, NumberFormat>();

    @Override
    public NumberFormat getNumberFormat(Locale locale) {
        NumberFormat numberFormat = this.numberFormats.get(locale);
        if (numberFormat == null) {
            numberFormat = this.newNumberFormat(locale);
            this.setNumberFormat(locale, numberFormat);
        }
        return (NumberFormat)numberFormat.clone();
    }

    protected NumberFormat newNumberFormat(Locale locale) {
        return NumberFormat.getInstance(locale);
    }

    public final void setNumberFormat(Locale locale, NumberFormat numberFormat) {
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).setParseBigDecimal(true);
        }
        this.numberFormats.put(locale, numberFormat);
    }
}

