/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html;

import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.markup.MarkupType;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.html.TransparentWebMarkupContainer;
import org.apache.wicket.markup.html.internal.HtmlHeaderContainer;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.renderStrategy.AbstractHeaderRenderStrategy;
import org.apache.wicket.model.IModel;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.WebRequest;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.response.StringResponse;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebPage
extends Page {
    private static final Logger log = LoggerFactory.getLogger(WebPage.class);
    private static final long serialVersionUID = 1L;

    protected WebPage() {
        this.commonInit();
    }

    protected WebPage(IModel<?> model) {
        super(model);
        this.commonInit();
    }

    protected WebPage(PageParameters parameters) {
        super(parameters);
        this.commonInit();
    }

    @Override
    public MarkupType getMarkupType() {
        return MarkupType.HTML_MARKUP_TYPE;
    }

    private void commonInit() {
    }

    @Override
    protected void onRender() {
        this.configureResponse((WebResponse)RequestCycle.get().getResponse());
        this.renderXmlDecl();
        super.onRender();
    }

    protected void renderXmlDecl() {
        WebApplication.get().renderXmlDecl(this, false);
    }

    protected void configureResponse(WebResponse response) {
        this.setHeaders(response);
        String encoding = this.getApplication().getRequestCycleSettings().getResponseRequestEncoding();
        boolean validEncoding = !Strings.isEmpty((CharSequence)encoding);
        String contentType = validEncoding ? this.getMarkupType().getMimeType() + "; charset=" + encoding : this.getMarkupType().getMimeType();
        response.setContentType(contentType);
    }

    protected void setHeaders(WebResponse response) {
        response.disableCaching();
    }

    @Override
    protected void onAfterRender() {
        if (this.getApplication().usesDevelopmentConfig() && this.wasRendered(this)) {
            this.validateHeaders();
        }
        super.onAfterRender();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateHeaders() {
        HtmlHeaderContainer header = this.visitChildren(new IVisitor<Component, HtmlHeaderContainer>(){

            public void component(Component component, IVisit<HtmlHeaderContainer> visit) {
                if (component instanceof HtmlHeaderContainer) {
                    visit.stop((Object)((HtmlHeaderContainer)component));
                } else if (!(component instanceof TransparentWebMarkupContainer)) {
                    visit.dontGoDeeper();
                }
            }
        });
        if (header == null) {
            header = new HtmlHeaderContainer("_header_");
            this.add(header);
            RequestCycle requestCycle = this.getRequestCycle();
            Response orgResponse = requestCycle.getResponse();
            try {
                StringResponse tempResponse = new StringResponse();
                requestCycle.setResponse(tempResponse);
                AbstractHeaderRenderStrategy.get().renderHeader(header, null, this.getPage());
                IHeaderResponse headerResponse = header.getHeaderResponse();
                headerResponse.close();
                CharSequence collectedHeaderOutput = tempResponse.getBuffer();
                if (collectedHeaderOutput.length() > 0) {
                    this.reportMissingHead(collectedHeaderOutput);
                }
            }
            catch (Exception e) {
                log.error("header/body check throws exception", (Throwable)e);
            }
            finally {
                this.remove(header);
                requestCycle.setResponse(orgResponse);
            }
        }
    }

    protected void reportMissingHead(CharSequence collectedHeaderOutput) {
        log.error("^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
        log.error("You probably forgot to add a <body> or <head> tag to your markup since no Header Container was \nfound but components were found which want to write to the <head> section.\n" + collectedHeaderOutput);
        log.error("^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
    }

    protected final BookmarkablePageLink<Void> homePageLink(String id) {
        return new BookmarkablePageLink<Void>(id, this.getApplication().getHomePage());
    }

    @Override
    public final void dirty(boolean isInitialization) {
        Request request = this.getRequest();
        if (!isInitialization && request instanceof WebRequest && ((WebRequest)request).isAjax()) {
            return;
        }
        super.dirty(isInitialization);
    }
}

