/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.pageStore.memory;

import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import org.apache.wicket.util.io.IClusterable;

public class PageTable
implements IClusterable {
    private static final long serialVersionUID = 1L;
    private final Queue<Integer> index;
    private final ConcurrentMap<Integer, byte[]> pages = new ConcurrentHashMap<Integer, byte[]>();

    public PageTable() {
        this.index = new ConcurrentLinkedQueue<Integer>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storePage(Integer pageId, byte[] pageAsBytes) {
        Queue<Integer> queue = this.index;
        synchronized (queue) {
            this.pages.put(pageId, pageAsBytes);
            this.updateIndex(pageId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getPage(Integer pageId) {
        Queue<Integer> queue = this.index;
        synchronized (queue) {
            this.updateIndex(pageId);
            return (byte[])this.pages.get(pageId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] removePage(Integer pageId) {
        Queue<Integer> queue = this.index;
        synchronized (queue) {
            this.index.remove(pageId);
            return (byte[])this.pages.remove(pageId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Queue<Integer> queue = this.index;
        synchronized (queue) {
            this.index.clear();
            this.pages.clear();
        }
    }

    public int size() {
        return this.pages.size();
    }

    public Integer getOldest() {
        return this.index.peek();
    }

    private void updateIndex(Integer pageId) {
        this.index.remove(pageId);
        this.index.offer(pageId);
    }
}

