/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.head;

import java.util.Collections;
import org.apache.wicket.Application;
import org.apache.wicket.core.util.string.JavaScriptUtils;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.settings.IJavaScriptLibrarySettings;
import org.apache.wicket.util.string.Strings;

public class OnLoadHeaderItem
extends HeaderItem {
    private final CharSequence javaScript;

    public static OnLoadHeaderItem forScript(CharSequence javaScript) {
        return new OnLoadHeaderItem(javaScript);
    }

    public OnLoadHeaderItem() {
        this(null);
    }

    public OnLoadHeaderItem(CharSequence javaScript) {
        this.javaScript = javaScript;
    }

    public CharSequence getJavaScript() {
        return this.javaScript;
    }

    @Override
    public void render(Response response) {
        CharSequence js = this.getJavaScript();
        if (!Strings.isEmpty((CharSequence)js)) {
            JavaScriptUtils.writeJavaScript(response, "Wicket.Event.add(window, \"load\", function(event) { " + js + ";});");
        }
    }

    @Override
    public Iterable<?> getRenderTokens() {
        return Collections.singletonList("javascript-load-" + this.getJavaScript());
    }

    public String toString() {
        return "OnLoadHeaderItem('" + this.getJavaScript() + "')";
    }

    public int hashCode() {
        return this.getJavaScript().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof OnLoadHeaderItem) {
            return ((OnLoadHeaderItem)obj).getJavaScript().equals(this.getJavaScript());
        }
        return false;
    }

    @Override
    public Iterable<? extends HeaderItem> getDependencies() {
        IJavaScriptLibrarySettings ajaxSettings = Application.get().getJavaScriptLibrarySettings();
        ResourceReference wicketEventReference = ajaxSettings.getWicketEventReference();
        return Collections.singletonList(JavaScriptHeaderItem.forReference(wicketEventReference));
    }
}

