/*
 * Decompiled with CFR 0.152.
 */
package com.wabit.uecs.pi.webui.nodeconfig;

import com.wabit.uecs.NodeConfig;
import com.wabit.uecs.pi.UecsPiNode;
import com.wabit.uecs.pi.UecsPiNodeConfig;
import com.wabit.uecs.pi.db.DatabaseManager;
import com.wabit.uecs.pi.db.DatabaseUtils;
import com.wabit.uecs.pi.util.BytesUtils;
import com.wabit.uecs.pi.util.MessageUtils;
import com.wabit.uecs.pi.webui.LayoutPage;
import com.wabit.uecs.pi.webui.LocaleChoice;
import com.wabit.uecs.pi.webui.TimeZoneChoice;
import com.wabit.uecs.pi.webui.WebUIApplication;
import com.wabit.uecs.pi.webui.nodeconfig.NodeSetting;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.wicket.Component;
import org.apache.wicket.authroles.authorization.strategies.role.annotations.AuthorizeInstantiation;
import org.apache.wicket.extensions.markup.html.form.DateTextField;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.form.RadioChoice;
import org.apache.wicket.markup.html.form.RequiredTextField;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.form.upload.FileUploadField;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.PatternValidator;
import org.apache.wicket.validation.validator.RangeValidator;
import org.apache.wicket.validation.validator.StringValidator;

@AuthorizeInstantiation(value={"ADMIN"})
public class NodeConfigPage
extends LayoutPage {
    private static final long serialVersionUID = 9036704791217192197L;
    private static final String IP_PATTERN = "^\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}$";
    private Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private NodeSetting nodeSettings;
    private final WebMarkupContainer editIpForm = new WebMarkupContainer("editIpForm");
    private final WebMarkupContainer staticIpForm = new WebMarkupContainer("staticIpForm");

    protected void onInitialize() {
        super.onInitialize();
        this.nodeSettings = this.createModel();
        UecsPiNode node = WebUIApplication.getNodeInstance();
        NodeConfig conf = DatabaseUtils.loadNodeConfig();
        this.nodeSettings.setNodeName(conf.getString("NodeName", ""));
        this.nodeSettings.setNodeType(conf.getString("NodeType", ""));
        this.nodeSettings.setIpAddress(node.getIpAddress().getHostAddress());
        this.nodeSettings.setPassword(conf.getString("AdminPassword", ""));
        this.nodeSettings.setCurrentDate(new Date());
        this.nodeSettings.setIsChangeCurrentDate(false);
        this.nodeSettings.setIpType(conf.getString("IpType", ""));
        this.nodeSettings.setIpMask(conf.getString("IpMask", ""));
        this.nodeSettings.setGateway(conf.getString("IpGateway", ""));
        this.nodeSettings.setDnsServer(conf.getString("DnsServer", ""));
        this.nodeSettings.setRoom(conf.getInt("Room", 0));
        this.nodeSettings.setRegion(conf.getInt("Region", 0));
        this.nodeSettings.setOrder(conf.getInt("Order", 0));
        this.nodeSettings.setPriority(conf.getInt("Priority", 0));
        this.nodeSettings.setIsRcvDateTime(conf.getBoolean("ReceiveDatetime", false));
        this.nodeSettings.setIsSndDateTime(conf.getBoolean("SendDatetime", false));
        this.nodeSettings.setLocale(conf.getString("Locale", Locale.getDefault().toLanguageTag()));
        this.nodeSettings.setTimeZone(conf.getString("TimeZone", TimeZone.getDefault().getID()));
        Form form = new Form("form");
        CompoundPropertyModel model = new CompoundPropertyModel((Object)this.nodeSettings);
        form.setDefaultModel((IModel)model);
        form.add(new Component[]{new RequiredTextField("nodeName").add((IValidator)new StringValidator(Integer.valueOf(1), Integer.valueOf(50)))});
        form.add(new Component[]{new RequiredTextField("nodeType").add((IValidator)new StringValidator(Integer.valueOf(1), Integer.valueOf(3)))});
        form.add(new Component[]{new RequiredTextField("room", Integer.class).add((IValidator)new RangeValidator((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(127)))});
        form.add(new Component[]{new RequiredTextField("region", Integer.class).add((IValidator)new RangeValidator((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(127)))});
        form.add(new Component[]{new RequiredTextField("order", Integer.class).add((IValidator)new RangeValidator((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(3000)))});
        form.add(new Component[]{new RequiredTextField("priority", Integer.class).add((IValidator)new RangeValidator((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(29)))});
        form.add(new Component[]{new DateTextField("currentDate", "yyyy-MM-dd HH:mm:ss")});
        form.add(new Component[]{new PasswordTextField("password").setRequired(false).add((IValidator)new StringValidator(Integer.valueOf(1), Integer.valueOf(50)))});
        String mac = "";
        if (node.getMacAddress() != null) {
            mac = BytesUtils.toHexString(node.getMacAddress(), "-");
        }
        form.add(new Component[]{new Label("macAddress", mac)});
        form.add(new Component[]{new Label("firmwareVersion", conf.getString("FirmwareVersion", ""))});
        form.add(new Component[]{new CheckBox("isChangeCurrentDate")});
        form.add(new Component[]{new CheckBox("isRcvDateTime")});
        form.add(new Component[]{new CheckBox("isSndDateTime")});
        this.staticIpForm.add(new Component[]{new RequiredTextField("ipAddress").add((IValidator)new PatternValidator(IP_PATTERN))});
        this.staticIpForm.add(new Component[]{new RequiredTextField("ipMask").add((IValidator)new PatternValidator(IP_PATTERN))});
        this.staticIpForm.add(new Component[]{new TextField("gateway").add((IValidator)new PatternValidator(IP_PATTERN))});
        this.staticIpForm.add(new Component[]{new TextField("dnsServer").add((IValidator)new PatternValidator(IP_PATTERN))});
        if ("static".equals(conf.getString("IpType", ""))) {
            this.staticIpForm.setVisible(true);
        } else {
            this.staticIpForm.setVisible(false);
        }
        this.editIpForm.add(new Component[]{this.staticIpForm});
        List<String> ipTypes = Arrays.asList("dhcp", "static");
        this.editIpForm.add(new Component[]{new RadioChoice<String>("ipType", ipTypes){
            private static final long serialVersionUID = 1L;

            protected boolean localizeDisplayValues() {
                return true;
            }

            protected boolean wantOnSelectionChangedNotifications() {
                return true;
            }

            protected void onSelectionChanged(Object val) {
                if ("dhcp".equals(val)) {
                    NodeConfigPage.this.staticIpForm.setVisible(false);
                } else {
                    NodeConfigPage.this.staticIpForm.setVisible(true);
                }
            }
        }});
        form.add(new Component[]{this.editIpForm});
        String networkType = WebUIApplication.get().getInitParameter("ipReadonly");
        if (networkType != null && networkType.equalsIgnoreCase("true")) {
            this.editIpForm.setVisible(false);
        } else {
            this.editIpForm.setVisible(true);
        }
        form.add(new Component[]{new LocaleChoice("locale")});
        form.add(new Component[]{new TimeZoneChoice("timeZone")});
        form.add(new Component[]{new Button("saveButton"){
            private static final long serialVersionUID = 1L;

            public void onSubmit() {
                try {
                    NodeConfigPage.this.onConfigChanged();
                }
                catch (Throwable e) {
                    this.error((Serializable)((Object)MessageUtils.getMessage("message.error", new Object[0])));
                    NodeConfigPage.this.logger.error((Object)"restart error.", e);
                }
            }
        }});
        form.add(new Component[]{new Button("shutdownButton"){
            private static final long serialVersionUID = 1L;

            public void onSubmit() {
                try {
                    NodeConfigPage.this.shutdownOS();
                    this.success((Serializable)((Object)MessageUtils.getMessage("message.osShutdown", new Object[0])));
                }
                catch (Throwable e) {
                    this.error((Serializable)((Object)MessageUtils.getMessage("message.error", new Object[0])));
                    NodeConfigPage.this.logger.error((Object)"OS shutdown error.", e);
                }
            }
        }});
        form.add(new Component[]{new Button("rebootButton"){
            private static final long serialVersionUID = 1L;

            public void onSubmit() {
                try {
                    NodeConfigPage.this.rebootOS();
                    this.success((Serializable)((Object)MessageUtils.getMessage("message.osReboot", new Object[0])));
                }
                catch (Throwable e) {
                    this.error((Serializable)((Object)MessageUtils.getMessage("message.error", new Object[0])));
                    NodeConfigPage.this.logger.error((Object)"OS reboot error.", e);
                }
            }
        }});
        form.add(new Component[]{new Button("restartButton"){
            private static final long serialVersionUID = 1L;

            public void onSubmit() {
                try {
                    UecsPiNode node = WebUIApplication.getNodeInstance();
                    node.restart();
                    this.success((Serializable)((Object)MessageUtils.getMessage("message.nodeRestarted", new Object[0])));
                }
                catch (Throwable e) {
                    this.error((Serializable)((Object)MessageUtils.getMessage("message.error", new Object[0])));
                    NodeConfigPage.this.logger.error((Object)"OS reboot error.", e);
                }
            }
        }});
        this.add(new Component[]{form});
        final FileUploadField uploadField = new FileUploadField("uploadFile");
        Form uploadForm = new Form("configFileForm");
        uploadForm.add(new Component[]{uploadField});
        uploadForm.add(new Component[]{new Button("uploadButton"){
            private static final long serialVersionUID = 1L;

            public void onSubmit() {
                try {
                    if (uploadField.getFileUpload() != null) {
                        final UecsPiNode node = WebUIApplication.getNodeInstance();
                        DatabaseManager.callInTransaction(new Callable<Void>(){

                            @Override
                            public Void call() throws Exception {
                                InputStream input = uploadField.getFileUpload().getInputStream();
                                DatabaseUtils.readConfigXml(input);
                                UecsPiNodeConfig conf = (UecsPiNodeConfig)node.getConfig();
                                for (String key : conf.getFixKeys()) {
                                    DatabaseUtils.saveNodeConfig(key, conf.getString(key));
                                }
                                return null;
                            }
                        });
                        node.restart();
                        this.success((Serializable)((Object)MessageUtils.getMessage("message.saved", new Object[0])));
                    }
                }
                catch (Exception e) {
                    this.error((Serializable)((Object)MessageUtils.getMessage("message.error", new Object[0])));
                    NodeConfigPage.this.logger.error((Object)"upload error.", (Throwable)e);
                }
            }
        }});
        uploadForm.add(new Component[]{new Button("downloadButton"){
            private static final long serialVersionUID = 1L;

            public void onSubmit() {
                ServletOutputStream out = null;
                try {
                    HttpServletResponse httpRes = (HttpServletResponse)this.getResponse().getContainerResponse();
                    httpRes.setContentType("text/xml");
                    httpRes.setHeader("Content-Disposition", "attachment; filename=node-config.xml");
                    out = httpRes.getOutputStream();
                    DatabaseUtils.writeConfigXml((OutputStream)out);
                    out.flush();
                    out.close();
                }
                catch (Exception e) {
                    this.error((Serializable)((Object)MessageUtils.getMessage("message.error", new Object[0])));
                    NodeConfigPage.this.logger.error((Object)"download error.", (Throwable)e);
                }
            }
        }});
        this.add(new Component[]{uploadForm});
        this.onInit((Form<NodeSetting>)form);
    }

    protected void onConfigChanged() throws Exception {
        DatabaseManager.callInTransaction(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                NodeConfig saveConf = new NodeConfig();
                saveConf.putAll((Map)WebUIApplication.getNodeInstance().getConfig());
                saveConf.setString("NodeName", NodeConfigPage.this.nodeSettings.getNodeName().trim());
                saveConf.setString("NodeType", NodeConfigPage.this.nodeSettings.getNodeType().trim());
                saveConf.setString("IpType", NodeConfigPage.this.nodeSettings.getIpType());
                if (NodeConfigPage.this.nodeSettings.getPassword() != null && NodeConfigPage.this.nodeSettings.getPassword().length() > 0) {
                    saveConf.setString("AdminPassword", NodeConfigPage.this.nodeSettings.getPassword());
                }
                saveConf.setInt("Room", NodeConfigPage.this.nodeSettings.getRoom().intValue());
                saveConf.setInt("Region", NodeConfigPage.this.nodeSettings.getRegion().intValue());
                saveConf.setInt("Order", NodeConfigPage.this.nodeSettings.getOrder().intValue());
                saveConf.setInt("Priority", NodeConfigPage.this.nodeSettings.getPriority().intValue());
                saveConf.setBoolean("ReceiveDatetime", NodeConfigPage.this.nodeSettings.getIsRcvDateTime());
                saveConf.setBoolean("SendDatetime", NodeConfigPage.this.nodeSettings.getIsSndDateTime());
                saveConf.setString("Locale", NodeConfigPage.this.nodeSettings.getLocale());
                saveConf.setString("TimeZone", NodeConfigPage.this.nodeSettings.getTimeZone());
                if (NodeConfigPage.this.nodeSettings.getIsChangeCurrentDate() && NodeConfigPage.this.nodeSettings.getCurrentDate() != null) {
                    NodeConfigPage.this.changeCurrentDate(NodeConfigPage.this.nodeSettings.getCurrentDate());
                }
                UecsPiNode node = WebUIApplication.getNodeInstance();
                String oldIpAddress = node.getIpAddress().toString().replace("/", "");
                String oldSubnetMask = ((UecsPiNodeConfig)node.getConfig()).getString("IpMask", "");
                String oldGateway = ((UecsPiNodeConfig)node.getConfig()).getString("IpGateway", "");
                String oldIpType = ((UecsPiNodeConfig)node.getConfig()).getString("IpType", "");
                String oldDnsServer = ((UecsPiNodeConfig)node.getConfig()).getString("DnsServer", "");
                String newIpType = NodeConfigPage.this.nodeSettings.getIpType();
                String newIpAddress = NodeConfigPage.this.nodeSettings.getIpAddress();
                String newSubnetMask = NodeConfigPage.this.nodeSettings.getIpMask();
                String newGateway = NodeConfigPage.this.nodeSettings.getGateway();
                String newDnsServer = NodeConfigPage.this.nodeSettings.getDnsServer();
                NodeConfigPage.this.onSave(NodeConfigPage.this.nodeSettings, saveConf);
                if (newIpType.equals("dhcp")) {
                    if (oldIpType.equals("static")) {
                        DatabaseUtils.saveNodeConfig(saveConf);
                        WebUIApplication.getNodeInstance().stop();
                        NodeConfigPage.this.changeIpAddressToDhcp();
                        WebUIApplication.getNodeInstance().restartAsync(10000L);
                        NodeConfigPage.this.success((Serializable)((Object)MessageUtils.getMessage("message.ipChanged", new Object[0])));
                        return null;
                    }
                } else if (!(!oldIpType.equals("dhcp") && oldIpAddress.equals(newIpAddress) && oldSubnetMask.equals(newSubnetMask) && oldGateway.equals(newGateway) && oldDnsServer.equals(newDnsServer))) {
                    if (newDnsServer == null) {
                        newDnsServer = "";
                    }
                    if (newGateway == null) {
                        newGateway = "";
                    }
                    saveConf.setString("IpMask", newSubnetMask);
                    saveConf.setString("IpGateway", newGateway);
                    saveConf.setString("DnsServer", newDnsServer);
                    DatabaseUtils.saveNodeConfig(saveConf);
                    WebUIApplication.getNodeInstance().stop();
                    NodeConfigPage.this.changeIpAddress(newIpAddress, newSubnetMask, newGateway, newDnsServer);
                    WebUIApplication.getNodeInstance().restartAsync(5000L);
                    NodeConfigPage.this.success((Serializable)((Object)MessageUtils.getMessage("message.ipChanged", new Object[0])));
                    return null;
                }
                DatabaseUtils.saveNodeConfig(saveConf);
                WebUIApplication.getNodeInstance().setConfigEditing(true);
                WebUIApplication webApp = (WebUIApplication)NodeConfigPage.this.getApplication();
                if (!webApp.getDefaultLocale().toLanguageTag().equals(NodeConfigPage.this.nodeSettings.getLocale())) {
                    webApp.setDefaultLocale(Locale.forLanguageTag(NodeConfigPage.this.nodeSettings.getLocale()));
                    NodeConfigPage.this.getSession().setLocale(webApp.getDefaultLocale());
                }
                NodeConfigPage.this.success((Serializable)((Object)MessageUtils.getMessage("message.saved", new Object[0])));
                return null;
            }
        });
    }

    protected NodeSetting createModel() {
        return new NodeSetting();
    }

    protected void onInit(Form<NodeSetting> form) {
    }

    protected void onSave(NodeSetting source, NodeConfig saveConf) {
    }

    private void changeIpAddress(String newIpAddress, String newSubnetMask, String newGateway, String dns) throws IOException {
        String cmd = "sh /opt/scripts/change_ip_static.sh " + newIpAddress + " " + newSubnetMask + " " + newGateway + " " + dns;
        Runtime rt = Runtime.getRuntime();
        rt.exec(cmd);
    }

    private void changeIpAddressToDhcp() throws IOException {
        String cmd = null;
        cmd = "sh /opt/scripts/change_ip_dhcp.sh";
        Runtime rt = Runtime.getRuntime();
        rt.exec(cmd);
    }

    private void changeCurrentDate(Date date) throws Exception {
        Runtime rt = Runtime.getRuntime();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        rt.exec(new String[]{"sh", "/opt/scripts/change_current_date.sh", sdf.format(date)});
    }

    private void shutdownOS() throws Exception {
        WebUIApplication.getNodeInstance().stop();
        String cmd = "/sbin/shutdown -h now";
        Runtime rt = Runtime.getRuntime();
        rt.exec(cmd);
    }

    private void rebootOS() throws Exception {
        WebUIApplication.getNodeInstance().stop();
        String cmd = "/sbin/reboot";
        Runtime rt = Runtime.getRuntime();
        rt.exec(cmd);
    }
}

