/*
 * Decompiled with CFR 0.152.
 */
package com.wabit.uecs.pi.webui;

import com.wabit.uecs.pi.UecsPiNode;
import com.wabit.uecs.pi.UecsPiNodeConfig;
import com.wabit.uecs.pi.db.DatabaseManager;
import com.wabit.uecs.pi.util.MessageUtils;
import com.wabit.uecs.pi.webui.AuthSession;
import com.wabit.uecs.pi.webui.CustomFeedbackPanel;
import com.wabit.uecs.pi.webui.FooterPanel;
import com.wabit.uecs.pi.webui.HeaderPanel;
import com.wabit.uecs.pi.webui.MenuPanel;
import com.wabit.uecs.pi.webui.signin.SignInPage;
import com.wabit.uecs.pi.webui.top.TopPage;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.wicket.Page;
import org.apache.wicket.RuntimeConfigurationType;
import org.apache.wicket.Session;
import org.apache.wicket.authroles.authentication.AbstractAuthenticatedWebSession;
import org.apache.wicket.authroles.authentication.AuthenticatedWebApplication;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Response;

public class WebUIApplication
extends AuthenticatedWebApplication {
    private static UecsPiNode instance;
    private Locale defaultLocale = Locale.getDefault();
    private Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());

    protected UecsPiNode createNodeInstance() {
        return new UecsPiNode();
    }

    public static UecsPiNode getNodeInstance() {
        return instance;
    }

    public Class<? extends Page> getHomePage() {
        return TopPage.class;
    }

    public void init() {
        super.init();
        this.getMarkupSettings().setStripWicketTags(true);
        String path = this.getServletContext().getRealPath("/WEB-INF/db/UecsNode.db");
        try {
            Locale lc;
            DatabaseManager.init(path);
            instance = this.createNodeInstance();
            instance.setDevelopmentMode(WebUIApplication.isDevelopmentMode());
            instance.restart();
            String locale = ((UecsPiNodeConfig)instance.getConfig()).getString("Locale");
            if (locale != null && (lc = Locale.forLanguageTag(locale)) != null) {
                this.setDefaultLocale(lc);
            }
        }
        catch (Throwable t) {
            this.logger.error((Object)"init error.", t);
        }
    }

    public static boolean isDevelopmentMode() {
        return WebUIApplication.get().getConfigurationType() == RuntimeConfigurationType.DEVELOPMENT;
    }

    public void onDestroy() {
        WebUIApplication.getNodeInstance().stop();
        WebUIApplication.getNodeInstance().onDestroy();
        super.onDestroy();
    }

    public Session newSession(Request request, Response response) {
        Session session = super.newSession(request, response);
        if (this.getDefaultLocale() != null) {
            session.setLocale(this.getDefaultLocale());
        }
        return session;
    }

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    public void setDefaultLocale(Locale newLocale) {
        this.defaultLocale = newLocale;
        MessageUtils.changeLocale(this.defaultLocale);
    }

    public Locale[] getAvailableLocales() {
        return new Locale[]{Locale.US, Locale.JAPAN};
    }

    protected Class<? extends WebPage> getSignInPageClass() {
        return SignInPage.class;
    }

    protected Class<? extends AbstractAuthenticatedWebSession> getWebSessionClass() {
        return AuthSession.class;
    }

    protected Class<? extends Panel> getHeaderPanelClass() {
        return HeaderPanel.class;
    }

    protected Class<? extends Panel> getMenuPanelClass() {
        return MenuPanel.class;
    }

    protected Class<? extends Panel> getFooterPanelClass() {
        return FooterPanel.class;
    }

    protected Class<? extends Panel> getFeedbackPanelClass() {
        return CustomFeedbackPanel.class;
    }
}

