/*
 * Decompiled with CFR 0.152.
 */
package com.wabit.uecs.pi.webui;

import com.wabit.uecs.device.IDevice;
import com.wabit.uecs.pi.db.DatabaseUtils;
import com.wabit.uecs.pi.device.PiDeviceBase;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.io.IClusterable;

public class DeviceChoice
extends DropDownChoice<Row> {
    public static final String NEW_ID = "NewDevice";
    private Class<? extends IDevice<?>> deviceCls;
    private boolean containsNew;

    public <U extends IDevice<?>> DeviceChoice(String id, Class<U> devCls) {
        this(id, devCls, true);
    }

    public <U extends IDevice<?>> DeviceChoice(String id, Class<U> devCls, boolean containsNew) {
        super(id);
        this.setChoiceRenderer((IChoiceRenderer)new ChoiceRenderer("Name", "Id"));
        this.deviceCls = devCls;
        this.containsNew = containsNew;
    }

    public void init(String deviceId) {
        List<PiDeviceBase<?>> devices = DatabaseUtils.loadDevices();
        ArrayList<Row> rows = new ArrayList<Row>(devices.size() + 1);
        if (this.containsNew) {
            Row row = new Row(NEW_ID, NEW_ID);
            rows.add(row);
        }
        for (IDevice iDevice : devices) {
            if (!this.deviceCls.isInstance(iDevice)) continue;
            Row row = new Row(iDevice.getId(), iDevice.getConfig().getString("DeviceName", ""));
            rows.add(row);
        }
        this.setChoices(rows);
        if (rows.size() > 0) {
            if (deviceId == null || NEW_ID.equals(deviceId)) {
                this.setModel((IModel)Model.of((Serializable)((Object)((Row)rows.get(0)))));
            } else {
                for (Row row : rows) {
                    if (!row.getId().equals(deviceId)) continue;
                    this.setModel((IModel)Model.of((Serializable)((Object)row)));
                    break;
                }
            }
        }
    }

    protected boolean localizeDisplayValues() {
        return true;
    }

    public static final class Row
    implements IClusterable {
        private String id;
        private String name;

        public Row(String id, String name) {
            this.id = id;
            this.name = name;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

