/*
 * Decompiled with CFR 0.152.
 */
package com.wabit.uecs.pi.device.serial;

import com.wabit.uecs.pi.device.PiDeviceBase;
import com.wabit.uecs.pi.device.serial.ISerialPortClient;
import com.wabit.uecs.pi.device.serial.ISerialPortListener;
import com.wabit.uecs.pi.device.serial.SerialPortDeviceConfig;

public abstract class SerialPortDeviceBase<T extends SerialPortDeviceConfig>
extends PiDeviceBase<T>
implements ISerialPortListener {
    private ISerialPortClient serialPortClient;
    private boolean isEnabled = false;

    public SerialPortDeviceBase(String deviceId, T config) {
        super(deviceId, config);
    }

    @Override
    protected void onInit() throws Exception {
        super.onInit();
        String clsClass = ((SerialPortDeviceConfig)this.getConfig()).getString("SerialPortClientClass");
        this.serialPortClient = (ISerialPortClient)Class.forName(clsClass).newInstance();
        this.serialPortClient.init((SerialPortDeviceConfig)this.getConfig());
        this.serialPortClient.addListener(this);
        this.isEnabled = true;
    }

    @Override
    protected void onStart() throws Exception {
        super.onStart();
        if (this.isEnabled) {
            this.serialPortClient.open();
        }
    }

    @Override
    protected void onStop() throws Exception {
        if (this.isEnabled) {
            this.serialPortClient.close();
        }
        super.onStop();
    }

    public ISerialPortClient getSerialPortClient() {
        return this.serialPortClient;
    }

    public void sendData(byte[] data) throws Exception {
        this.serialPortClient.sendData(data);
    }
}

