/*
 * Decompiled with CFR 0.152.
 */
package com.wabit.uecs.pi.device.i2c;

import com.pi4j.io.i2c.I2CBus;
import com.pi4j.io.i2c.I2CDevice;
import com.pi4j.io.i2c.I2CFactory;
import com.pi4j.io.i2c.impl.I2CDeviceImpl;
import com.wabit.uecs.pi.device.PiDeviceBase;
import com.wabit.uecs.pi.device.i2c.I2cDeviceConfig;
import com.wabit.uecs.pi.device.i2c.I2cReader;
import com.wabit.uecs.pi.device.i2c.PiI2CDeviceMockImpl;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class I2cDeviceBase<T extends I2cDeviceConfig>
extends PiDeviceBase<T>
implements I2cReader {
    private static I2CBus I2C_BUS;
    private I2CDevice i2cDevice;
    private static ScheduledExecutorService executorService;

    public I2cDeviceBase(String deviceId, T config) {
        super(deviceId, config);
    }

    @Override
    protected void onInit() throws Exception {
        super.onInit();
        String clsClass = ((I2cDeviceConfig)this.getConfig()).getString("I2cClientClass");
        if (clsClass == null || PiI2CDeviceMockImpl.class.getName().equals(clsClass)) {
            this.i2cDevice = new PiI2CDeviceMockImpl();
        } else if (I2CDeviceImpl.class.getName().equals(clsClass)) {
            if (I2C_BUS == null) {
                I2C_BUS = I2CFactory.getInstance((int)((I2cDeviceConfig)this.getConfig()).getInt("I2cBus"));
            }
            this.i2cDevice = I2C_BUS.getDevice(((I2cDeviceConfig)this.getConfig()).getInt("I2cAddress"));
        } else {
            this.i2cDevice = (I2CDevice)Class.forName(clsClass).newInstance();
        }
    }

    @Override
    protected void onStart() throws Exception {
        int period;
        if (executorService == null) {
            executorService = Executors.newSingleThreadScheduledExecutor();
        }
        if ((period = ((I2cDeviceConfig)this.getConfig()).getInt("SenseInterval", 0)) > 0) {
            this.addI2cReaderTask(this, period, TimeUnit.SECONDS);
        }
    }

    @Override
    protected void onStop() throws Exception {
        if (executorService != null) {
            executorService.shutdownNow();
            executorService = null;
        }
    }

    public void addI2cReaderTask(I2cReader reader, long period, TimeUnit unit) {
        executorService.scheduleAtFixedRate(new SenseTask(reader), 0L, period, unit);
    }

    protected I2CDevice getI2CDevice() {
        return this.i2cDevice;
    }

    @Override
    public void onReadProcess(I2CDevice i2cDevice) throws Exception {
    }

    @Override
    public void onReadError(Exception e) {
    }

    private class SenseTask
    implements Runnable {
        private I2cReader reader;

        SenseTask(I2cReader reader) {
            this.reader = reader;
        }

        @Override
        public void run() {
            try {
                this.reader.onReadProcess(I2cDeviceBase.this.i2cDevice);
            }
            catch (Exception e) {
                this.reader.onReadError(e);
                I2cDeviceBase.this.notifyException(e);
            }
        }
    }
}

