/*
 * Decompiled with CFR 0.152.
 */
package com.wabit.uecs.pi.device.gpio;

import com.pi4j.io.gpio.GpioPin;
import com.pi4j.io.gpio.GpioPinDigitalInput;
import com.pi4j.io.gpio.GpioPinInput;
import com.pi4j.io.gpio.Pin;
import com.pi4j.io.gpio.PinPullResistance;
import com.pi4j.io.gpio.event.GpioPinDigitalStateChangeEvent;
import com.pi4j.io.gpio.event.GpioPinListener;
import com.pi4j.io.gpio.event.GpioPinListenerDigital;
import com.pi4j.io.gpio.event.PinEventType;
import com.wabit.uecs.ActionMode;
import com.wabit.uecs.device.actuator.IActuatorAction;
import com.wabit.uecs.pi.device.PiActuatorBase;
import com.wabit.uecs.pi.device.gpio.GpioActuatorConfig;
import com.wabit.uecs.pi.device.gpio.GpioDeviceBase;
import com.wabit.uecs.pi.device.gpio.RcAListenerAction;
import com.wabit.uecs.pi.device.gpio.RcMListenerAction;
import com.wabit.uecs.pi.webui.WebUIApplication;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class GpioActuatorBase<T extends GpioActuatorConfig>
extends PiActuatorBase<T> {
    private boolean inverse = false;
    private GpioPinDigitalInput interlockPin;
    private Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());

    public GpioActuatorBase(String id, T config) {
        super(id, config);
    }

    @Override
    protected void onInit() throws Exception {
        super.onInit();
        GpioActuatorConfig config = (GpioActuatorConfig)this.getConfig();
        this.inverse = config.getBoolean("InverseMode", false);
        this.setValue(((GpioActuatorConfig)this.getConfig()).getInt("LastValue", ((GpioActuatorConfig)this.getConfig()).getInt("DefaultValue", 0)));
        this.setAction(ActionMode.rcM, (IActuatorAction)new RcMListenerAction());
        this.setAction(ActionMode.rcA, (IActuatorAction)new RcAListenerAction());
    }

    public boolean isInterlock() {
        return this.interlockPin != null && this.interlockPin.isLow();
    }

    public Pin getInterlockPin() {
        GpioActuatorConfig config = (GpioActuatorConfig)this.getConfig();
        String val = config.getString("GpioPinInterlock");
        if (val != null && !val.isEmpty()) {
            return ((GpioDeviceBase)this.getDevice()).getPin(val);
        }
        return null;
    }

    boolean isInverse() {
        return this.inverse;
    }

    @Override
    protected void onStart() throws Exception {
        GpioDeviceBase device = (GpioDeviceBase)this.getDevice();
        if (!WebUIApplication.getNodeInstance().isDevelopmentMode()) {
            Pin pin = this.getInterlockPin();
            if (pin != null) {
                GpioPinInput inPin = device.getProvisionedGpioPinInput(pin);
                if (inPin == null) {
                    this.interlockPin = device.provisionDigitalInputPin(pin, PinPullResistance.PULL_UP);
                } else if (inPin instanceof GpioPinDigitalInput) {
                    this.interlockPin = (GpioPinDigitalInput)inPin;
                }
                if (this.interlockPin == null) {
                    throw new Exception("GPIO pin not found : " + pin);
                }
                this.logger.debug((Object)("interlock_pin : " + this.interlockPin));
                device.addListener((GpioPinListener)new GpioPinListenerDigital(){

                    public void handleGpioPinDigitalStateChangeEvent(GpioPinDigitalStateChangeEvent event) {
                        if (event.getEventType() != PinEventType.DIGITAL_STATE_CHANGE) {
                            return;
                        }
                        try {
                            if (event.getState().isLow()) {
                                GpioActuatorBase.this.changeMode(ActionMode.Interlock);
                            } else if (GpioActuatorBase.this.getAction(ActionMode.WEB) != null) {
                                GpioActuatorBase.this.changeMode(ActionMode.WEB);
                            } else if (GpioActuatorBase.this.getAction(ActionMode.Autonomy) != null) {
                                GpioActuatorBase.this.changeMode(ActionMode.Autonomy);
                            } else {
                                GpioActuatorBase.this.changeMode(ActionMode.Standalone);
                            }
                        }
                        catch (Exception e) {
                            GpioActuatorBase.this.logger.error((Object)"mode change error.", (Throwable)e);
                            GpioActuatorBase.this.notifyException(e);
                        }
                    }
                }, (GpioPinInput)this.interlockPin);
            }
        } else {
            this.logger.debug((Object)"development mode");
        }
        if (this.isInterlock()) {
            this.setActionMode(ActionMode.Interlock);
        } else if (this.getAction(ActionMode.WEB) != null) {
            this.setActionMode(ActionMode.WEB);
        } else if (this.getAction(ActionMode.Autonomy) != null) {
            this.setActionMode(ActionMode.Autonomy);
        } else {
            this.setActionMode(ActionMode.Standalone);
        }
        super.onStart();
    }

    @Override
    protected void onStop() throws Exception {
        if (this.interlockPin != null) {
            ((GpioDeviceBase)this.getDevice()).unprovisionPin(new GpioPin[]{this.interlockPin});
            this.interlockPin = null;
        }
        super.onStop();
    }
}

