/*
 * Decompiled with CFR 0.152.
 */
package com.wabit.uecs.pi.device.gpio;

import com.j256.ormlite.dao.Dao;
import com.pi4j.io.gpio.GpioPin;
import com.pi4j.io.gpio.GpioPinAnalogInput;
import com.pi4j.io.gpio.GpioPinAnalogOutput;
import com.pi4j.io.gpio.GpioPinOutput;
import com.pi4j.io.gpio.GpioPinPwmOutput;
import com.pi4j.io.gpio.Pin;
import com.wabit.uecs.ActionMode;
import com.wabit.uecs.pi.db.ComponentConfigEntity;
import com.wabit.uecs.pi.db.ComponentEntity;
import com.wabit.uecs.pi.db.DatabaseManager;
import com.wabit.uecs.pi.device.IPositioner;
import com.wabit.uecs.pi.device.gpio.AnalogPositioningActuatorConfig;
import com.wabit.uecs.pi.device.gpio.AnalogPositioningInterlockAction;
import com.wabit.uecs.pi.device.gpio.FixedPositioningAction;
import com.wabit.uecs.pi.device.gpio.GpioActuatorBase;
import com.wabit.uecs.pi.device.gpio.GpioDeviceBase;
import com.wabit.uecs.pi.webui.WebUIApplication;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AnalogPositioningActuator<T extends AnalogPositioningActuatorConfig>
extends GpioActuatorBase<T>
implements IPositioner {
    private GpioPinOutput gpioPinOutput;
    private GpioPinAnalogInput gpioPinInput;
    private boolean pwmMode;
    private int pwmRange;
    private Log logger = LogFactory.getLog(this.getClass());

    public AnalogPositioningActuator(String id, T config) {
        super(id, config);
    }

    public Pin getOutputPin() {
        String pinName = ((AnalogPositioningActuatorConfig)this.getConfig()).getString("GpioPinOut");
        if (pinName != null && !pinName.isEmpty()) {
            return ((GpioDeviceBase)this.getDevice()).getPin(pinName);
        }
        return null;
    }

    public Pin getInputPin() {
        String pinName = ((AnalogPositioningActuatorConfig)this.getConfig()).getString("GpioPinIn");
        if (pinName != null && !pinName.isEmpty()) {
            return ((GpioDeviceBase)this.getDevice()).getPin(pinName);
        }
        return null;
    }

    GpioPinAnalogInput getGpioInputPin() {
        return this.gpioPinInput;
    }

    @Override
    protected void onInit() throws Exception {
        super.onInit();
        if ("PWM".equals(((AnalogPositioningActuatorConfig)this.getConfig()).getString("GpioPinOutMode"))) {
            this.pwmMode = true;
            this.pwmRange = ((AnalogPositioningActuatorConfig)this.getConfig()).getInt("AnalogRangeOut", 100);
        } else {
            this.pwmMode = false;
        }
        this.setAction(ActionMode.Interlock, new AnalogPositioningInterlockAction());
        FixedPositioningAction stdAction = new FixedPositioningAction();
        stdAction.setPosition(((AnalogPositioningActuatorConfig)this.getConfig()).getInt("DefaultValue", 0));
        this.setAction(ActionMode.Standalone, stdAction);
    }

    @Override
    protected void onStart() throws Exception {
        GpioDeviceBase device = (GpioDeviceBase)this.getDevice();
        if (!WebUIApplication.getNodeInstance().isDevelopmentMode()) {
            Pin pin = this.getOutputPin();
            if (pin != null && this.gpioPinOutput == null) {
                if (this.pwmMode) {
                    this.logger.debug((Object)("PWM mode PIN = " + pin));
                    this.gpioPinOutput = device.provisionPwmOutputPin(pin);
                    ((GpioPinPwmOutput)this.gpioPinOutput).setPwmRange(this.pwmRange);
                } else {
                    this.logger.debug((Object)("ANALOG mode PIN = " + pin));
                    this.gpioPinOutput = device.provisionAnalogOutputPin(pin);
                }
                if (this.gpioPinOutput == null) {
                    throw new Exception("GPIO pin not found : " + pin);
                }
            }
            if ((pin = this.getInputPin()) != null && this.gpioPinInput == null) {
                this.gpioPinInput = device.provisionAnalogInputPin(pin);
            }
        }
        if (this.getValue() != null) {
            this.setPinValue(this.getValue().intValue());
        }
        super.onStart();
    }

    @Override
    protected void onStop() throws Exception {
        DatabaseManager.callInTransaction(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Dao compDao = DatabaseManager.createDao(ComponentEntity.class);
                if (compDao.queryForId((Object)AnalogPositioningActuator.this.getId()) != null) {
                    Dao confDao = DatabaseManager.createDao(ComponentConfigEntity.class);
                    ComponentConfigEntity ent = new ComponentConfigEntity();
                    ent.setComponentId(AnalogPositioningActuator.this.getId());
                    ent.setId(String.valueOf(AnalogPositioningActuator.this.getId()) + "." + "LastValue");
                    ent.setKey("LastValue");
                    ent.setValue(Integer.toString(AnalogPositioningActuator.this.getPosition()));
                    confDao.createOrUpdate((Object)ent);
                }
                return null;
            }
        });
        GpioDeviceBase device = (GpioDeviceBase)this.getDevice();
        if (this.gpioPinOutput != null) {
            device.unprovisionPin(new GpioPin[]{this.gpioPinOutput});
            this.gpioPinOutput = null;
        }
        if (this.gpioPinInput != null) {
            device.unprovisionPin(new GpioPin[]{this.gpioPinInput});
            this.gpioPinInput = null;
        }
        super.onStop();
    }

    @Override
    public int getPosition() {
        if (this.getValue() == null) {
            return 0;
        }
        return this.getValue().intValue();
    }

    @Override
    public void setPosition(int pos) {
        if (pos < 0 || pos > 100) {
            throw new IllegalArgumentException("out of range (0-100) : " + pos);
        }
        int curPos = this.getPosition();
        if (curPos != pos) {
            this.setPinValue(pos);
            this.setValue(pos);
        }
    }

    private void setPinValue(int pos) {
        if (this.gpioPinOutput != null) {
            int aval = (int)Math.round((double)this.pwmRange * ((double)pos / 100.0));
            this.logger.debug((Object)("analog value =" + aval));
            if (this.pwmMode) {
                ((GpioPinPwmOutput)this.gpioPinOutput).setPwm(aval);
            } else {
                ((GpioPinAnalogOutput)this.gpioPinOutput).setValue((double)aval);
            }
        }
    }
}

