/*
 * Decompiled with CFR 0.152.
 */
package com.wabit.uecs.pi.device;

import com.wabit.uecs.device.IComponent;
import com.wabit.uecs.device.IComponentListener;
import com.wabit.uecs.device.controller.ControllerComponent;
import com.wabit.uecs.pi.device.PiControllerConfig;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class PiControllerBase<T extends PiControllerConfig>
extends ControllerComponent<T> {
    private Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());

    public PiControllerBase(String id, T config) {
        super(id, config);
        this.addListener(new ContollerListener());
    }

    private class ContollerListener
    implements IComponentListener {
        private ContollerListener() {
        }

        public void componentStarted(IComponent<?> component) {
            if (PiControllerBase.this.logger.isDebugEnabled()) {
                PiControllerBase.this.logger.debug((Object)("ID=" + component.getId()));
            }
        }

        public void componentStopped(IComponent<?> component) {
            if (PiControllerBase.this.logger.isDebugEnabled()) {
                PiControllerBase.this.logger.debug((Object)("ID=" + component.getId()));
            }
        }

        public void componentValueUpdated(IComponent<?> component) {
            if (PiControllerBase.this.logger.isDebugEnabled()) {
                PiControllerBase.this.logger.debug((Object)("ID=" + component.getId() + ", value=" + component.getValue()));
            }
            if (component != this) {
                return;
            }
        }

        public void handleComponentException(IComponent<?> component, Exception e) {
            PiControllerBase.this.logger.error((Object)("ID=" + component.getId()), (Throwable)e);
        }
    }
}

