/*
 * Decompiled with CFR 0.152.
 */
package com.wabit.uecs.pi.device;

import com.wabit.uecs.device.IComponent;
import com.wabit.uecs.device.IComponentListener;
import com.wabit.uecs.device.actuator.ActuatorComponent;
import com.wabit.uecs.pi.UecsPiLogger;
import com.wabit.uecs.pi.db.DatabaseUtils;
import com.wabit.uecs.pi.device.IPositioner;
import com.wabit.uecs.pi.device.ISwitcher;
import com.wabit.uecs.pi.device.PiActuatorConfig;
import java.sql.SQLException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class PiActuatorBase<T extends PiActuatorConfig>
extends ActuatorComponent<T> {
    private Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private long recInterval;
    private static ScheduledExecutorService recScheduler;

    public PiActuatorBase(String id, T config) {
        super(id, config);
        this.addListener(new ActuatorListener());
    }

    protected void onInit() throws Exception {
        this.recInterval = ((PiActuatorConfig)this.getConfig()).getLong("RecordInterval", 0L) * 1000L;
    }

    protected void onStart() throws Exception {
        if (this.recInterval > 0L) {
            if (recScheduler == null) {
                recScheduler = Executors.newSingleThreadScheduledExecutor();
            }
            long delay = this.recInterval - System.currentTimeMillis() % this.recInterval;
            recScheduler.scheduleAtFixedRate(new RecordTask(this), delay, this.recInterval, TimeUnit.MILLISECONDS);
        }
    }

    protected void onStop() throws Exception {
        if (recScheduler != null && !recScheduler.isShutdown()) {
            recScheduler.shutdown();
            recScheduler.awaitTermination(5000L, TimeUnit.MILLISECONDS);
            recScheduler = null;
        }
    }

    public void setValue(Number value) {
        super.setValue(value);
    }

    private class ActuatorListener
    implements IComponentListener {
        private Number preValue;
        private boolean logEnabled;

        private ActuatorListener() {
        }

        public void componentStarted(IComponent<?> component) {
            this.preValue = component.getValue();
            if (PiActuatorBase.this.logger.isDebugEnabled()) {
                PiActuatorBase.this.logger.debug((Object)("ID=" + component.getId()));
            }
            this.logEnabled = ((PiActuatorConfig)PiActuatorBase.this.getConfig()).getBoolean("LogEnabled", false);
        }

        public void componentStopped(IComponent<?> component) {
            if (PiActuatorBase.this.logger.isDebugEnabled()) {
                PiActuatorBase.this.logger.debug((Object)("ID=" + component.getId()));
            }
        }

        public void componentValueUpdated(IComponent<?> component) {
            String compoId = component.getId();
            Number value = component.getValue();
            if (PiActuatorBase.this.logger.isDebugEnabled()) {
                PiActuatorBase.this.logger.debug((Object)("ID=" + compoId + ", value=" + value));
            }
            if (!(PiActuatorBase.this.recInterval < 0L || value == null || this.preValue != null && this.preValue.equals(value))) {
                try {
                    long time = System.currentTimeMillis();
                    DatabaseUtils.saveComponentData(compoId, time, value);
                }
                catch (SQLException e) {
                    PiActuatorBase.this.logger.error((Object)("Data save failed. ID=" + compoId), (Throwable)e);
                }
                if (this.logEnabled) {
                    String category = "DEVICE";
                    String code = "message.componentChanged";
                    String name = component.getConfig().getString("ComponentName");
                    String mode = PiActuatorBase.this.getActionMode().toString();
                    if (component instanceof IPositioner) {
                        UecsPiLogger.log(category, code, name, mode, value + "%");
                    } else if (component instanceof ISwitcher) {
                        if (((ISwitcher)component).isOn()) {
                            UecsPiLogger.log(category, code, name, mode, "ON");
                        } else {
                            UecsPiLogger.log(category, code, name, mode, "OFF");
                        }
                    } else {
                        UecsPiLogger.log(category, code, name, mode, value);
                    }
                }
            }
            this.preValue = value;
        }

        public void handleComponentException(IComponent<?> component, Exception e) {
            PiActuatorBase.this.logger.error((Object)("ID=" + component.getId()), (Throwable)e);
        }
    }

    private static class RecordTask
    implements Runnable {
        private PiActuatorBase<?> act;

        RecordTask(PiActuatorBase<?> act) {
            this.act = act;
        }

        @Override
        public void run() {
            long current = System.currentTimeMillis();
            Number value = this.act.getValue();
            if (value != null) {
                try {
                    long time = current - current % ((PiActuatorBase)this.act).recInterval;
                    DatabaseUtils.saveComponentData(this.act.getId(), time, value);
                }
                catch (SQLException e) {
                    ((PiActuatorBase)this.act).logger.error((Object)("Data save failed. ID=" + this.act.getId()), (Throwable)e);
                }
            }
        }
    }
}

