/*
 * Decompiled with CFR 0.152.
 */
package com.wabit.uecs.pi.db;

import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.stmt.DeleteBuilder;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.Where;
import com.wabit.uecs.NodeConfig;
import com.wabit.uecs.device.ComponentConfig;
import com.wabit.uecs.device.DeviceConfig;
import com.wabit.uecs.device.IComponent;
import com.wabit.uecs.device.IDevice;
import com.wabit.uecs.pi.db.ComponentConfigEntity;
import com.wabit.uecs.pi.db.ComponentEntity;
import com.wabit.uecs.pi.db.ComponentValueEntity;
import com.wabit.uecs.pi.db.DatabaseManager;
import com.wabit.uecs.pi.db.DeviceConfigEntity;
import com.wabit.uecs.pi.db.DeviceEntity;
import com.wabit.uecs.pi.db.LogEntity;
import com.wabit.uecs.pi.db.NodeConfigEntity;
import com.wabit.uecs.pi.device.PiDeviceBase;
import com.wabit.uecs.pi.device.PiDeviceConfig;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DatabaseUtils {
    private static long recNo;
    private static int logNo;
    private static long idNo;
    private static Log logger;

    static {
        logger = LogFactory.getLog(DatabaseUtils.class);
    }

    private DatabaseUtils() {
    }

    public static void init() throws SQLException {
        Dao logDao;
        QueryBuilder query;
        LogEntity lastLog;
        Dao dataDao = DatabaseManager.createDao(ComponentValueEntity.class);
        ComponentValueEntity entity = (ComponentValueEntity)dataDao.queryBuilder().limit(Long.valueOf(1L)).orderBy("time", false).orderBy("rec_no", false).queryForFirst();
        if (entity != null) {
            recNo = entity.getRecNo();
        }
        if ((lastLog = (LogEntity)(query = (logDao = DatabaseManager.createDao(LogEntity.class)).queryBuilder()).limit(Long.valueOf(1L)).orderBy("time", false).orderBy("log_no", false).queryForFirst()) != null) {
            logNo = lastLog.getLogNo();
        }
    }

    public static boolean isInstalled() throws SQLException {
        Dao nodeDao = DatabaseManager.createDao(NodeConfigEntity.class);
        return nodeDao.countOf() != 0L;
    }

    public static void writeConfigXml(OutputStream out) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        DOMImplementation domImpl = builder.getDOMImplementation();
        Document document = domImpl.createDocument("", "UecsPiNode", null);
        Element rootElm = document.getDocumentElement();
        Element nodeConfElm = document.createElement("NodeConfig");
        Dao nodeDao = DatabaseManager.createDao(NodeConfigEntity.class);
        for (NodeConfigEntity entity : nodeDao.queryForAll()) {
            Element entityElm = document.createElement("Entity");
            entityElm.setAttribute("key", entity.getKey());
            entityElm.setAttribute("value", entity.getValue());
            nodeConfElm.appendChild(entityElm);
        }
        rootElm.appendChild(nodeConfElm);
        Element devElm = document.createElement("Device");
        Dao deviceDao = DatabaseManager.createDao(DeviceEntity.class);
        for (DeviceEntity entity : deviceDao.queryForAll()) {
            Element entityElm = document.createElement("Entity");
            entityElm.setAttribute("id", entity.getDeviceId());
            entityElm.setAttribute("name", entity.getDeviceName());
            entityElm.setAttribute("javaClass", entity.getDeviceClass());
            devElm.appendChild(entityElm);
        }
        rootElm.appendChild(devElm);
        Element devConfElm = document.createElement("DeviceConfig");
        Dao devConfDao = DatabaseManager.createDao(DeviceConfigEntity.class);
        for (DeviceConfigEntity entity : devConfDao.queryForAll()) {
            Element entityElm = document.createElement("Entity");
            entityElm.setAttribute("id", entity.getId());
            entityElm.setAttribute("deviceId", entity.getDeviceId());
            entityElm.setAttribute("key", entity.getKey());
            entityElm.setAttribute("value", entity.getValue());
            devConfElm.appendChild(entityElm);
        }
        rootElm.appendChild(devConfElm);
        Element compoElm = document.createElement("Component");
        Dao compoDao = DatabaseManager.createDao(ComponentEntity.class);
        for (ComponentEntity entity : compoDao.queryForAll()) {
            Element entityElm = document.createElement("Entity");
            entityElm.setAttribute("id", entity.getComponentId());
            entityElm.setAttribute("deviceId", entity.getDeviceId());
            entityElm.setAttribute("name", entity.getComponentName());
            entityElm.setAttribute("javaClass", entity.getComponentClass());
            compoElm.appendChild(entityElm);
        }
        rootElm.appendChild(compoElm);
        Element compoConfElm = document.createElement("ComponentConfig");
        Dao compoConfDao = DatabaseManager.createDao(ComponentConfigEntity.class);
        for (ComponentConfigEntity entity : compoConfDao.queryForAll()) {
            Element entityElm = document.createElement("Entity");
            entityElm.setAttribute("id", entity.getId());
            entityElm.setAttribute("componentId", entity.getComponentId());
            entityElm.setAttribute("key", entity.getKey());
            entityElm.setAttribute("value", entity.getValue());
            compoConfElm.appendChild(entityElm);
        }
        rootElm.appendChild(compoConfElm);
        TransformerFactory transFactory = TransformerFactory.newInstance();
        Transformer transformer = transFactory.newTransformer();
        DOMSource source = new DOMSource(document);
        StreamResult result = new StreamResult(out);
        transformer.transform(source, result);
    }

    public static void readConfigXml(InputStream input) throws Exception {
        final Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(input);
        DatabaseManager.callInTransaction(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Dao nodeDao = DatabaseManager.createDao(NodeConfigEntity.class);
                nodeDao.deleteBuilder().delete();
                NodeList nodeConfElms = document.getElementsByTagName("NodeConfig").item(0).getChildNodes();
                int i = 0;
                while (i < nodeConfElms.getLength()) {
                    Node node = nodeConfElms.item(i);
                    if (node instanceof Element) {
                        Element confElm = (Element)node;
                        NodeConfigEntity entity = new NodeConfigEntity();
                        entity.setKey(confElm.getAttribute("key"));
                        entity.setValue(confElm.getAttribute("value"));
                        nodeDao.create((Object)entity);
                    }
                    ++i;
                }
                Dao deviceDao = DatabaseManager.createDao(DeviceEntity.class);
                deviceDao.deleteBuilder().delete();
                NodeList devElms = document.getElementsByTagName("Device").item(0).getChildNodes();
                int i2 = 0;
                while (i2 < devElms.getLength()) {
                    Node node = devElms.item(i2);
                    if (node instanceof Element) {
                        Element devElm = (Element)node;
                        DeviceEntity entity = new DeviceEntity();
                        entity.setDeviceId(devElm.getAttribute("id"));
                        entity.setDeviceName(devElm.getAttribute("name"));
                        entity.setDeviceClass(devElm.getAttribute("javaClass"));
                        deviceDao.create((Object)entity);
                    }
                    ++i2;
                }
                Dao devConfDao = DatabaseManager.createDao(DeviceConfigEntity.class);
                devConfDao.deleteBuilder().delete();
                NodeList devConfElms = document.getElementsByTagName("DeviceConfig").item(0).getChildNodes();
                int i3 = 0;
                while (i3 < devConfElms.getLength()) {
                    Node node = devConfElms.item(i3);
                    if (node instanceof Element) {
                        Element devConfElm = (Element)node;
                        DeviceConfigEntity entity = new DeviceConfigEntity();
                        entity.setId(devConfElm.getAttribute("id"));
                        entity.setDeviceId(devConfElm.getAttribute("deviceId"));
                        entity.setKey(devConfElm.getAttribute("key"));
                        entity.setValue(devConfElm.getAttribute("value"));
                        devConfDao.create((Object)entity);
                    }
                    ++i3;
                }
                Dao compoDao = DatabaseManager.createDao(ComponentEntity.class);
                compoDao.deleteBuilder().delete();
                NodeList compoElms = document.getElementsByTagName("Component").item(0).getChildNodes();
                int i4 = 0;
                while (i4 < compoElms.getLength()) {
                    Node node = compoElms.item(i4);
                    if (node instanceof Element) {
                        Element compoElm = (Element)node;
                        ComponentEntity entity = new ComponentEntity();
                        entity.setComponentId(compoElm.getAttribute("id"));
                        entity.setDeviceId(compoElm.getAttribute("deviceId"));
                        entity.setComponentName(compoElm.getAttribute("name"));
                        entity.setComponentClass(compoElm.getAttribute("javaClass"));
                        compoDao.create((Object)entity);
                    }
                    ++i4;
                }
                Dao compoConfDao = DatabaseManager.createDao(ComponentConfigEntity.class);
                compoConfDao.deleteBuilder().delete();
                NodeList compoConfElms = document.getElementsByTagName("ComponentConfig").item(0).getChildNodes();
                int i5 = 0;
                while (i5 < compoConfElms.getLength()) {
                    Node node = compoConfElms.item(i5);
                    if (node instanceof Element) {
                        Element compoConfElm = (Element)node;
                        ComponentConfigEntity entity = new ComponentConfigEntity();
                        entity.setId(compoConfElm.getAttribute("id"));
                        entity.setComponentId(compoConfElm.getAttribute("componentId"));
                        entity.setKey(compoConfElm.getAttribute("key"));
                        entity.setValue(compoConfElm.getAttribute("value"));
                        compoConfDao.create((Object)entity);
                    }
                    ++i5;
                }
                return null;
            }
        });
    }

    public static NodeConfig loadNodeConfig() {
        try {
            Dao nodeDao = DatabaseManager.createDao(NodeConfigEntity.class);
            NodeConfig nodeConf = new NodeConfig();
            for (NodeConfigEntity entity : nodeDao.queryForAll()) {
                nodeConf.setString(entity.getKey(), entity.getValue());
            }
            return nodeConf;
        }
        catch (SQLException e) {
            logger.error((Object)"db error.", (Throwable)e);
            return null;
        }
    }

    public static PiDeviceBase<?> loadDevice(String deviceId) {
        try {
            Dao deviceDao = DatabaseManager.createDao(DeviceEntity.class);
            Dao confDao = DatabaseManager.createDao(DeviceConfigEntity.class);
            List list = deviceDao.queryBuilder().where().eq("dev_id", (Object)deviceId).query();
            if (list.size() > 0) {
                DeviceEntity entity = (DeviceEntity)list.get(0);
                String clazz = entity.getDeviceClass();
                PiDeviceBase device = (PiDeviceBase)((Object)Class.forName(clazz).getConstructor(String.class).newInstance(entity.getDeviceId()));
                ((PiDeviceConfig)device.getConfig()).setString("DeviceName", entity.getDeviceName());
                for (DeviceConfigEntity cnf : confDao.queryForEq("dev_id", (Object)entity.getDeviceId())) {
                    ((PiDeviceConfig)device.getConfig()).setString(cnf.getKey(), cnf.getValue());
                }
                return device;
            }
            return null;
        }
        catch (Exception e) {
            logger.error((Object)"db error.", (Throwable)e);
            return null;
        }
    }

    public static List<PiDeviceBase<?>> loadDevices() {
        try {
            Dao deviceDao = DatabaseManager.createDao(DeviceEntity.class);
            Dao confDao = DatabaseManager.createDao(DeviceConfigEntity.class);
            List list = deviceDao.queryBuilder().orderBy("dev_id", true).query();
            ArrayList deviceList = new ArrayList();
            for (DeviceEntity entity : list) {
                String clazz = entity.getDeviceClass();
                PiDeviceBase device = (PiDeviceBase)((Object)Class.forName(clazz).getConstructor(String.class).newInstance(entity.getDeviceId()));
                ((PiDeviceConfig)device.getConfig()).setString("DeviceName", entity.getDeviceName());
                for (DeviceConfigEntity cnf : confDao.queryForEq("dev_id", (Object)entity.getDeviceId())) {
                    ((PiDeviceConfig)device.getConfig()).setString(cnf.getKey(), cnf.getValue());
                }
                deviceList.add(device);
            }
            return deviceList;
        }
        catch (Exception e) {
            logger.error((Object)"db error.", (Throwable)e);
            return null;
        }
    }

    public static <T extends IDevice<?>> List<T> loadDevices(Class<T> clazz) {
        try {
            Dao deviceDao = DatabaseManager.createDao(DeviceEntity.class);
            Dao confDao = DatabaseManager.createDao(DeviceConfigEntity.class);
            List list = deviceDao.queryBuilder().orderBy("dev_id", true).where().eq("dev_class", (Object)clazz.getName()).query();
            ArrayList<IDevice> deviceList = new ArrayList<IDevice>();
            for (DeviceEntity entity : list) {
                IDevice device = (IDevice)Class.forName(clazz.getName()).getConstructor(String.class).newInstance(entity.getDeviceId());
                device.getConfig().setString("DeviceName", entity.getDeviceName());
                for (DeviceConfigEntity cnf : confDao.queryForEq("dev_id", (Object)entity.getDeviceId())) {
                    device.getConfig().setString(cnf.getKey(), cnf.getValue());
                }
                deviceList.add(device);
            }
            return deviceList;
        }
        catch (Exception e) {
            logger.error((Object)"db error.", (Throwable)e);
            return null;
        }
    }

    public static IComponent<?> loadComponent(String componentId) {
        try {
            Dao compoDao = DatabaseManager.createDao(ComponentEntity.class);
            Dao compoConfDao = DatabaseManager.createDao(ComponentConfigEntity.class);
            List list = compoDao.queryBuilder().where().eq("compo_id", (Object)componentId).query();
            if (list.size() > 0) {
                ComponentEntity entity = (ComponentEntity)list.get(0);
                String clazz = entity.getComponentClass();
                String compoId = entity.getComponentId();
                IComponent compo = (IComponent)Class.forName(clazz).getConstructor(String.class).newInstance(compoId);
                compo.getConfig().setString("ComponentName", entity.getComponentName());
                for (ComponentConfigEntity cnf_entity : compoConfDao.queryForEq("compo_id", (Object)compoId)) {
                    compo.getConfig().setString(cnf_entity.getKey(), cnf_entity.getValue());
                }
                return compo;
            }
            return null;
        }
        catch (Exception e) {
            logger.error((Object)"db error.", (Throwable)e);
            return null;
        }
    }

    public static <T extends IComponent<?>> List<T> loadComponents(Class<T> clazz) {
        try {
            Dao compoDao = DatabaseManager.createDao(ComponentEntity.class);
            Dao compoConfDao = DatabaseManager.createDao(ComponentConfigEntity.class);
            ArrayList<IComponent> components = new ArrayList<IComponent>();
            for (ComponentEntity entity : compoDao.queryBuilder().orderBy("compo_id", true).where().eq("compo_class", (Object)clazz.getName()).query()) {
                String compoId = entity.getComponentId();
                IComponent compo = (IComponent)Class.forName(clazz.getName()).getConstructor(String.class).newInstance(compoId);
                compo.getConfig().setString("ComponentName", entity.getComponentName());
                for (ComponentConfigEntity cnf_entity : compoConfDao.queryForEq("compo_id", (Object)compoId)) {
                    compo.getConfig().setString(cnf_entity.getKey(), cnf_entity.getValue());
                }
                components.add(compo);
            }
            return components;
        }
        catch (Exception e) {
            logger.error((Object)"db error.", (Throwable)e);
            return null;
        }
    }

    public static List<IComponent<?>> loadComponents(String deviceId) {
        try {
            Dao compoDao = DatabaseManager.createDao(ComponentEntity.class);
            Dao compoConfDao = DatabaseManager.createDao(ComponentConfigEntity.class);
            ArrayList components = new ArrayList();
            for (ComponentEntity entity : compoDao.queryBuilder().orderBy("compo_id", true).where().eq("dev_id", (Object)deviceId).query()) {
                String clazz = entity.getComponentClass();
                String compoId = entity.getComponentId();
                IComponent compo = (IComponent)Class.forName(clazz).getConstructor(String.class).newInstance(compoId);
                compo.getConfig().setString("ComponentName", entity.getComponentName());
                for (ComponentConfigEntity cnf_entity : compoConfDao.queryForEq("compo_id", (Object)compoId)) {
                    compo.getConfig().setString(cnf_entity.getKey(), cnf_entity.getValue());
                }
                components.add(compo);
            }
            return components;
        }
        catch (Exception e) {
            logger.error((Object)"db error.", (Throwable)e);
            return null;
        }
    }

    public static <T extends IComponent<?>> List<T> loadComponents(String deviceId, Class<T> clazz) {
        try {
            Dao compoDao = DatabaseManager.createDao(ComponentEntity.class);
            Dao compoConfDao = DatabaseManager.createDao(ComponentConfigEntity.class);
            ArrayList<IComponent> components = new ArrayList<IComponent>();
            for (ComponentEntity entity : compoDao.queryBuilder().orderBy("compo_id", true).where().eq("dev_id", (Object)deviceId).and().eq("compo_class", (Object)clazz.getName()).query()) {
                String compoId = entity.getComponentId();
                IComponent compo = (IComponent)Class.forName(clazz.getName()).getConstructor(String.class).newInstance(compoId);
                compo.getConfig().setString("ComponentName", entity.getComponentName());
                for (ComponentConfigEntity cnf_entity : compoConfDao.queryForEq("compo_id", (Object)compoId)) {
                    compo.getConfig().setString(cnf_entity.getKey(), cnf_entity.getValue());
                }
                components.add(compo);
            }
            return components;
        }
        catch (Exception e) {
            logger.error((Object)"db error.", (Throwable)e);
            return null;
        }
    }

    public static void saveDevice(IDevice<?> device) throws SQLException {
        DatabaseUtils.deleteDevice(device.getId());
        Dao devDao = DatabaseManager.createDao(DeviceEntity.class);
        DeviceEntity devEnt = new DeviceEntity();
        devEnt.setDeviceClass(device.getClass().getName());
        devEnt.setDeviceId(device.getId());
        devEnt.setDeviceName(device.getConfig().getString("DeviceName"));
        devDao.createOrUpdate((Object)devEnt);
        DatabaseUtils.saveDeviceConfig(device.getId(), device.getConfig());
        for (IComponent compo : device.listComponents()) {
            DatabaseUtils.saveComponent(device.getId(), compo);
        }
    }

    public static void saveComponent(String deviceId, IComponent<?> component) throws SQLException {
        DatabaseUtils.deleteComponent(component.getId());
        Dao devDao = DatabaseManager.createDao(ComponentEntity.class);
        ComponentEntity compoEnt = new ComponentEntity();
        compoEnt.setComponentClass(component.getClass().getName());
        compoEnt.setDeviceId(deviceId);
        compoEnt.setComponentId(component.getId());
        compoEnt.setComponentName(component.getConfig().getString("ComponentName"));
        devDao.createOrUpdate((Object)compoEnt);
        DatabaseUtils.saveComponentConfig(component.getId(), component.getConfig());
    }

    public static void saveDeviceConfig(String deviceId, DeviceConfig conf) throws SQLException {
        Dao confDao = DatabaseManager.createDao(DeviceConfigEntity.class);
        DeleteBuilder del = confDao.deleteBuilder();
        del.where().eq("dev_id", (Object)deviceId);
        confDao.delete(del.prepare());
        for (Map.Entry entry : conf.entrySet()) {
            DeviceConfigEntity confEnt = new DeviceConfigEntity();
            confEnt.setId(String.valueOf(deviceId) + "." + entry.getKey());
            confEnt.setDeviceId(deviceId);
            confEnt.setKey(entry.getKey().toString());
            if (entry.getValue() != null) {
                confEnt.setValue(entry.getValue().toString());
            }
            confDao.createOrUpdate((Object)confEnt);
        }
    }

    public static void saveNodeConfig(NodeConfig conf) throws SQLException {
        Dao dao = DatabaseManager.createDao(NodeConfigEntity.class);
        dao.deleteBuilder().delete();
        for (Map.Entry entry : conf.entrySet()) {
            NodeConfigEntity entity = new NodeConfigEntity();
            entity.setKey(entry.getKey().toString());
            if (entry.getValue() != null) {
                entity.setValue(entry.getValue().toString());
            }
            dao.createOrUpdate((Object)entity);
        }
    }

    public static void saveNodeConfig(String key, String param) throws SQLException {
        Dao dao = DatabaseManager.createDao(NodeConfigEntity.class);
        NodeConfigEntity entity = new NodeConfigEntity();
        entity.setKey(key);
        entity.setValue(param);
        dao.createOrUpdate((Object)entity);
    }

    public static void saveComponentConfig(String componentId, ComponentConfig conf) throws SQLException {
        Dao confDao = DatabaseManager.createDao(ComponentConfigEntity.class);
        DeleteBuilder del = confDao.deleteBuilder();
        del.where().eq("compo_id", (Object)componentId);
        confDao.delete(del.prepare());
        for (Map.Entry entry : conf.entrySet()) {
            ComponentConfigEntity confEnt = new ComponentConfigEntity();
            confEnt.setId(String.valueOf(componentId) + "." + entry.getKey().toString());
            confEnt.setComponentId(componentId);
            confEnt.setKey(entry.getKey().toString());
            if (entry.getValue() != null) {
                confEnt.setValue(entry.getValue().toString());
            }
            confDao.create((Object)confEnt);
        }
    }

    public static void saveComponentConfig(String componentId, String key, String param) throws SQLException {
        Dao confDao = DatabaseManager.createDao(ComponentConfigEntity.class);
        ComponentConfigEntity confEnt = new ComponentConfigEntity();
        confEnt.setId(String.valueOf(componentId) + "." + key);
        confEnt.setComponentId(componentId);
        confEnt.setKey(key);
        confEnt.setValue(param);
        confDao.createOrUpdate((Object)confEnt);
    }

    public static void saveComponentData(String componentId, long time, Number value) throws SQLException {
        if (componentId == null || value == null) {
            return;
        }
        Dao dataDao = DatabaseManager.createDao(ComponentValueEntity.class);
        ComponentValueEntity entity = new ComponentValueEntity();
        entity.setRecNo(DatabaseUtils.nextRecNo());
        entity.setComponentId(componentId);
        entity.setValue(value.doubleValue());
        entity.setTime(time);
        dataDao.createOrUpdate((Object)entity);
    }

    public static void deleteDevice(String deviceId) throws SQLException {
        Dao devDao = DatabaseManager.createDao(DeviceEntity.class);
        List devList = devDao.queryForEq("dev_id", (Object)deviceId);
        if (devList.size() == 0) {
            return;
        }
        Dao compoDao = DatabaseManager.createDao(ComponentEntity.class);
        Dao confDao = DatabaseManager.createDao(ComponentConfigEntity.class);
        Dao dataDao = DatabaseManager.createDao(ComponentValueEntity.class);
        for (ComponentEntity compo : compoDao.queryForEq("dev_id", (Object)deviceId)) {
            String componentId = compo.getComponentId();
            DeleteBuilder del = confDao.deleteBuilder();
            del.where().eq("compo_id", (Object)componentId);
            confDao.delete(del.prepare());
            DeleteBuilder ddel = dataDao.deleteBuilder();
            ddel.where().eq("compo_id", (Object)componentId);
            dataDao.delete(ddel.prepare());
            compoDao.deleteById((Object)componentId);
        }
        Dao dconfDao = DatabaseManager.createDao(DeviceConfigEntity.class);
        DeleteBuilder del = dconfDao.deleteBuilder();
        del.where().eq("dev_id", (Object)deviceId);
        dconfDao.delete(del.prepare());
        devDao.deleteById((Object)deviceId);
    }

    public static void deleteComponent(String componentId) throws SQLException {
        Dao confDao = DatabaseManager.createDao(ComponentConfigEntity.class);
        DeleteBuilder del = confDao.deleteBuilder();
        del.where().eq("compo_id", (Object)componentId);
        confDao.delete(del.prepare());
        Dao dataDao = DatabaseManager.createDao(ComponentValueEntity.class);
        DeleteBuilder ddel = dataDao.deleteBuilder();
        ddel.where().eq("compo_id", (Object)componentId);
        dataDao.delete(ddel.prepare());
        Dao compoDao = DatabaseManager.createDao(ComponentEntity.class);
        compoDao.deleteById((Object)componentId);
    }

    public static List<ComponentValueEntity> getComponentValues(String componentId, Date start, Date end) throws SQLException {
        Dao dataDao = DatabaseManager.createDao(ComponentValueEntity.class);
        QueryBuilder query = dataDao.queryBuilder();
        Where where = null;
        if (componentId != null) {
            where = query.where().eq("compo_id", (Object)componentId);
        }
        if (start != null) {
            where = where != null ? where.and().ge("time", (Object)start.getTime()) : query.where().ge("time", (Object)start.getTime());
        }
        if (end != null) {
            where = where != null ? where.and().le("time", (Object)end.getTime()) : query.where().le("time", (Object)end.getTime());
        }
        return query.query();
    }

    public static int clearComponentValues() throws SQLException {
        Dao dataDao = DatabaseManager.createDao(ComponentValueEntity.class);
        int num = dataDao.deleteBuilder().delete();
        recNo = 0L;
        return num;
    }

    public static List<LogEntity> getLogs(int fetchSize) throws SQLException {
        Dao logDao = DatabaseManager.createDao(LogEntity.class);
        QueryBuilder query = logDao.queryBuilder().limit(Long.valueOf(fetchSize)).orderBy("time", false).orderBy("log_no", false);
        return query.query();
    }

    public static List<LogEntity> getLogs(String category, int fetchSize) throws SQLException {
        Dao logDao = DatabaseManager.createDao(LogEntity.class);
        QueryBuilder query = logDao.queryBuilder().limit(Long.valueOf(fetchSize)).orderBy("time", false).orderBy("log_no", false);
        return query.where().eq("category", (Object)category).query();
    }

    public static void saveLog(LogEntity entity) throws SQLException {
        Dao logDao = DatabaseManager.createDao(LogEntity.class);
        entity.setLogNo(DatabaseUtils.nextLogNo());
        logDao.createOrUpdate((Object)entity);
    }

    public static int clearLogs() throws SQLException {
        Dao logDao = DatabaseManager.createDao(LogEntity.class);
        int num = logDao.deleteBuilder().delete();
        logNo = 0;
        return num;
    }

    public static synchronized String nextDeviceId() {
        return "D:" + System.currentTimeMillis() + "-" + idNo++;
    }

    public static synchronized String nextComponentId() {
        return "C:" + System.currentTimeMillis() + "-" + idNo++;
    }

    private static synchronized long nextRecNo() {
        if (recNo >= 100000L) {
            recNo = 0L;
        }
        return ++recNo;
    }

    private static synchronized int nextLogNo() {
        if (logNo >= 1000) {
            logNo = 0;
        }
        return ++logNo;
    }
}

