/*
 * Decompiled with CFR 0.152.
 */
package com.wabit.uecs.pi.db;

import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.jdbc.JdbcConnectionSource;
import com.j256.ormlite.misc.TransactionManager;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.table.TableUtils;
import com.wabit.uecs.pi.db.ComponentConfigEntity;
import com.wabit.uecs.pi.db.ComponentEntity;
import com.wabit.uecs.pi.db.ComponentValueEntity;
import com.wabit.uecs.pi.db.DeviceConfigEntity;
import com.wabit.uecs.pi.db.DeviceEntity;
import com.wabit.uecs.pi.db.LogEntity;
import com.wabit.uecs.pi.db.NodeConfigEntity;
import java.io.File;
import java.sql.SQLException;
import java.util.concurrent.Callable;

public class DatabaseManager {
    private static String dataBaseURL;
    private static JdbcConnectionSource source;

    public static void init(String dbPath) throws SQLException {
        dataBaseURL = "jdbc:sqlite:" + dbPath;
        source = new JdbcConnectionSource(dataBaseURL);
        File dbFile = new File(dbPath);
        if (!dbFile.exists()) {
            dbFile.getParentFile().mkdirs();
            DatabaseManager.createTables(NodeConfigEntity.class, ComponentValueEntity.class, DeviceEntity.class, DeviceConfigEntity.class, ComponentEntity.class, ComponentConfigEntity.class, LogEntity.class);
        }
    }

    private static ConnectionSource getConnectionSource() {
        return source;
    }

    public static synchronized void callInTransaction(Callable<?> callable) throws SQLException {
        TransactionManager.callInTransaction((ConnectionSource)DatabaseManager.getConnectionSource(), callable);
    }

    public static synchronized <T, ID> Dao<T, ID> createDao(Class<T> clazz) throws SQLException {
        Dao dao = DaoManager.createDao((ConnectionSource)source, clazz);
        return dao;
    }

    public static void createTables(Class<?> ... tables) throws SQLException {
        Class<?>[] classArray = tables;
        int n = tables.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> table = classArray[n2];
            TableUtils.createTable((ConnectionSource)source, table);
            ++n2;
        }
    }
}

