/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.dao;

import com.j256.ormlite.dao.BaseForeignCollection;
import com.j256.ormlite.dao.CloseableIterable;
import com.j256.ormlite.dao.CloseableIterator;
import com.j256.ormlite.dao.CloseableWrappedIterable;
import com.j256.ormlite.dao.CloseableWrappedIterableImpl;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.dao.ForeignCollection;
import com.j256.ormlite.dao.GenericRawResults;
import com.j256.ormlite.dao.ObjectCache;
import com.j256.ormlite.dao.RawRowMapper;
import com.j256.ormlite.dao.ReferenceObjectCache;
import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.misc.BaseDaoEnabled;
import com.j256.ormlite.misc.SqlExceptionUtil;
import com.j256.ormlite.stmt.DeleteBuilder;
import com.j256.ormlite.stmt.GenericRowMapper;
import com.j256.ormlite.stmt.PreparedDelete;
import com.j256.ormlite.stmt.PreparedQuery;
import com.j256.ormlite.stmt.PreparedUpdate;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.SelectArg;
import com.j256.ormlite.stmt.SelectIterator;
import com.j256.ormlite.stmt.StatementBuilder;
import com.j256.ormlite.stmt.StatementExecutor;
import com.j256.ormlite.stmt.UpdateBuilder;
import com.j256.ormlite.stmt.Where;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.support.DatabaseConnection;
import com.j256.ormlite.support.DatabaseResults;
import com.j256.ormlite.table.DatabaseTableConfig;
import com.j256.ormlite.table.ObjectFactory;
import com.j256.ormlite.table.TableInfo;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseDaoImpl<T, ID>
implements Dao<T, ID> {
    private boolean initialized;
    protected StatementExecutor<T, ID> statementExecutor;
    protected DatabaseType databaseType;
    protected final Class<T> dataClass;
    protected DatabaseTableConfig<T> tableConfig;
    protected TableInfo<T, ID> tableInfo;
    protected ConnectionSource connectionSource;
    protected CloseableIterator<T> lastIterator;
    protected ObjectFactory<T> objectFactory;
    private static final ThreadLocal<DaoConfigArray> daoConfigLevelLocal = new ThreadLocal<DaoConfigArray>(){

        @Override
        protected DaoConfigArray initialValue() {
            return new DaoConfigArray();
        }
    };
    private static ReferenceObjectCache defaultObjectCache;
    private ObjectCache objectCache;

    protected BaseDaoImpl(Class<T> dataClass) throws SQLException {
        this(null, dataClass, null);
    }

    protected BaseDaoImpl(ConnectionSource connectionSource, Class<T> dataClass) throws SQLException {
        this(connectionSource, dataClass, null);
    }

    protected BaseDaoImpl(ConnectionSource connectionSource, DatabaseTableConfig<T> tableConfig) throws SQLException {
        this(connectionSource, tableConfig.getDataClass(), tableConfig);
    }

    private BaseDaoImpl(ConnectionSource connectionSource, Class<T> dataClass, DatabaseTableConfig<T> tableConfig) throws SQLException {
        this.dataClass = dataClass;
        this.tableConfig = tableConfig;
        if (connectionSource != null) {
            this.connectionSource = connectionSource;
            this.initialize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws SQLException {
        if (this.initialized) {
            return;
        }
        if (this.connectionSource == null) {
            throw new IllegalStateException("connectionSource was never set on " + this.getClass().getSimpleName());
        }
        this.databaseType = this.connectionSource.getDatabaseType();
        if (this.databaseType == null) {
            throw new IllegalStateException("connectionSource is getting a null DatabaseType in " + this.getClass().getSimpleName());
        }
        if (this.tableConfig == null) {
            this.tableInfo = new TableInfo(this.connectionSource, this, this.dataClass);
        } else {
            this.tableConfig.extractFieldTypes(this.connectionSource);
            this.tableInfo = new TableInfo(this.databaseType, this, this.tableConfig);
        }
        this.statementExecutor = new StatementExecutor<T, ID>(this.databaseType, this.tableInfo, this);
        DaoConfigArray daoConfigLevel = daoConfigLevelLocal.get();
        if (daoConfigLevel.size() > 0) {
            daoConfigLevel.addDao(this);
            return;
        }
        daoConfigLevel.addDao(this);
        try {
            for (int i = 0; i < daoConfigLevel.size(); ++i) {
                BaseDaoImpl<?, ?> dao = daoConfigLevel.get(i);
                DaoManager.registerDao(this.connectionSource, dao);
                try {
                    for (FieldType fieldType : dao.getTableInfo().getFieldTypes()) {
                        fieldType.configDaoInformation(this.connectionSource, dao.getDataClass());
                    }
                }
                catch (SQLException e) {
                    DaoManager.unregisterDao(this.connectionSource, dao);
                    throw e;
                }
                dao.initialized = true;
            }
        }
        finally {
            daoConfigLevel.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T queryForId(ID id) throws SQLException {
        this.checkForInitialized();
        DatabaseConnection connection = this.connectionSource.getReadOnlyConnection();
        try {
            T t = this.statementExecutor.queryForId(connection, id, this.objectCache);
            return t;
        }
        finally {
            this.connectionSource.releaseConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T queryForFirst(PreparedQuery<T> preparedQuery) throws SQLException {
        this.checkForInitialized();
        DatabaseConnection connection = this.connectionSource.getReadOnlyConnection();
        try {
            T t = this.statementExecutor.queryForFirst(connection, preparedQuery, this.objectCache);
            return t;
        }
        finally {
            this.connectionSource.releaseConnection(connection);
        }
    }

    @Override
    public List<T> queryForAll() throws SQLException {
        this.checkForInitialized();
        return this.statementExecutor.queryForAll(this.connectionSource, this.objectCache);
    }

    @Override
    public List<T> queryForEq(String fieldName, Object value) throws SQLException {
        return this.queryBuilder().where().eq(fieldName, value).query();
    }

    @Override
    public QueryBuilder<T, ID> queryBuilder() {
        this.checkForInitialized();
        return new QueryBuilder<T, ID>(this.databaseType, this.tableInfo, this);
    }

    @Override
    public UpdateBuilder<T, ID> updateBuilder() {
        this.checkForInitialized();
        return new UpdateBuilder<T, ID>(this.databaseType, this.tableInfo, this);
    }

    @Override
    public DeleteBuilder<T, ID> deleteBuilder() {
        this.checkForInitialized();
        return new DeleteBuilder<T, ID>(this.databaseType, this.tableInfo, this);
    }

    @Override
    public List<T> query(PreparedQuery<T> preparedQuery) throws SQLException {
        this.checkForInitialized();
        return this.statementExecutor.query(this.connectionSource, preparedQuery, this.objectCache);
    }

    @Override
    public List<T> queryForMatching(T matchObj) throws SQLException {
        return this.queryForMatching(matchObj, false);
    }

    @Override
    public List<T> queryForMatchingArgs(T matchObj) throws SQLException {
        return this.queryForMatching(matchObj, true);
    }

    @Override
    public List<T> queryForFieldValues(Map<String, Object> fieldValues) throws SQLException {
        return this.queryForFieldValues(fieldValues, false);
    }

    @Override
    public List<T> queryForFieldValuesArgs(Map<String, Object> fieldValues) throws SQLException {
        return this.queryForFieldValues(fieldValues, true);
    }

    @Override
    public T queryForSameId(T data) throws SQLException {
        this.checkForInitialized();
        if (data == null) {
            return null;
        }
        ID id = this.extractId(data);
        if (id == null) {
            return null;
        }
        return this.queryForId(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int create(T data) throws SQLException {
        this.checkForInitialized();
        if (data == null) {
            return 0;
        }
        if (data instanceof BaseDaoEnabled) {
            BaseDaoEnabled daoEnabled = (BaseDaoEnabled)data;
            daoEnabled.setDao(this);
        }
        DatabaseConnection connection = this.connectionSource.getReadWriteConnection();
        try {
            int n = this.statementExecutor.create(connection, data, this.objectCache);
            return n;
        }
        finally {
            this.connectionSource.releaseConnection(connection);
        }
    }

    @Override
    public T createIfNotExists(T data) throws SQLException {
        if (data == null) {
            return null;
        }
        T existing = this.queryForSameId(data);
        if (existing == null) {
            this.create(data);
            return data;
        }
        return existing;
    }

    @Override
    public Dao.CreateOrUpdateStatus createOrUpdate(T data) throws SQLException {
        if (data == null) {
            return new Dao.CreateOrUpdateStatus(false, false, 0);
        }
        ID id = this.extractId(data);
        if (id == null || !this.idExists(id)) {
            int numRows = this.create(data);
            return new Dao.CreateOrUpdateStatus(true, false, numRows);
        }
        int numRows = this.update(data);
        return new Dao.CreateOrUpdateStatus(false, true, numRows);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int update(T data) throws SQLException {
        this.checkForInitialized();
        if (data == null) {
            return 0;
        }
        DatabaseConnection connection = this.connectionSource.getReadWriteConnection();
        try {
            int n = this.statementExecutor.update(connection, data, this.objectCache);
            return n;
        }
        finally {
            this.connectionSource.releaseConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int updateId(T data, ID newId) throws SQLException {
        this.checkForInitialized();
        if (data == null) {
            return 0;
        }
        DatabaseConnection connection = this.connectionSource.getReadWriteConnection();
        try {
            int n = this.statementExecutor.updateId(connection, data, newId, this.objectCache);
            return n;
        }
        finally {
            this.connectionSource.releaseConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int update(PreparedUpdate<T> preparedUpdate) throws SQLException {
        this.checkForInitialized();
        DatabaseConnection connection = this.connectionSource.getReadWriteConnection();
        try {
            int n = this.statementExecutor.update(connection, preparedUpdate);
            return n;
        }
        finally {
            this.connectionSource.releaseConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int refresh(T data) throws SQLException {
        this.checkForInitialized();
        if (data == null) {
            return 0;
        }
        if (data instanceof BaseDaoEnabled) {
            BaseDaoEnabled daoEnabled = (BaseDaoEnabled)data;
            daoEnabled.setDao(this);
        }
        DatabaseConnection connection = this.connectionSource.getReadOnlyConnection();
        try {
            int n = this.statementExecutor.refresh(connection, data, this.objectCache);
            return n;
        }
        finally {
            this.connectionSource.releaseConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int delete(T data) throws SQLException {
        this.checkForInitialized();
        if (data == null) {
            return 0;
        }
        DatabaseConnection connection = this.connectionSource.getReadWriteConnection();
        try {
            int n = this.statementExecutor.delete(connection, data, this.objectCache);
            return n;
        }
        finally {
            this.connectionSource.releaseConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deleteById(ID id) throws SQLException {
        this.checkForInitialized();
        if (id == null) {
            return 0;
        }
        DatabaseConnection connection = this.connectionSource.getReadWriteConnection();
        try {
            int n = this.statementExecutor.deleteById(connection, id, this.objectCache);
            return n;
        }
        finally {
            this.connectionSource.releaseConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int delete(Collection<T> datas) throws SQLException {
        this.checkForInitialized();
        if (datas == null || datas.isEmpty()) {
            return 0;
        }
        DatabaseConnection connection = this.connectionSource.getReadWriteConnection();
        try {
            int n = this.statementExecutor.deleteObjects(connection, datas, this.objectCache);
            return n;
        }
        finally {
            this.connectionSource.releaseConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deleteIds(Collection<ID> ids) throws SQLException {
        this.checkForInitialized();
        if (ids == null || ids.isEmpty()) {
            return 0;
        }
        DatabaseConnection connection = this.connectionSource.getReadWriteConnection();
        try {
            int n = this.statementExecutor.deleteIds(connection, ids, this.objectCache);
            return n;
        }
        finally {
            this.connectionSource.releaseConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int delete(PreparedDelete<T> preparedDelete) throws SQLException {
        this.checkForInitialized();
        DatabaseConnection connection = this.connectionSource.getReadWriteConnection();
        try {
            int n = this.statementExecutor.delete(connection, preparedDelete);
            return n;
        }
        finally {
            this.connectionSource.releaseConnection(connection);
        }
    }

    @Override
    public CloseableIterator<T> iterator() {
        return this.iterator(-1);
    }

    @Override
    public CloseableIterator<T> closeableIterator() {
        return this.iterator(-1);
    }

    @Override
    public CloseableIterator<T> iterator(int resultFlags) {
        this.checkForInitialized();
        this.lastIterator = this.createIterator(resultFlags);
        return this.lastIterator;
    }

    @Override
    public CloseableWrappedIterable<T> getWrappedIterable() {
        this.checkForInitialized();
        return new CloseableWrappedIterableImpl(new CloseableIterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return this.closeableIterator();
            }

            @Override
            public CloseableIterator<T> closeableIterator() {
                try {
                    return BaseDaoImpl.this.createIterator(-1);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Could not build iterator for " + BaseDaoImpl.this.dataClass, e);
                }
            }
        });
    }

    @Override
    public CloseableWrappedIterable<T> getWrappedIterable(final PreparedQuery<T> preparedQuery) {
        this.checkForInitialized();
        return new CloseableWrappedIterableImpl(new CloseableIterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return this.closeableIterator();
            }

            @Override
            public CloseableIterator<T> closeableIterator() {
                try {
                    return BaseDaoImpl.this.createIterator(preparedQuery, -1);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Could not build prepared-query iterator for " + BaseDaoImpl.this.dataClass, e);
                }
            }
        });
    }

    @Override
    public void closeLastIterator() throws SQLException {
        if (this.lastIterator != null) {
            this.lastIterator.close();
            this.lastIterator = null;
        }
    }

    @Override
    public CloseableIterator<T> iterator(PreparedQuery<T> preparedQuery) throws SQLException {
        return this.iterator(preparedQuery, -1);
    }

    @Override
    public CloseableIterator<T> iterator(PreparedQuery<T> preparedQuery, int resultFlags) throws SQLException {
        this.checkForInitialized();
        this.lastIterator = this.createIterator(preparedQuery, resultFlags);
        return this.lastIterator;
    }

    @Override
    public GenericRawResults<String[]> queryRaw(String query, String ... arguments) throws SQLException {
        this.checkForInitialized();
        try {
            return this.statementExecutor.queryRaw(this.connectionSource, query, arguments, this.objectCache);
        }
        catch (SQLException e) {
            throw SqlExceptionUtil.create("Could not perform raw query for " + query, e);
        }
    }

    @Override
    public <GR> GenericRawResults<GR> queryRaw(String query, RawRowMapper<GR> mapper, String ... arguments) throws SQLException {
        this.checkForInitialized();
        try {
            return this.statementExecutor.queryRaw(this.connectionSource, query, mapper, arguments, this.objectCache);
        }
        catch (SQLException e) {
            throw SqlExceptionUtil.create("Could not perform raw query for " + query, e);
        }
    }

    @Override
    public GenericRawResults<Object[]> queryRaw(String query, DataType[] columnTypes, String ... arguments) throws SQLException {
        this.checkForInitialized();
        try {
            return this.statementExecutor.queryRaw(this.connectionSource, query, columnTypes, arguments, this.objectCache);
        }
        catch (SQLException e) {
            throw SqlExceptionUtil.create("Could not perform raw query for " + query, e);
        }
    }

    @Override
    public long queryRawValue(String query, String ... arguments) throws SQLException {
        this.checkForInitialized();
        DatabaseConnection connection = this.connectionSource.getReadOnlyConnection();
        try {
            long l = this.statementExecutor.queryForLong(connection, query, arguments);
            return l;
        }
        catch (SQLException e) {
            throw SqlExceptionUtil.create("Could not perform raw value query for " + query, e);
        }
        finally {
            this.connectionSource.releaseConnection(connection);
        }
    }

    @Override
    public int executeRaw(String statement, String ... arguments) throws SQLException {
        this.checkForInitialized();
        DatabaseConnection connection = this.connectionSource.getReadWriteConnection();
        try {
            int n = this.statementExecutor.executeRaw(connection, statement, arguments);
            return n;
        }
        catch (SQLException e) {
            throw SqlExceptionUtil.create("Could not run raw execute statement " + statement, e);
        }
        finally {
            this.connectionSource.releaseConnection(connection);
        }
    }

    @Override
    public int executeRawNoArgs(String statement) throws SQLException {
        this.checkForInitialized();
        DatabaseConnection connection = this.connectionSource.getReadWriteConnection();
        try {
            int n = this.statementExecutor.executeRawNoArgs(connection, statement);
            return n;
        }
        catch (SQLException e) {
            throw SqlExceptionUtil.create("Could not run raw execute statement " + statement, e);
        }
        finally {
            this.connectionSource.releaseConnection(connection);
        }
    }

    @Override
    public int updateRaw(String statement, String ... arguments) throws SQLException {
        this.checkForInitialized();
        DatabaseConnection connection = this.connectionSource.getReadWriteConnection();
        try {
            int n = this.statementExecutor.updateRaw(connection, statement, arguments);
            return n;
        }
        catch (SQLException e) {
            throw SqlExceptionUtil.create("Could not run raw update statement " + statement, e);
        }
        finally {
            this.connectionSource.releaseConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <CT> CT callBatchTasks(Callable<CT> callable) throws SQLException {
        this.checkForInitialized();
        DatabaseConnection connection = this.connectionSource.getReadWriteConnection();
        try {
            boolean saved = this.connectionSource.saveSpecialConnection(connection);
            CT CT = this.statementExecutor.callBatchTasks(connection, saved, callable);
            return CT;
        }
        finally {
            this.connectionSource.clearSpecialConnection(connection);
            this.connectionSource.releaseConnection(connection);
        }
    }

    @Override
    public String objectToString(T data) {
        this.checkForInitialized();
        return this.tableInfo.objectToString(data);
    }

    @Override
    public boolean objectsEqual(T data1, T data2) throws SQLException {
        this.checkForInitialized();
        for (FieldType fieldType : this.tableInfo.getFieldTypes()) {
            Object fieldObj1 = fieldType.extractJavaFieldValue(data1);
            Object fieldObj2 = fieldType.extractJavaFieldValue(data2);
            if (fieldType.getDataPersister().dataIsEqual(fieldObj1, fieldObj2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public ID extractId(T data) throws SQLException {
        this.checkForInitialized();
        FieldType idField = this.tableInfo.getIdField();
        if (idField == null) {
            throw new SQLException("Class " + this.dataClass + " does not have an id field");
        }
        Object id = idField.extractJavaFieldValue(data);
        return (ID)id;
    }

    @Override
    public Class<T> getDataClass() {
        return this.dataClass;
    }

    @Override
    public FieldType findForeignFieldType(Class<?> clazz) {
        this.checkForInitialized();
        for (FieldType fieldType : this.tableInfo.getFieldTypes()) {
            if (fieldType.getType() != clazz) continue;
            return fieldType;
        }
        return null;
    }

    @Override
    public boolean isUpdatable() {
        return this.tableInfo.isUpdatable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTableExists() throws SQLException {
        this.checkForInitialized();
        DatabaseConnection connection = this.connectionSource.getReadOnlyConnection();
        try {
            boolean bl = connection.isTableExists(this.tableInfo.getTableName());
            return bl;
        }
        finally {
            this.connectionSource.releaseConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long countOf() throws SQLException {
        this.checkForInitialized();
        DatabaseConnection connection = this.connectionSource.getReadOnlyConnection();
        try {
            long l = this.statementExecutor.queryForCountStar(connection);
            return l;
        }
        finally {
            this.connectionSource.releaseConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long countOf(PreparedQuery<T> preparedQuery) throws SQLException {
        this.checkForInitialized();
        if (preparedQuery.getType() != StatementBuilder.StatementType.SELECT_LONG) {
            throw new IllegalArgumentException("Prepared query is not of type " + (Object)((Object)StatementBuilder.StatementType.SELECT_LONG) + ", did you call QueryBuilder.setCountOf(true)?");
        }
        DatabaseConnection connection = this.connectionSource.getReadOnlyConnection();
        try {
            long l = this.statementExecutor.queryForLong(connection, preparedQuery);
            return l;
        }
        finally {
            this.connectionSource.releaseConnection(connection);
        }
    }

    @Override
    public void assignEmptyForeignCollection(T parent, String fieldName) throws SQLException {
        this.makeEmptyForeignCollection(parent, fieldName);
    }

    @Override
    public <FT> ForeignCollection<FT> getEmptyForeignCollection(String fieldName) throws SQLException {
        return this.makeEmptyForeignCollection(null, fieldName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setObjectCache(boolean enabled) throws SQLException {
        if (enabled) {
            if (this.objectCache == null) {
                if (this.tableInfo.getIdField() == null) {
                    throw new SQLException("Class " + this.dataClass + " must have an id field to enable the object cache");
                }
                Class<?> clazz = this.getClass();
                synchronized (clazz) {
                    if (defaultObjectCache == null) {
                        defaultObjectCache = ReferenceObjectCache.makeWeakCache();
                    }
                    this.objectCache = defaultObjectCache;
                }
                this.objectCache.registerClass(this.dataClass);
            }
        } else if (this.objectCache != null) {
            this.objectCache.clear(this.dataClass);
            this.objectCache = null;
        }
    }

    @Override
    public void setObjectCache(ObjectCache objectCache) throws SQLException {
        if (objectCache == null) {
            if (this.objectCache != null) {
                this.objectCache.clear(this.dataClass);
                this.objectCache = null;
            }
        } else {
            if (this.objectCache != null && this.objectCache != objectCache) {
                this.objectCache.clear(this.dataClass);
            }
            if (this.tableInfo.getIdField() == null) {
                throw new SQLException("Class " + this.dataClass + " must have an id field to enable the object cache");
            }
            this.objectCache = objectCache;
            this.objectCache.registerClass(this.dataClass);
        }
    }

    @Override
    public ObjectCache getObjectCache() {
        return this.objectCache;
    }

    @Override
    public void clearObjectCache() {
        if (this.objectCache != null) {
            this.objectCache.clear(this.dataClass);
        }
    }

    public static synchronized void clearAllInternalObjectCaches() {
        if (defaultObjectCache != null) {
            defaultObjectCache.clearAll();
            defaultObjectCache = null;
        }
    }

    @Override
    public T mapSelectStarRow(DatabaseResults results) throws SQLException {
        return this.statementExecutor.getSelectStarRowMapper().mapRow(results);
    }

    @Override
    public GenericRowMapper<T> getSelectStarRowMapper() throws SQLException {
        return this.statementExecutor.getSelectStarRowMapper();
    }

    @Override
    public RawRowMapper<T> getRawRowMapper() {
        return this.statementExecutor.getRawRowMapper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean idExists(ID id) throws SQLException {
        DatabaseConnection connection = this.connectionSource.getReadOnlyConnection();
        try {
            boolean bl = this.statementExecutor.ifExists(connection, id);
            return bl;
        }
        finally {
            this.connectionSource.releaseConnection(connection);
        }
    }

    @Override
    public DatabaseConnection startThreadConnection() throws SQLException {
        DatabaseConnection connection = this.connectionSource.getReadWriteConnection();
        this.connectionSource.saveSpecialConnection(connection);
        return connection;
    }

    @Override
    public void endThreadConnection(DatabaseConnection connection) throws SQLException {
        this.connectionSource.clearSpecialConnection(connection);
        this.connectionSource.releaseConnection(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        DatabaseConnection connection = this.connectionSource.getReadWriteConnection();
        try {
            this.setAutoCommit(connection, autoCommit);
        }
        finally {
            this.connectionSource.releaseConnection(connection);
        }
    }

    @Override
    public void setAutoCommit(DatabaseConnection connection, boolean autoCommit) throws SQLException {
        connection.setAutoCommit(autoCommit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAutoCommit() throws SQLException {
        DatabaseConnection connection = this.connectionSource.getReadWriteConnection();
        try {
            boolean bl = this.isAutoCommit(connection);
            return bl;
        }
        finally {
            this.connectionSource.releaseConnection(connection);
        }
    }

    @Override
    public boolean isAutoCommit(DatabaseConnection connection) throws SQLException {
        return connection.isAutoCommit();
    }

    @Override
    public void commit(DatabaseConnection connection) throws SQLException {
        connection.commit(null);
    }

    @Override
    public void rollBack(DatabaseConnection connection) throws SQLException {
        connection.rollback(null);
    }

    public ObjectFactory<T> getObjectFactory() {
        return this.objectFactory;
    }

    @Override
    public void setObjectFactory(ObjectFactory<T> objectFactory) {
        this.checkForInitialized();
        this.objectFactory = objectFactory;
    }

    public DatabaseTableConfig<T> getTableConfig() {
        return this.tableConfig;
    }

    public TableInfo<T, ID> getTableInfo() {
        return this.tableInfo;
    }

    @Override
    public ConnectionSource getConnectionSource() {
        return this.connectionSource;
    }

    public void setConnectionSource(ConnectionSource connectionSource) {
        this.connectionSource = connectionSource;
    }

    public void setTableConfig(DatabaseTableConfig<T> tableConfig) {
        this.tableConfig = tableConfig;
    }

    static <T, ID> Dao<T, ID> createDao(ConnectionSource connectionSource, Class<T> clazz) throws SQLException {
        return new BaseDaoImpl<T, ID>(connectionSource, (Class)clazz){};
    }

    static <T, ID> Dao<T, ID> createDao(ConnectionSource connectionSource, DatabaseTableConfig<T> tableConfig) throws SQLException {
        return new BaseDaoImpl<T, ID>(connectionSource, (DatabaseTableConfig)tableConfig){};
    }

    protected void checkForInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("you must call initialize() before you can use the dao");
        }
    }

    private <FT> ForeignCollection<FT> makeEmptyForeignCollection(T parent, String fieldName) throws SQLException {
        this.checkForInitialized();
        Object id = parent == null ? null : (Object)this.extractId(parent);
        for (FieldType fieldType : this.tableInfo.getFieldTypes()) {
            if (!fieldType.getColumnName().equals(fieldName)) continue;
            BaseForeignCollection collection = fieldType.buildForeignCollection(parent, id);
            if (parent != null) {
                fieldType.assignField(parent, collection, true, null);
            }
            return collection;
        }
        throw new IllegalArgumentException("Could not find a field named " + fieldName);
    }

    private CloseableIterator<T> createIterator(int resultFlags) {
        try {
            SelectIterator<T, ID> iterator = this.statementExecutor.buildIterator(this, this.connectionSource, resultFlags, this.objectCache);
            return iterator;
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not build iterator for " + this.dataClass, e);
        }
    }

    private CloseableIterator<T> createIterator(PreparedQuery<T> preparedQuery, int resultFlags) throws SQLException {
        try {
            SelectIterator<T, ID> iterator = this.statementExecutor.buildIterator(this, this.connectionSource, preparedQuery, this.objectCache, resultFlags);
            return iterator;
        }
        catch (SQLException e) {
            throw SqlExceptionUtil.create("Could not build prepared-query iterator for " + this.dataClass, e);
        }
    }

    private List<T> queryForMatching(T matchObj, boolean useArgs) throws SQLException {
        this.checkForInitialized();
        QueryBuilder<T, ID> qb = this.queryBuilder();
        Where where = qb.where();
        int fieldC = 0;
        for (FieldType fieldType : this.tableInfo.getFieldTypes()) {
            Object fieldValue = fieldType.getFieldValueIfNotDefault(matchObj);
            if (fieldValue == null) continue;
            if (useArgs) {
                fieldValue = new SelectArg(fieldValue);
            }
            where.eq(fieldType.getColumnName(), fieldValue);
            ++fieldC;
        }
        if (fieldC == 0) {
            return Collections.emptyList();
        }
        where.and(fieldC);
        return qb.query();
    }

    private List<T> queryForFieldValues(Map<String, Object> fieldValues, boolean useArgs) throws SQLException {
        this.checkForInitialized();
        QueryBuilder<T, ID> qb = this.queryBuilder();
        Where where = qb.where();
        for (Map.Entry<String, Object> entry : fieldValues.entrySet()) {
            Object fieldValue = entry.getValue();
            if (useArgs) {
                fieldValue = new SelectArg(fieldValue);
            }
            where.eq(entry.getKey(), fieldValue);
        }
        if (fieldValues.size() == 0) {
            return Collections.emptyList();
        }
        where.and(fieldValues.size());
        return qb.query();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DaoConfigArray {
        private BaseDaoImpl<?, ?>[] daoArray = new BaseDaoImpl[10];
        private int daoArrayC = 0;

        private DaoConfigArray() {
        }

        public void addDao(BaseDaoImpl<?, ?> dao) {
            if (this.daoArrayC == this.daoArray.length) {
                BaseDaoImpl[] newDaoArray = new BaseDaoImpl[this.daoArray.length * 2];
                for (int i = 0; i < this.daoArray.length; ++i) {
                    newDaoArray[i] = this.daoArray[i];
                    this.daoArray[i] = null;
                }
                this.daoArray = newDaoArray;
            }
            this.daoArray[this.daoArrayC++] = dao;
        }

        public int size() {
            return this.daoArrayC;
        }

        public BaseDaoImpl<?, ?> get(int i) {
            return this.daoArray[i];
        }

        public void clear() {
            for (int i = 0; i < this.daoArrayC; ++i) {
                this.daoArray[i] = null;
            }
            this.daoArrayC = 0;
        }
    }
}

