/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.system;

import com.pi4j.util.ExecUtil;
import java.io.IOException;
import java.util.ArrayList;

public class NetworkInfo {
    private NetworkInfo() {
    }

    public static String getHostname() throws IOException, InterruptedException {
        return ExecUtil.execute("hostname --short")[0];
    }

    public static String getFQDN() throws IOException, InterruptedException {
        return ExecUtil.execute("hostname --fqdn")[0];
    }

    public static String[] getIPAddresses() throws IOException, InterruptedException {
        return ExecUtil.execute("hostname --all-ip-addresses", " ");
    }

    public static String getIPAddress() throws IOException, InterruptedException {
        return ExecUtil.execute("hostname -i")[0];
    }

    public static String[] getFQDNs() throws IOException, InterruptedException {
        return ExecUtil.execute("hostname --all-fqdns", " ");
    }

    public static String[] getNameservers() throws IOException, InterruptedException {
        String[] nameservers = ExecUtil.execute("cat /etc/resolv.conf");
        ArrayList<String> result = new ArrayList<String>();
        for (String nameserver : nameservers) {
            if (!nameserver.startsWith("nameserver")) continue;
            result.add(nameserver.substring(11).trim());
        }
        return result.toArray(new String[result.size()]);
    }
}

