/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.page;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.page.IManageablePage;
import org.apache.wicket.page.IPageManagerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RequestAdapter {
    private static final Logger log = LoggerFactory.getLogger(RequestAdapter.class);
    private final IPageManagerContext context;
    private final List<IManageablePage> touchedPages = new ArrayList<IManageablePage>();

    public RequestAdapter(IPageManagerContext context) {
        this.context = context;
    }

    protected abstract IManageablePage getPage(int var1);

    protected abstract void storeTouchedPages(List<IManageablePage> var1);

    protected abstract void newSessionCreated();

    protected void bind() {
        this.context.bind();
    }

    public void setSessionAttribute(String key, Serializable value) {
        this.context.setSessionAttribute(key, value);
    }

    public Serializable getSessionAttribute(String key) {
        return this.context.getSessionAttribute(key);
    }

    public String getSessionId() {
        return this.context.getSessionId();
    }

    protected IManageablePage findPage(int id) {
        for (IManageablePage page : this.touchedPages) {
            if (page.getPageId() != id) continue;
            return page;
        }
        return null;
    }

    protected void touch(IManageablePage page) {
        if (this.findPage(page.getPageId()) == null) {
            this.touchedPages.add(page);
        }
    }

    protected void untouch(IManageablePage page) {
        Iterator<IManageablePage> iterator = this.touchedPages.iterator();
        while (iterator.hasNext()) {
            IManageablePage touchedPage = iterator.next();
            if (touchedPage.getPageId() != page.getPageId()) continue;
            iterator.remove();
            break;
        }
    }

    protected void commitRequest() {
        if (!this.touchedPages.isEmpty()) {
            ArrayList<IManageablePage> statefulPages = new ArrayList<IManageablePage>(this.touchedPages.size());
            for (IManageablePage page : this.touchedPages) {
                boolean isPageStateless;
                try {
                    page.detach();
                }
                catch (Exception e) {
                    log.error("Error detaching page", (Throwable)e);
                }
                try {
                    isPageStateless = page.isPageStateless();
                }
                catch (Exception x) {
                    log.warn("An error occurred while checking whether a page is stateless. Assuming it is stateful.", (Throwable)x);
                    isPageStateless = false;
                }
                if (isPageStateless) continue;
                statefulPages.add(page);
            }
            if (!statefulPages.isEmpty()) {
                this.storeTouchedPages(statefulPages);
            }
        }
    }
}

