/*
 * Decompiled with CFR 0.152.
 */
package com.wabit.uecs.protocol.handler;

import com.wabit.uecs.CcmService;
import com.wabit.uecs.IUecsNode;
import com.wabit.uecs.UecsRequest;
import com.wabit.uecs.UecsResponse;
import com.wabit.uecs.protocol.CcmScanCcm;
import com.wabit.uecs.protocol.CcmScanReplyCcm;
import com.wabit.uecs.protocol.NodeScanCcm;
import com.wabit.uecs.protocol.NodeScanReplyCcm;
import com.wabit.uecs.protocol.XmlCcm;
import com.wabit.uecs.protocol.handler.AbstractProtocolHandler;
import java.util.ArrayList;

public class ScanProtocolHandler
extends AbstractProtocolHandler {
    private static final int DIV_UNIT = 2;

    public ScanProtocolHandler(IUecsNode<?> node) {
        super(node);
    }

    @Override
    public int getPort() {
        return 16529;
    }

    @Override
    protected void handleCcm(UecsRequest req, UecsResponse res, XmlCcm ccm) throws Exception {
        if (ccm instanceof NodeScanCcm) {
            this.handleNodeScanCcm(req, res, (NodeScanCcm)ccm);
        } else if (ccm instanceof CcmScanCcm) {
            this.handleCcmScanCcm(req, res, (CcmScanCcm)ccm);
        } else {
            throw new Exception("illegal packet : " + ccm.toString());
        }
    }

    private void handleNodeScanCcm(UecsRequest req, UecsResponse res, NodeScanCcm ccm) {
        IUecsNode<?> node = this.getNode();
        NodeScanReplyCcm reply = new NodeScanReplyCcm();
        reply.setUecsVersion(node.getUecsVersion());
        reply.setUecsID(node.getUecsID());
        reply.setName(node.getName());
        reply.setVender(node.getVender());
        reply.setIpAddress(node.getIpAddress());
        reply.setMacAddress(node.getMacAddress());
        res.setAddress(req.getAddress());
        res.setPort(reply.getPort());
        res.setData(reply.toXmlBytes());
    }

    private void handleCcmScanCcm(UecsRequest req, UecsResponse res, CcmScanCcm rCcm) {
        IUecsNode<?> node = this.getNode();
        ArrayList<CcmService> defList = new ArrayList<CcmService>();
        for (CcmService ccmSv : node.listCcmService()) {
            if (ccmSv.getCcm() == null) continue;
            defList.add(ccmSv);
        }
        if (defList.size() == 0) {
            return;
        }
        int total = defList.size() / 2;
        if (defList.size() % 2 > 0) {
            ++total;
        }
        CcmScanReplyCcm reply = new CcmScanReplyCcm();
        reply.setUecsVersion(node.getUecsVersion());
        reply.setPage(rCcm.getPage());
        reply.setTotal(total);
        int start = (rCcm.getPage() - 1) * 2;
        int end = start + 2;
        int i = start;
        while (i < end) {
            if (i < defList.size()) {
                CcmService sv = (CcmService)defList.get(i);
                reply.putCcm(i, sv.getCcm());
            }
            ++i;
        }
        res.setAddress(req.getAddress());
        res.setPort(reply.getPort());
        res.setData(reply.toXmlBytes());
    }
}

