/*
 * Decompiled with CFR 0.152.
 */
package com.wabit.uecs.protocol.handler;

import com.wabit.uecs.IUecsNode;
import com.wabit.uecs.IUecsProtocolHandler;
import com.wabit.uecs.UecsRequest;
import com.wabit.uecs.UecsResponse;
import com.wabit.uecs.protocol.XmlCcm;
import com.wabit.uecs.protocol.XmlCcmParser;

public abstract class AbstractProtocolHandler
implements IUecsProtocolHandler {
    private IUecsNode<?> node;
    private XmlCcmParser ccmParser = new XmlCcmParser();

    public AbstractProtocolHandler(IUecsNode<?> node) {
        this.node = node;
    }

    public IUecsNode<?> getNode() {
        return this.node;
    }

    @Override
    public void handle(UecsRequest req, UecsResponse res) throws Exception {
        XmlCcm ccm = this.ccmParser.parseBytes(req.getData());
        ccm.setReceivedTime(req.getTime());
        this.handleCcm(req, res, ccm);
    }

    @Override
    public void handleException(UecsRequest req, UecsResponse res, Exception exception) {
        exception.printStackTrace();
    }

    protected abstract void handleCcm(UecsRequest var1, UecsResponse var2, XmlCcm var3) throws Exception;
}

