/*
 * Decompiled with CFR 0.152.
 */
package com.wabit.uecs.device;

import com.wabit.uecs.device.ComponentConfig;
import com.wabit.uecs.device.IComponent;
import com.wabit.uecs.device.IComponentListener;
import com.wabit.uecs.device.IDevice;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class AbstractComponent<T extends ComponentConfig>
implements IComponent<T> {
    private Set<IComponentListener> listeners = Collections.synchronizedSet(new HashSet());
    private String id;
    private Number value;
    private IDevice<?> device;
    private T config;

    public AbstractComponent(String id, T config) {
        this.id = id;
        this.config = config;
    }

    @Override
    public T getConfig() {
        return this.config;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Number getValue() {
        return this.value;
    }

    @Override
    public void setValue(Number value) {
        this.value = value;
        this.notifyUpdated();
    }

    @Override
    public IDevice<?> getDevice() {
        return this.device;
    }

    protected void setDevice(IDevice<?> device) {
        this.device = device;
    }

    @Override
    public void addListener(IComponentListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public List<IComponentListener> getListeners() {
        return new ArrayList<IComponentListener>(this.listeners);
    }

    @Override
    public boolean removeListener(IComponentListener listener) {
        return this.listeners.remove(listener);
    }

    @Override
    public void init(IDevice<?> device) throws Exception {
        try {
            this.setDevice(device);
            this.onInit();
        }
        catch (Exception e) {
            this.notifyException(e);
            throw e;
        }
    }

    @Override
    public void start() throws Exception {
        try {
            this.onStart();
            this.notifyStarted();
        }
        catch (Exception e) {
            this.notifyException(e);
            throw e;
        }
    }

    @Override
    public void stop() throws Exception {
        try {
            this.onStop();
            this.notifyStopped();
        }
        catch (Exception e) {
            this.notifyException(e);
            throw e;
        }
    }

    protected void notifyStarted() {
        for (IComponentListener listener : this.listeners) {
            listener.componentStarted(this);
        }
    }

    protected void notifyStopped() {
        for (IComponentListener listener : this.listeners) {
            listener.componentStopped(this);
        }
    }

    protected void notifyUpdated() {
        for (IComponentListener listener : this.listeners) {
            listener.componentValueUpdated(this);
        }
    }

    protected void notifyException(Exception e) {
        for (IComponentListener listener : this.listeners) {
            listener.handleComponentException(this, e);
        }
    }

    protected abstract void onInit() throws Exception;

    protected abstract void onStart() throws Exception;

    protected abstract void onStop() throws Exception;
}

