/*
 * Decompiled with CFR 0.152.
 */
package com.wabit.uecs;

import com.wabit.uecs.Ccm;
import com.wabit.uecs.ICcmServiceListener;
import com.wabit.uecs.IUecsNode;
import com.wabit.uecs.protocol.DataCcm;
import com.wabit.uecs.protocol.SearchCcm;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class CcmService {
    private Ccm rccm;
    private Ccm ccm;
    private long updateTime = Long.MIN_VALUE;
    private Set<ICcmServiceListener> listeners = Collections.synchronizedSet(new HashSet());
    private IUecsNode<?> node;
    private String name;
    private boolean isExpired = true;
    private boolean isEnable = true;

    public CcmService(Ccm value) {
        this.ccm = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean addListener(ICcmServiceListener listener) {
        return this.listeners.add(listener);
    }

    Set<ICcmServiceListener> getListeners() {
        return this.listeners;
    }

    public Ccm getAcceptCcm() {
        return this.rccm;
    }

    public Ccm getCcm() {
        return this.ccm;
    }

    public long getUpdateTime() {
        return this.updateTime;
    }

    public boolean isExpired() {
        return this.isExpired;
    }

    public boolean isEnable() {
        return this.isEnable;
    }

    public void setEnable(boolean isActive) {
        this.isEnable = isActive;
    }

    protected void onStart(IUecsNode<?> node) throws Exception {
    }

    protected void onStop(IUecsNode<?> node) throws Exception {
    }

    public boolean removeListener(ICcmServiceListener listener) {
        return this.listeners.remove(listener);
    }

    public void requestData() {
        if (this.node == null || this.ccm.getLevel() == null || this.ccm.getLevel().getCategory() != 'B' || this.ccm.getSide() != 'R') {
            return;
        }
        SearchCcm req = new SearchCcm();
        req.setUecsVersion(this.ccm.getUecsVersion());
        req.setType(this.ccm.getType());
        req.setRoom(this.ccm.getRoom());
        req.setRegion(this.ccm.getRegion());
        req.setOrder(this.ccm.getOrder());
        this.node.sendPacket(this.node.getBroadcastAddress(), req.getPort(), req.toXmlBytes());
    }

    public void setAcceptCcm(Ccm rccm) {
        this.rccm = rccm;
        this.updateValue(rccm.getStringValue());
        for (ICcmServiceListener l : this.listeners) {
            l.ccmReceived(this, this.ccm);
        }
    }

    void setNode(IUecsNode<?> node) {
        this.node = node;
    }

    public IUecsNode<?> getNode() {
        return this.node;
    }

    public void updateValue(Number value) {
        this.ccm.setValue(value);
        this.update();
    }

    public void updateValue(String value) {
        this.ccm.setValue(value);
        this.update();
    }

    public void setValue(long time, Number value) {
        this.ccm.setValue(value);
        this.updateTime = time;
        this.isExpired = System.currentTimeMillis() - time > this.ccm.getLevel().getAvailableTime();
    }

    private void update() {
        this.updateTime = System.currentTimeMillis();
        this.isExpired = false;
        if (this.ccm == null || this.ccm.getNumberValue() == null) {
            return;
        }
        if (this.node != null && this.node.isActive() && this.isEnable()) {
            if (this.ccm.getLevel() != null && this.ccm.getLevel().isAck() && this.ccm.getSide() == 'S') {
                DataCcm dccm = this.createDataCcm(this.ccm);
                this.node.sendPacket(this.node.getBroadcastAddress(), dccm.getPort(), dccm.toXmlBytes());
                for (ICcmServiceListener l : this.listeners) {
                    l.ccmSent(this, this.ccm);
                }
            }
            for (ICcmServiceListener l : this.listeners) {
                l.ccmValueChanged(this, this.ccm);
            }
        }
    }

    void checkExpiration() {
        if (!this.isExpired() && this.getAcceptCcm() != null && this.updateTime > Long.MIN_VALUE && System.currentTimeMillis() - this.updateTime > this.ccm.getLevel().getAvailableTime()) {
            this.isExpired = true;
            for (ICcmServiceListener l : this.listeners) {
                l.ccmExpired(this, this.ccm);
            }
        }
    }

    DataCcm createDataCcm(Ccm ccm) {
        DataCcm dccm = new DataCcm();
        dccm.setUecsVersion(ccm.getUecsVersion());
        dccm.setType(ccm.getType());
        dccm.setRoom(ccm.getRoom());
        dccm.setRegion(ccm.getRegion());
        dccm.setOrder(ccm.getOrder());
        dccm.setPriority(ccm.getPriority());
        dccm.setIpAddress(this.node.getIpAddress());
        dccm.setCast(ccm.getCast());
        dccm.setUnit(ccm.getUnit());
        dccm.setValue(ccm.getNumberValue());
        return dccm;
    }
}

