/*
 * Decompiled with CFR 0.152.
 */
package com.wabit.uecs;

public enum ActionMode {
    Autonomy(0),
    rcA(65536),
    WEB(131072),
    rcM(196608),
    Interlock(262144),
    Outage(327680),
    Standalone(393216);

    private int modeBits;

    private ActionMode(int val) {
        this.modeBits = val;
    }

    public int getBits() {
        return this.modeBits;
    }

    public static ActionMode getMode(int modeBits) {
        switch (modeBits) {
            case 0: {
                return Autonomy;
            }
            case 393216: {
                return Standalone;
            }
            case 65536: {
                return rcA;
            }
            case 196608: {
                return rcM;
            }
            case 262144: {
                return Interlock;
            }
            case 131072: {
                return WEB;
            }
            case 327680: {
                return Outage;
            }
        }
        return null;
    }

    public boolean isPrior(ActionMode mode) {
        if (Standalone == mode) {
            return true;
        }
        if (this == Standalone) {
            return false;
        }
        return this.getBits() >= mode.getBits();
    }
}

