/*
 * Decompiled with CFR 0.152.
 */
package jp.co.toyoct.uecs.v1;

import java.net.InetAddress;
import jp.co.toyoct.uecs.CcmType;
import jp.co.toyoct.uecs.protocol.DataCcm;
import jp.co.toyoct.uecs.protocol.XmlCcmParser;
import junit.framework.Assert;
import org.junit.Test;

public class DataCcmTest {
    @Test
    public void test() {
        try {
            DataCcm ccm1 = new DataCcm();
            ccm1.setType(new CcmType("SoilTemp.mIC"));
            ccm1.setRoom(5);
            ccm1.setRegion(4);
            ccm1.setOrder(3);
            ccm1.setPriority(2);
            ccm1.setIpAddress(InetAddress.getByName("127.0.0.1"));
            ccm1.setValue("0.001");
            String ccm1Xml = ccm1.toXml();
            System.out.println(ccm1Xml);
            XmlCcmParser ccmParser = new XmlCcmParser();
            DataCcm ccm2 = (DataCcm)ccmParser.parseBytes(ccm1.toXmlBytes());
            String ccm2Xml = ccm2.toXml();
            System.out.println(ccm2Xml);
            Assert.assertTrue((String)("source:" + ccm1Xml + ", copy:" + ccm2Xml), (boolean)ccm1Xml.equals(ccm2Xml));
        }
        catch (Throwable e) {
            e.printStackTrace();
            Assert.assertTrue((String)e.toString(), (boolean)false);
        }
    }

    @Test
    public void testInvalid() {
        try {
            String ccm1Xml = "<?xml version=\"1.0\"?><UECS><DATA type=\"InAirHumid\" room=\"1\" region=\"2\" order=\"0\" priority=\"10\">71</DATA></UECS><TEST></TEST>";
            System.out.println(ccm1Xml);
            XmlCcmParser ccmParser = new XmlCcmParser();
            DataCcm ccm2 = (DataCcm)ccmParser.parseXml(ccm1Xml);
            String ccm2Xml = ccm2.toXml();
            System.out.println(String.valueOf(ccm2Xml) + " ");
            Assert.assertTrue((String)("source:" + ccm1Xml + ", copy:" + ccm2Xml), (boolean)ccm1Xml.equals(ccm2Xml));
        }
        catch (Throwable e) {
            e.printStackTrace();
            Assert.assertTrue((String)e.toString(), (boolean)true);
        }
    }

    @Test
    public void testSAX() {
        try {
            String ccm1Xml = "<?xml version=\"1.0\"?><UECS><DATA type=\"InAirHumid\" room=\"1\" region=\"2\" order=\"0\" priority=\"10\">71</DATA></UECS>";
            System.out.println(ccm1Xml);
            XmlCcmParser saxParser = new XmlCcmParser();
            DataCcm ccm2 = (DataCcm)saxParser.parseXml(ccm1Xml);
            String ccm2Xml = ccm2.toXml();
            System.out.println(String.valueOf(ccm2Xml) + " ");
            Assert.assertTrue((String)("source:" + ccm1Xml + ", copy:" + ccm2Xml), (boolean)ccm1Xml.equals(ccm2Xml));
        }
        catch (Throwable e) {
            e.printStackTrace();
            Assert.assertTrue((String)e.toString(), (boolean)false);
        }
    }
}

