/*
 * Decompiled with CFR 0.152.
 */
package jp.co.toyoct.uecs.tester;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.swing.UIManager;
import jp.co.toyoct.uecs.tester.TesterConfig;
import jp.co.toyoct.uecs.tester.TesterNode;
import jp.co.toyoct.uecs.tester.gui.TesterGUI;

public class TesterRuntime {
    private static ResourceBundle rc;
    private static TesterNode node;
    private static Logger logger;

    static {
        logger = Logger.getLogger(TesterRuntime.class.getName());
        rc = ResourceBundle.getBundle("jp/co/toyoct/uecs/tester/ResourceBundle");
    }

    public static void main(String[] args) {
        TesterGUI gui;
        node = new TesterNode();
        try {
            String lafClassName = "javax.swing.plaf.metal.MetalLookAndFeel";
            UIManager.setLookAndFeel(lafClassName);
            gui = new TesterGUI();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        gui.setDefaultCloseOperation(3);
        gui.pack();
        gui.setVisible(true);
    }

    public static void init(TesterConfig config) {
        node.setup(config);
    }

    public static Logger getLogger() {
        return logger;
    }

    public static TesterNode getNode() {
        return node;
    }

    public static void startServices() {
        TesterRuntime.stopServices();
        node.start();
    }

    public static void stopServices() {
        node.stop();
    }

    public static final ResourceBundle getResourceBundle() {
        return rc;
    }

    public static final String getMessage(String key, Object ... params) {
        return MessageFormat.format(rc.getString(key), params);
    }
}

