/*
 * Decompiled with CFR 0.152.
 */
package jp.co.toyoct.uecs.protocol;

import java.net.InetAddress;
import jp.co.toyoct.uecs.CcmType;
import jp.co.toyoct.uecs.protocol.XmlCcm;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;

public class DataCcm
extends XmlCcm {
    public static final String TAG_DATA = "DATA";
    public static final String TAG_IP = "IP";
    private InetAddress ipAddress;
    private String value;

    @Override
    void appendXml(StringBuilder sb) {
        sb.append("<").append(TAG_DATA);
        if (this.getType() != null) {
            sb.append(" ").append("type").append("=\"").append(DataCcm.escape(this.getType())).append("\"");
        }
        if (this.getRoom() > -1) {
            sb.append(" ").append("room").append("=\"").append(this.getRoom()).append("\"");
        }
        if (this.getRegion() > -1) {
            sb.append(" ").append("region").append("=\"").append(this.getRegion()).append("\"");
        }
        if (this.getOrder() > -1) {
            sb.append(" ").append("order").append("=\"").append(this.getOrder()).append("\"");
        }
        if (this.getPriority() > -1) {
            sb.append(" ").append("priority").append("=\"").append(this.getPriority()).append("\"");
        }
        if (this.getStringValue() == null) {
            sb.append("/>");
        } else {
            sb.append(">");
            sb.append(this.getStringValue());
            sb.append("</").append(TAG_DATA).append(">");
        }
        if (this.getUecsVersion() != null) {
            sb.append("<").append(TAG_IP);
            if (this.ipAddress != null) {
                sb.append(">");
                sb.append(this.ipAddress.getHostAddress());
                sb.append("</").append(TAG_IP).append(">");
            } else {
                sb.append("/>");
            }
        }
    }

    public InetAddress getIpAddress() {
        return this.ipAddress;
    }

    @Override
    void importXml(Document doc) throws Exception {
        Element elm = (Element)doc.getElementsByTagName(TAG_DATA).item(0);
        String val = elm.getAttribute("type");
        if (val.length() != 0) {
            this.setType(new CcmType(val));
        }
        if ((val = elm.getAttribute("room")).length() != 0) {
            this.setRoom(Integer.parseInt(val));
        } else {
            this.setRoom(0);
        }
        val = elm.getAttribute("region");
        if (val.length() != 0) {
            this.setRegion(Integer.parseInt(val));
        } else {
            this.setRegion(0);
        }
        val = elm.getAttribute("order");
        if (val.length() != 0) {
            this.setOrder(Integer.parseInt(val));
        } else {
            this.setOrder(0);
        }
        val = elm.getAttribute("priority");
        if (val.length() != 0) {
            this.setPriority(Integer.parseInt(val));
        }
        if ((val = elm.getFirstChild().getNodeValue()) != null && val.length() != 0) {
            this.setValue(val);
        }
        if (doc.getElementsByTagName(TAG_IP).getLength() > 0 && (val = (elm = (Element)doc.getElementsByTagName(TAG_IP).item(0)).getFirstChild().getNodeValue()) != null && val.length() != 0) {
            this.setIpAddress(InetAddress.getByName(val));
        }
    }

    public void setIpAddress(InetAddress address) {
        this.ipAddress = address;
    }

    @Override
    public int getPort() {
        return 16520;
    }

    @Override
    public String getStringValue() {
        return this.value;
    }

    @Override
    public Number getNumberValue() {
        if (this.value == null) {
            return null;
        }
        return new Double(this.value);
    }

    @Override
    public void setValue(Number num) {
        super.setValue(num);
        this.value = super.getStringValue();
    }

    @Override
    public void setValue(String val) {
        this.value = val;
    }

    @Override
    void setXmlAttributes(String tagName, Attributes attributes) throws Exception {
        if (TAG_DATA.equals(tagName)) {
            String val = attributes.getValue("type");
            if (val.length() != 0) {
                this.setType(new CcmType(val));
            }
            if ((val = attributes.getValue("room")).length() != 0) {
                this.setRoom(Integer.parseInt(val));
            } else {
                this.setRoom(0);
            }
            val = attributes.getValue("region");
            if (val.length() != 0) {
                this.setRegion(Integer.parseInt(val));
            } else {
                this.setRegion(0);
            }
            val = attributes.getValue("order");
            if (val.length() != 0) {
                this.setOrder(Integer.parseInt(val));
            } else {
                this.setOrder(0);
            }
            val = attributes.getValue("priority");
            if (val.length() != 0) {
                this.setPriority(Integer.parseInt(val));
            }
        }
    }

    @Override
    void setXmlValue(String tagName, String value) throws Exception {
        if (TAG_DATA.equals(tagName)) {
            if (value != null && value.length() != 0) {
                this.setValue(value);
            }
        } else if (TAG_IP.equals(tagName) && value != null && value.length() != 0) {
            this.setIpAddress(InetAddress.getByName(value));
        }
    }
}

