/*
 * Decompiled with CFR 0.152.
 */
package jp.co.toyoct.uecs;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import jp.co.toyoct.uecs.AbstractUecsNode;
import jp.co.toyoct.uecs.CcmType;
import jp.co.toyoct.uecs.NodeConfig;
import jp.co.toyoct.uecs.protocol.SearchCcm;
import jp.co.toyoct.uecs.protocol.ServerCcm;
import jp.co.toyoct.uecs.protocol.XmlCcm;
import jp.co.toyoct.uecs.protocol.XmlCcmParser;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class UecsSearchServiceTest {
    private AbstractUecsNode node;
    private DatagramSocket sendSocket;
    private DatagramSocket dataSocket;
    private byte[] buffer = new byte[512];

    @Before
    public void setup() throws Exception {
        NodeConfig conf = new NodeConfig("conf/uecs-config.xml");
        this.sendSocket = new DatagramSocket();
        this.sendSocket.setReceiveBufferSize(512);
        this.dataSocket = new DatagramSocket(16526);
        this.node.start();
    }

    @After
    public void end() throws Exception {
        this.sendSocket.close();
        this.dataSocket.close();
        this.node.stop();
    }

    private XmlCcm receive() throws Exception {
        DatagramPacket rpacket = new DatagramPacket(this.buffer, this.buffer.length);
        this.dataSocket.receive(rpacket);
        int start = rpacket.getOffset();
        int len = rpacket.getLength();
        byte[] rdata = new byte[len];
        System.arraycopy(this.buffer, start, rdata, 0, len);
        XmlCcmParser ccmParser = new XmlCcmParser();
        return ccmParser.parseBytes(rdata);
    }

    @Test
    public void test1() throws Exception {
        SearchCcm search = new SearchCcm();
        search.setType(new CcmType("SoilTemp.mIC"));
        search.setRoom(3);
        search.setRegion(2);
        search.setOrder(1);
        System.out.println("send:" + search);
        byte[] sdata = search.toXmlBytes();
        DatagramPacket spacket = new DatagramPacket(sdata, sdata.length, this.node.getBroadcastAddress(), 16521);
        this.sendSocket.send(spacket);
        ServerCcm server = (ServerCcm)this.receive();
        System.out.println("receive:" + server);
        Assert.assertTrue((String)"compare", (boolean)true);
    }

    @Test
    public void test2() throws Exception {
        SearchCcm search = new SearchCcm();
        search.setType(new CcmType("SoilTemp.mIC"));
        search.setRoom(0);
        search.setRegion(0);
        search.setOrder(0);
        System.out.println("send:" + search);
        byte[] sdata = search.toXmlBytes();
        DatagramPacket spacket = new DatagramPacket(sdata, sdata.length, this.node.getBroadcastAddress(), 16521);
        this.sendSocket.send(spacket);
        ServerCcm server = (ServerCcm)this.receive();
        System.out.println("receive:" + server);
        Assert.assertTrue((String)"compare", (boolean)true);
    }
}

