/*
 * Decompiled with CFR 0.152.
 */
package jp.co.toyoct.uecs;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import jp.co.toyoct.uecs.AbstractUecsNode;
import jp.co.toyoct.uecs.NodeConfig;
import jp.co.toyoct.uecs.protocol.CcmScanCcm;
import jp.co.toyoct.uecs.protocol.CcmScanReplyCcm;
import jp.co.toyoct.uecs.protocol.NodeScanCcm;
import jp.co.toyoct.uecs.protocol.NodeScanReplyCcm;
import jp.co.toyoct.uecs.protocol.XmlCcm;
import jp.co.toyoct.uecs.protocol.XmlCcmParser;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class UecsScanServiceTest {
    private AbstractUecsNode node;
    private DatagramSocket sendSocket;
    private DatagramSocket dataSocket;
    private byte[] buffer = new byte[512];

    @Before
    public void setup() throws Exception {
        NodeConfig conf = new NodeConfig("conf/uecs-config.xml");
        this.sendSocket = new DatagramSocket();
        this.sendSocket.setReceiveBufferSize(512);
        this.dataSocket = new DatagramSocket(16534);
        this.node.start();
    }

    @After
    public void end() throws Exception {
        this.sendSocket.close();
        this.dataSocket.close();
        this.node.stop();
    }

    private XmlCcm receive() throws Exception {
        DatagramPacket rpacket = new DatagramPacket(this.buffer, this.buffer.length);
        this.dataSocket.receive(rpacket);
        int start = rpacket.getOffset();
        int len = rpacket.getLength();
        byte[] rdata = new byte[len];
        System.arraycopy(this.buffer, start, rdata, 0, len);
        XmlCcmParser ccmParser = new XmlCcmParser();
        return ccmParser.parseBytes(rdata);
    }

    @Test
    public void testNodeScan() throws Exception {
        NodeScanCcm ccm = new NodeScanCcm();
        System.out.println("send:" + ccm);
        byte[] sdata = ccm.toXmlBytes();
        DatagramPacket spacket = new DatagramPacket(sdata, sdata.length, this.node.getIpAddress(), 16529);
        this.sendSocket.send(spacket);
        NodeScanReplyCcm reply = (NodeScanReplyCcm)this.receive();
        System.out.println("receive:" + reply);
        Assert.assertTrue((String)"compare", (boolean)true);
    }

    @Test
    public void testScan() throws Exception {
        CcmScanCcm ccm = new CcmScanCcm();
        ccm.setPage(1);
        System.out.println("send:" + ccm);
        byte[] sdata = ccm.toXmlBytes();
        DatagramPacket spacket = new DatagramPacket(sdata, sdata.length, this.node.getIpAddress(), 16529);
        this.sendSocket.send(spacket);
        CcmScanReplyCcm reply = (CcmScanReplyCcm)this.receive();
        System.out.println("receive:" + reply);
        Assert.assertTrue((String)"compare", (boolean)true);
    }
}

