/*
 * Decompiled with CFR 0.152.
 */
package jp.co.toyoct.uecs;

import jp.co.toyoct.uecs.NodeRuntimeException;

public class CcmLevel {
    public static final CcmLevel A_1S_0 = new CcmLevel("A-1S-0");
    public static final CcmLevel A_1S_1 = new CcmLevel("A-1S-1");
    public static final CcmLevel A_10S_0 = new CcmLevel("A-10S-0");
    public static final CcmLevel A_10S_1 = new CcmLevel("A-10S-1");
    public static final CcmLevel A_1M_0 = new CcmLevel("A-1M-0");
    public static final CcmLevel A_1M_1 = new CcmLevel("A-1M-1");
    public static final CcmLevel B_0 = new CcmLevel("B-0");
    public static final CcmLevel B_1 = new CcmLevel("B-1");
    public static final CcmLevel S_1S_0 = new CcmLevel("S-1S-0");
    public static final CcmLevel S_1M_0 = new CcmLevel("S-1M-0");
    private String code;
    private char category;
    private long cycleTime;
    private long availableTime;
    private boolean isAck;

    public CcmLevel(String code) throws NodeRuntimeException {
        this.code = code;
        try {
            this.parseCode(code);
        }
        catch (Throwable t) {
            throw new NodeRuntimeException("LV spec violation : " + code);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof CcmLevel) {
            return ((CcmLevel)o).code.equals(this.code);
        }
        return false;
    }

    public long getAvailableTime() {
        return this.availableTime;
    }

    public char getCategory() {
        return this.category;
    }

    public long getCycleTime() {
        return this.cycleTime;
    }

    public int hashCode() {
        return this.code.hashCode();
    }

    public boolean isAck() {
        return this.isAck;
    }

    private void parseCode(String code) {
        String[] vals = code.split("-");
        if (vals.length > 1 && vals[0].length() == 1) {
            this.category = vals[0].charAt(0);
            if (vals[1].endsWith("S")) {
                this.cycleTime = (long)Integer.parseInt(vals[1].substring(0, vals[1].length() - 1)) * 1000L;
            } else if (vals[1].endsWith("M")) {
                this.cycleTime = (long)Integer.parseInt(vals[1].substring(0, vals[1].length() - 1)) * 60L * 1000L;
            }
            this.availableTime = this.cycleTime * 3L;
        }
        this.isAck = "1".equals(vals[vals.length - 1]);
    }

    public String toString() {
        return this.code;
    }
}

