/*
 * Decompiled with CFR 0.152.
 */
package jp.co.toyoct.uecs;

import java.text.DecimalFormat;
import jp.co.toyoct.uecs.CcmLevel;
import jp.co.toyoct.uecs.CcmType;
import jp.co.toyoct.uecs.NodeRuntimeException;

public class Ccm {
    private String uecsVersion = "1.00-E10";
    private CcmType type;
    private int room = -1;
    private int region = -1;
    private int order = -1;
    private int priority = -1;
    private char side;
    private CcmLevel level;
    private String unit = "";
    private Number value;
    private int cast = 0;
    private String format = "#0";

    public int getCast() {
        return this.cast;
    }

    public CcmLevel getLevel() {
        return this.level;
    }

    public int getOrder() {
        return this.order;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getRegion() {
        return this.region;
    }

    public int getRoom() {
        return this.room;
    }

    public char getSide() {
        return this.side;
    }

    public CcmType getType() {
        return this.type;
    }

    public String getUecsVersion() {
        return this.uecsVersion;
    }

    public String getUnit() {
        return this.unit;
    }

    public Number getNumberValue() {
        return this.value;
    }

    public String getStringValue() {
        if (this.value == null) {
            return "";
        }
        return new DecimalFormat(this.format).format(this.value);
    }

    public String getFormat() {
        return this.format;
    }

    public void setCast(int cast) {
        if (cast <= 0) {
            this.format = "#0";
        } else {
            StringBuilder sb = new StringBuilder("#0.");
            int i = 0;
            while (i < cast) {
                sb.append('0');
                ++i;
            }
            this.format = sb.toString();
        }
        this.cast = cast;
    }

    public void setLevel(CcmLevel level) {
        this.level = level;
        if (level != null && level.getCategory() == 'B') {
            this.setPriority(30);
        }
    }

    public void setOrder(int order) {
        if (order < 0 || order > 30000) {
            throw new NodeRuntimeException("order(0 to 30000) : " + order);
        }
        this.order = order;
    }

    public void setPriority(int priority) {
        if (priority < 0 || priority > 30) {
            throw new NodeRuntimeException("priority(0 to 30) : " + priority);
        }
        this.priority = priority;
    }

    public void setRegion(int region) {
        if (region < 0 || region > 127) {
            throw new NodeRuntimeException("region(0 to 127) : " + region);
        }
        this.region = region;
    }

    public void setRoom(int room) {
        if (room < 0 || room > 127) {
            throw new NodeRuntimeException("room(0 to 127) : " + room);
        }
        this.room = room;
    }

    public void setSide(char side) {
        if (side != 'S' && side != 'R') {
            throw new NodeRuntimeException("side (S or R) : " + side);
        }
        this.side = side;
    }

    public void setType(CcmType type) {
        this.type = type;
    }

    public void setUecsVersion(String uecsVersion) {
        this.uecsVersion = uecsVersion;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    protected void setValue(Number number) {
        this.value = number;
    }

    protected void setValue(String value) {
        try {
            this.value = new DecimalFormat(this.format).parse(value);
        }
        catch (Throwable t) {
            throw new NodeRuntimeException("value format error. format=" + this.format + ", value=" + value, t);
        }
    }
}

