/*
 * Decompiled with CFR 0.152.
 */
package jp.co.toyoct.uecs.tester.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import jp.co.toyoct.uecs.NodeConfig;
import jp.co.toyoct.uecs.tester.TesterConfig;
import jp.co.toyoct.uecs.tester.TesterNode;
import jp.co.toyoct.uecs.tester.TesterRuntime;
import jp.co.toyoct.uecs.tester.gui.CcmCapturePane;
import jp.co.toyoct.uecs.tester.gui.NodeCtrlPane;
import jp.co.toyoct.uecs.tester.gui.NodeScanPane;
import jp.co.toyoct.uecs.tester.gui.NodeSettingPane;

public class TesterGUI
extends JFrame {
    private static final long serialVersionUID = 1L;
    private ResourceBundle rc = TesterRuntime.getResourceBundle();
    private JTabbedPane tabbedPane;
    private NodeCtrlPane ctrlPane;
    private URL cosmotecLogoUrl = this.getClass().getClassLoader().getResource("image/cosmo.png");
    private URL uecsLogoUrl = this.getClass().getClassLoader().getResource("image/uecs.png");
    private ImageIcon cosmotecLogo = new ImageIcon(this.cosmotecLogoUrl);
    private ImageIcon uecsLogo = new ImageIcon(this.uecsLogoUrl);

    public TesterGUI() {
        this.setTitle(String.valueOf(this.rc.getString("title.window")) + " (" + this.rc.getString("version") + ")");
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu(this.rc.getString("menu.file"));
        menuBar.add(fileMenu);
        JMenuItem loadItm = new JMenuItem(this.rc.getString("menu.file.load"));
        fileMenu.add(loadItm);
        loadItm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JFileChooser chooser = new JFileChooser();
                FileNameExtensionFilter filter = new FileNameExtensionFilter("XML config files.", "xml");
                chooser.setFileFilter(filter);
                int returnVal = chooser.showOpenDialog(TesterGUI.this);
                if (returnVal == 0) {
                    TesterGUI.this.loadConfigFile(chooser.getSelectedFile());
                }
            }
        });
        JMenuItem saveItm = new JMenuItem(this.rc.getString("menu.file.save"));
        fileMenu.add(saveItm);
        saveItm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JFileChooser chooser = new JFileChooser();
                FileNameExtensionFilter filter = new FileNameExtensionFilter("XML config files.", "xml");
                chooser.setFileFilter(filter);
                int returnVal = chooser.showSaveDialog(TesterGUI.this);
                if (returnVal == 0) {
                    TesterGUI.this.saveConfigFile(chooser.getSelectedFile());
                }
            }
        });
        JMenuItem exitItm = new JMenuItem(this.rc.getString("menu.file.exit"));
        fileMenu.add(exitItm);
        exitItm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TesterGUI.this.dispose();
            }
        });
        JMenu helpMenu = new JMenu(this.rc.getString("menu.help"));
        menuBar.add(helpMenu);
        JMenuItem uecsItm = new JMenuItem(this.rc.getString("menu.help.uecs"));
        helpMenu.add(uecsItm);
        uecsItm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JOptionPane.showMessageDialog(TesterGUI.this, TesterGUI.this.rc.getString("trademark"), TesterGUI.this.rc.getString("menu.help.uecs"), 1, TesterGUI.this.uecsLogo);
            }
        });
        JMenuItem aboutItm = new JMenuItem(this.rc.getString("menu.help.about"));
        helpMenu.add(aboutItm);
        aboutItm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JOptionPane.showMessageDialog(TesterGUI.this, TesterGUI.this.rc.getString("copyright"), TesterGUI.this.rc.getString("menu.help.about"), 1, TesterGUI.this.cosmotecLogo);
            }
        });
        this.setJMenuBar(menuBar);
        Container main = this.getContentPane();
        main.setLayout(new BorderLayout());
        JPanel centerPane = new JPanel();
        centerPane.setLayout(new BoxLayout(centerPane, 3));
        TesterNode node = TesterRuntime.getNode();
        this.ctrlPane = new NodeCtrlPane(node);
        centerPane.add(this.ctrlPane);
        this.tabbedPane = new JTabbedPane();
        centerPane.add(this.tabbedPane);
        this.tabbedPane.addTab(this.rc.getString("title.node_config"), new NodeSettingPane(node));
        this.tabbedPane.addTab(this.rc.getString("title.node_scan"), new NodeScanPane(node));
        this.tabbedPane.addTab(this.rc.getString("title.ccm_capture"), new CcmCapturePane(node));
        main.add((Component)centerPane, "Center");
    }

    private void loadConfigFile(File configFile) {
        try {
            TesterConfig conf = new TesterConfig(configFile.getPath());
            TesterRuntime.stopServices();
            TesterRuntime.init(conf);
        }
        catch (IOException e) {
            TesterRuntime.getLogger().log(Level.WARNING, "load error.", e);
        }
    }

    private void saveConfigFile(File savePath) {
        block12: {
            FileOutputStream out = null;
            try {
                try {
                    NodeConfig conf = TesterConfig.newInstance(TesterRuntime.getNode());
                    out = new FileOutputStream(savePath);
                    conf.storeToXML(out, null);
                }
                catch (IOException e) {
                    TesterRuntime.getLogger().log(Level.WARNING, "save error.", e);
                    if (out == null) break block12;
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

