/*
 * Decompiled with CFR 0.152.
 */
package jp.co.toyoct.uecs.tester.gui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;
import jp.co.toyoct.uecs.AbstractUecsNode;
import jp.co.toyoct.uecs.Ccm;
import jp.co.toyoct.uecs.CcmLevel;
import jp.co.toyoct.uecs.CcmService;
import jp.co.toyoct.uecs.CcmType;
import jp.co.toyoct.uecs.ICcmServiceListener;
import jp.co.toyoct.uecs.tester.TesterCcmService;
import jp.co.toyoct.uecs.tester.TesterNode;
import jp.co.toyoct.uecs.tester.TesterRuntime;
import jp.co.toyoct.uecs.tester.TesterUtil;
import jp.co.toyoct.uecs.tester.gui.BasePane;
import jp.co.toyoct.uecs.tester.gui.LogPane;

public class NodeSettingPane
extends BasePane {
    private static final long serialVersionUID = 1L;
    private static final String[] NODE_KEYS = new String[]{"node.uecs_version", "node.name", "node.ip", "node.broadcast"};
    private static final String[] CCM_KEYS = new String[]{"ccm.no", "ccm.version", "ccm.type", "ccm.room", "ccm.region", "ccm.order", "ccm.priority", "ccm.level", "ccm.side", "ccm.cast", "ccm.unit", "ccm.dummy_values", "ccm.dummy_interval", "ccm.value", "ccm.enable"};
    private ResourceBundle resource = TesterRuntime.getResourceBundle();
    private JTable nodeTable;
    private JTable ccmTable;
    private NodeInfoTableModel nodeTableModel;
    private CcmTableModel ccmTableModel;

    public NodeSettingPane(TesterNode node) {
        super(node);
        this.removeAll();
        this.setPreferredSize(new Dimension(1000, 600));
        this.setLayout(new BoxLayout(this, 3));
        this.nodeTableModel = new NodeInfoTableModel();
        this.nodeTable = new JTable(this.nodeTableModel);
        TableColumnModel columModel = this.nodeTable.getColumnModel();
        int i = 0;
        while (i < NODE_KEYS.length) {
            columModel.getColumn(i).setHeaderValue(TesterRuntime.getResourceBundle().getString(NODE_KEYS[i]));
            ++i;
        }
        JScrollPane scrollPane = new JScrollPane(this.nodeTable);
        scrollPane.setAlignmentX(0.5f);
        scrollPane.setPreferredSize(new Dimension(600, 100));
        scrollPane.setBorder(new TitledBorder(this.resource.getString("title.node_config")));
        this.add(scrollPane);
        this.ccmTableModel = new CcmTableModel();
        this.ccmTable = new CcmTable(this.ccmTableModel);
        columModel = this.ccmTable.getColumnModel();
        int i2 = 0;
        while (i2 < CCM_KEYS.length) {
            columModel.getColumn(i2).setHeaderValue(this.resource.getString(CCM_KEYS[i2]));
            ++i2;
        }
        columModel.getColumn(0).setMaxWidth(30);
        columModel.getColumn(1).setMaxWidth(80);
        columModel.getColumn(2).setMinWidth(90);
        columModel.getColumn(3).setMaxWidth(55);
        columModel.getColumn(4).setMaxWidth(55);
        columModel.getColumn(5).setMaxWidth(55);
        columModel.getColumn(6).setMaxWidth(55);
        columModel.getColumn(7).setMaxWidth(75);
        columModel.getColumn(8).setMaxWidth(45);
        columModel.getColumn(9).setMaxWidth(45);
        columModel.getColumn(10).setMaxWidth(45);
        columModel.getColumn(11).setMinWidth(100);
        columModel.getColumn(13).setMinWidth(100);
        columModel.getColumn(14).setMaxWidth(35);
        DefaultTableCellRenderer rightRenderor = new DefaultTableCellRenderer();
        rightRenderor.setHorizontalAlignment(4);
        columModel.getColumn(0).setCellRenderer(rightRenderor);
        columModel.getColumn(3).setCellRenderer(rightRenderor);
        columModel.getColumn(4).setCellRenderer(rightRenderor);
        columModel.getColumn(5).setCellRenderer(rightRenderor);
        columModel.getColumn(6).setCellRenderer(rightRenderor);
        columModel.getColumn(9).setCellRenderer(rightRenderor);
        columModel.getColumn(12).setCellRenderer(rightRenderor);
        columModel.getColumn(13).setCellRenderer(rightRenderor);
        DefaultTableCellRenderer centerRenderor = new DefaultTableCellRenderer();
        centerRenderor.setHorizontalAlignment(0);
        columModel.getColumn(8).setCellRenderer(centerRenderor);
        columModel.getColumn(10).setCellRenderer(centerRenderor);
        JScrollPane ccmScrollPane = new JScrollPane(this.ccmTable);
        ccmScrollPane.setAlignmentX(0.5f);
        ccmScrollPane.setBorder(new TitledBorder(this.resource.getString("title.ccm_config")));
        this.add(ccmScrollPane);
        LogPane logPane = new LogPane(this.getNode());
        logPane.setPreferredSize(new Dimension(600, 250));
        logPane.setBorder(new TitledBorder(this.resource.getString("title.log")));
        this.add(logPane);
    }

    @Override
    public void nodeSetup(TesterNode node) {
        this.nodeTableModel.fireTableDataChanged();
        this.ccmTableModel.fireTableDataChanged();
        for (CcmService ccm : node.listCcmService()) {
            ccm.addListener(this.ccmTableModel);
        }
    }

    private class CcmTable
    extends JTable {
        private static final long serialVersionUID = 1L;

        public CcmTable(CcmTableModel model) {
            super(model);
            InputMap im = this.getInputMap(0);
            KeyStroke key = KeyStroke.getKeyStroke(127, 0);
            DelAction action = new DelAction();
            im.put(key, action);
            ActionMap am = this.getActionMap();
            am.put(action, action);
        }
    }

    private class CcmTableModel
    extends AbstractTableModel
    implements ICcmServiceListener {
        private static final long serialVersionUID = 1L;

        @Override
        public int getColumnCount() {
            return CCM_KEYS.length;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            TesterNode node = TesterRuntime.getNode();
            if (node.isActive()) {
                return false;
            }
            if (col == 0 || col == 13) {
                return false;
            }
            CcmService sv = node.getCcmService(row);
            if (sv != null) {
                if (col == 11) {
                    return sv.getCcm().getSide() == 'S';
                }
                if (col == 12) {
                    return sv.getCcm().getSide() == 'S' || sv.getCcm().getLevel().getCategory() == 'B';
                }
            }
            return sv != null || col != 14;
        }

        @Override
        public void valueChanged(CcmService source, Ccm value) {
            int index = TesterRuntime.getNode().getCcmIndex(source);
            if (index > -1) {
                this.fireTableCellUpdated(index, 13);
            }
        }

        @Override
        public void expired(CcmService source, Ccm value) {
        }

        @Override
        public int getRowCount() {
            return TesterRuntime.getNode().countCcm() + 1;
        }

        @Override
        public Class<?> getColumnClass(int col) {
            if (col == 14) {
                return Boolean.class;
            }
            return super.getColumnClass(col);
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 0) {
                return row;
            }
            TesterNode node = TesterRuntime.getNode();
            TesterCcmService ccmsv = (TesterCcmService)node.getCcmService(row);
            if (ccmsv == null) {
                return null;
            }
            Ccm ccm = ccmsv.getCcm();
            switch (col) {
                case 1: {
                    return ccm.getUecsVersion();
                }
                case 2: {
                    return ccm.getType();
                }
                case 3: {
                    return ccm.getRoom();
                }
                case 4: {
                    return ccm.getRegion();
                }
                case 5: {
                    return ccm.getOrder();
                }
                case 6: {
                    return ccm.getPriority();
                }
                case 7: {
                    return ccm.getLevel();
                }
                case 8: {
                    return Character.valueOf(ccm.getSide());
                }
                case 9: {
                    return ccm.getCast();
                }
                case 10: {
                    return ccm.getUnit();
                }
                case 11: {
                    return TesterUtil.toCsv(ccmsv.getDummyValues());
                }
                case 12: {
                    return ccmsv.getInterval() > 0 ? Integer.valueOf(ccmsv.getInterval()) : "";
                }
                case 13: {
                    if (ccmsv.getUpdateTime() > Long.MIN_VALUE) {
                        SimpleDateFormat fmt = new SimpleDateFormat(NodeSettingPane.this.resource.getString("format.time"));
                        return String.valueOf(ccm.getStringValue()) + ccm.getUnit() + "[" + fmt.format(new Date(ccmsv.getUpdateTime())) + "]";
                    }
                    return "";
                }
                case 14: {
                    return new Boolean(ccmsv.isEnable());
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
            TesterNode node = TesterRuntime.getNode();
            TesterCcmService ccmsv = (TesterCcmService)node.getCcmService(row);
            Ccm ccm = null;
            if (ccmsv == null) {
                ccm = new Ccm();
                ccm.setUecsVersion(node.getUecsVersion());
                ccm.setType(new CcmType("xxx.xXX"));
                ccm.setRoom(0);
                ccm.setRegion(0);
                ccm.setOrder(0);
                ccm.setPriority(0);
                ccm.setLevel(new CcmLevel("A-10S-0"));
                ccm.setSide('R');
                ccmsv = new TesterCcmService(ccm);
                node.addCcmService(ccmsv);
                ccmsv.addListener(this);
            }
            ccm = ccmsv.getCcm();
            String val = aValue.toString();
            try {
                switch (col) {
                    case 1: {
                        ccm.setUecsVersion(val);
                        break;
                    }
                    case 2: {
                        ccm.setType(new CcmType(val));
                        break;
                    }
                    case 3: {
                        ccm.setRoom(Integer.parseInt(val));
                        break;
                    }
                    case 4: {
                        ccm.setRegion(Integer.parseInt(val));
                        break;
                    }
                    case 5: {
                        ccm.setOrder(Integer.parseInt(val));
                        break;
                    }
                    case 6: {
                        ccm.setPriority(Integer.parseInt(val));
                        break;
                    }
                    case 7: {
                        ccm.setLevel(new CcmLevel(val));
                        break;
                    }
                    case 8: {
                        ccm.setSide(val.charAt(0));
                        if (val.charAt(0) == 'R') {
                            ccmsv.setDummyValues(null);
                            if (ccm.getLevel().getCategory() != 'B') {
                                ccmsv.setInterval(0);
                            }
                        }
                        break;
                    }
                    case 9: {
                        ccm.setCast(Integer.parseInt(val));
                        break;
                    }
                    case 10: {
                        ccm.setUnit(val);
                        break;
                    }
                    case 11: {
                        ccmsv.setDummyValues(TesterUtil.toArray(val));
                        break;
                    }
                    case 12: {
                        ccmsv.setInterval(Integer.parseInt(val));
                        break;
                    }
                    case 14: {
                        ccmsv.setEnable(new Boolean(val));
                    }
                }
            }
            catch (Throwable t) {
                TesterRuntime.getLogger().log(Level.FINE, "setting error.", t);
            }
        }
    }

    public class DelAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public DelAction() {
            super("table-row-del");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TesterNode node = TesterRuntime.getNode();
            if (node.isActive()) {
                return;
            }
            JTable table = (JTable)e.getSource();
            int[] rs = table.getSelectedRows();
            int i = 0;
            while (i < rs.length) {
                rs[i] = table.convertRowIndexToModel(rs[i]);
                ++i;
            }
            Arrays.sort(rs);
            i = rs.length - 1;
            while (i >= 0) {
                node.removeCcmService(rs[i]);
                --i;
            }
            NodeSettingPane.this.ccmTableModel.fireTableDataChanged();
        }
    }

    private class NodeInfoTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        @Override
        public int getColumnCount() {
            return NODE_KEYS.length;
        }

        @Override
        public int getRowCount() {
            return 1;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return !TesterRuntime.getNode().isActive();
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (row != 0) {
                return null;
            }
            TesterNode node = TesterRuntime.getNode();
            switch (col) {
                case 0: {
                    return node.getUecsVersion();
                }
                case 1: {
                    return ((AbstractUecsNode)node).getName();
                }
                case 2: {
                    return node.getIpAddress().getHostAddress();
                }
                case 3: {
                    return node.getBroadcastAddress().getHostAddress();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
            if (row != 0) {
                return;
            }
            TesterNode node = TesterRuntime.getNode();
            String val = aValue.toString();
            switch (col) {
                case 0: {
                    node.setUecsVersion(val);
                    break;
                }
                case 1: {
                    node.setName(val);
                    break;
                }
                case 2: {
                    try {
                        node.setIpAddress(InetAddress.getByName(val));
                    }
                    catch (UnknownHostException e) {
                        node.setIpAddress(null);
                    }
                    break;
                }
                case 3: {
                    try {
                        node.setBroadcastAddress(InetAddress.getByName(val));
                        break;
                    }
                    catch (UnknownHostException e) {
                        node.setBroadcastAddress(null);
                    }
                }
            }
        }
    }
}

