/*
 * Decompiled with CFR 0.152.
 */
package jp.co.toyoct.uecs.tester.gui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;
import jp.co.toyoct.uecs.AbstractUecsNode;
import jp.co.toyoct.uecs.Ccm;
import jp.co.toyoct.uecs.CcmLevel;
import jp.co.toyoct.uecs.CcmType;
import jp.co.toyoct.uecs.CommonUtils;
import jp.co.toyoct.uecs.protocol.CcmScanCcm;
import jp.co.toyoct.uecs.protocol.CcmScanReplyCcm;
import jp.co.toyoct.uecs.protocol.NodeScanCcm;
import jp.co.toyoct.uecs.protocol.NodeScanReplyCcm;
import jp.co.toyoct.uecs.protocol.XmlCcm;
import jp.co.toyoct.uecs.tester.INodeListener;
import jp.co.toyoct.uecs.tester.TesterNode;
import jp.co.toyoct.uecs.tester.TesterRuntime;
import jp.co.toyoct.uecs.tester.TesterUtil;
import jp.co.toyoct.uecs.tester.gui.BasePane;

public class NodeScanPane
extends BasePane
implements TreeWillExpandListener,
INodeListener {
    private static final long serialVersionUID = 1L;
    private ResourceBundle resource = TesterRuntime.getResourceBundle();
    private JTree nodeTree;
    private DefaultMutableTreeNode rootNode;
    private JButton btnScan;

    public NodeScanPane(TesterNode node) {
        super(node);
        this.removeAll();
        this.setLayout(new BoxLayout(this, 3));
        this.rootNode = new DefaultMutableTreeNode(this.resource.getString("title.node_list"), true);
        this.nodeTree = new JTree(this.rootNode);
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        URL url = this.getClass().getClassLoader().getResource("image/ball.png");
        ImageIcon icon = new ImageIcon(url);
        renderer.setLeafIcon(icon);
        this.nodeTree.setCellRenderer(renderer);
        this.nodeTree.addTreeWillExpandListener(this);
        JScrollPane scrollPane = new JScrollPane(this.nodeTree);
        scrollPane.setAlignmentX(0.5f);
        scrollPane.setPreferredSize(new Dimension(600, 500));
        this.add(scrollPane);
        JPanel btnPane = new JPanel();
        btnPane.setLayout(new BoxLayout(btnPane, 2));
        this.btnScan = new JButton(this.resource.getString("btn.scan"));
        this.btnScan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NodeScanPane.this.rootNode.removeAllChildren();
                TesterNode node = TesterRuntime.getNode();
                NodeScanCcm ccm = new NodeScanCcm();
                ccm.setUecsVersion(node.getUecsVersion());
                ((AbstractUecsNode)node).sendPacket(node.getBroadcastAddress(), ccm.getPort(), ccm.toXmlBytes());
            }
        });
        this.btnScan.setSize(120, 20);
        this.btnScan.setAlignmentX(0.5f);
        this.btnScan.setEnabled(false);
        btnPane.add(this.btnScan);
        this.add(btnPane);
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
        TreePath path;
        if (TesterRuntime.getNode().isActive() && (path = event.getPath()).getPath().length == 2) {
            String ip = path.getPath()[1].toString();
            CcmScanCcm scan = new CcmScanCcm();
            scan.setUecsVersion(TesterRuntime.getNode().getUecsVersion());
            TesterNode node = TesterRuntime.getNode();
            try {
                ((AbstractUecsNode)node).sendPacket(InetAddress.getByName(ip), scan.getPort(), scan.toXmlBytes());
            }
            catch (UnknownHostException e) {
                TesterRuntime.getLogger().log(Level.WARNING, "ccm scan error.", e);
            }
        }
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent arg0) throws ExpandVetoException {
    }

    @Override
    public void receiveCcm(TesterNode node, InetAddress from, XmlCcm ccm) {
        if (ccm instanceof NodeScanReplyCcm) {
            this.receiveNodeScanReply((NodeScanReplyCcm)ccm, from);
        } else if (ccm instanceof CcmScanReplyCcm) {
            this.receiveCcmScanReply((CcmScanReplyCcm)ccm, from);
        }
    }

    @Override
    public void nodeStarted(TesterNode node) {
        this.btnScan.setEnabled(true);
    }

    @Override
    public void nodeStopped(TesterNode node) {
        this.btnScan.setEnabled(false);
    }

    private synchronized void receiveNodeScanReply(NodeScanReplyCcm nodeReply, InetAddress address) {
        try {
            String ip = nodeReply.getIpAddress().getHostAddress();
            String mac = "";
            if (nodeReply.getMacAddress() != null && nodeReply.getMacAddress().length > 0) {
                mac = CommonUtils.bytesToHex(nodeReply.getMacAddress());
            }
            String name = nodeReply.getName();
            String uecsId = nodeReply.getUecsID();
            String vender = nodeReply.getVender();
            String version = nodeReply.getUecsVersion();
            DefaultMutableTreeNode child = null;
            int index = 0;
            index = 0;
            while (index < this.rootNode.getChildCount()) {
                child = (DefaultMutableTreeNode)this.rootNode.getChildAt(index);
                String ip1 = child.getUserObject().toString();
                int compare = TesterUtil.compareIP(ip1, ip);
                if (compare >= 0) {
                    if (compare > 0) {
                        child = null;
                        break;
                    }
                    child.removeAllChildren();
                    break;
                }
                child = null;
                ++index;
            }
            if (child == null) {
                child = new DefaultMutableTreeNode(ip);
                this.rootNode.insert(child, index);
            }
            child.add(new DefaultMutableTreeNode(String.valueOf(TesterRuntime.getResourceBundle().getString("node.uecs_version")) + " : " + version, false));
            child.add(new DefaultMutableTreeNode(String.valueOf(TesterRuntime.getResourceBundle().getString("node.name")) + " : " + name, false));
            child.add(new DefaultMutableTreeNode(String.valueOf(TesterRuntime.getResourceBundle().getString("node.mac")) + " : " + mac, false));
            child.add(new DefaultMutableTreeNode(String.valueOf(TesterRuntime.getResourceBundle().getString("node.uecs_id")) + " : " + uecsId, false));
            child.add(new DefaultMutableTreeNode(String.valueOf(TesterRuntime.getResourceBundle().getString("node.vender")) + " : " + vender, false));
            child.add(new DefaultMutableTreeNode("CCM", true));
            ((DefaultTreeModel)this.nodeTree.getModel()).reload();
        }
        catch (Exception e) {
            TesterRuntime.getLogger().log(Level.WARNING, "illegal data : " + nodeReply, e);
        }
    }

    private synchronized void receiveCcmScanReply(CcmScanReplyCcm ccmReply, InetAddress address) {
        try {
            String ip = address.getHostAddress();
            int i = 0;
            while (i < this.rootNode.getChildCount()) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)this.rootNode.getChildAt(i);
                if (child.getUserObject().equals(ip)) {
                    DefaultMutableTreeNode ccmListNode = (DefaultMutableTreeNode)child.getChildAt(child.getChildCount() - 1);
                    if (ccmReply.getPage() == 1) {
                        ccmListNode.removeAllChildren();
                    }
                    for (int index : ccmReply.listCcmNo()) {
                        if (index < ccmListNode.getChildCount() - 1) continue;
                        Ccm ccm = ccmReply.getCcm(index);
                        CcmType type = ccm.getType();
                        CcmLevel level = ccm.getLevel();
                        int room = ccm.getRoom();
                        int region = ccm.getRegion();
                        int order = ccm.getOrder();
                        int priority = ccm.getPriority();
                        char side = ccm.getSide();
                        int cast = ccm.getCast();
                        String unit = ccm.getUnit();
                        DefaultMutableTreeNode ccmNode = new DefaultMutableTreeNode(index + " : " + type);
                        ccmNode.add(new DefaultMutableTreeNode(String.valueOf(TesterRuntime.getResourceBundle().getString("ccm.type")) + " : " + type, false));
                        ccmNode.add(new DefaultMutableTreeNode(String.valueOf(TesterRuntime.getResourceBundle().getString("ccm.level")) + " : " + level, false));
                        ccmNode.add(new DefaultMutableTreeNode(String.valueOf(TesterRuntime.getResourceBundle().getString("ccm.room")) + " : " + room, false));
                        ccmNode.add(new DefaultMutableTreeNode(String.valueOf(TesterRuntime.getResourceBundle().getString("ccm.region")) + " : " + region, false));
                        ccmNode.add(new DefaultMutableTreeNode(String.valueOf(TesterRuntime.getResourceBundle().getString("ccm.order")) + " : " + order, false));
                        ccmNode.add(new DefaultMutableTreeNode(String.valueOf(TesterRuntime.getResourceBundle().getString("ccm.priority")) + " : " + priority, false));
                        ccmNode.add(new DefaultMutableTreeNode(String.valueOf(TesterRuntime.getResourceBundle().getString("ccm.side")) + " : " + side, false));
                        ccmNode.add(new DefaultMutableTreeNode(String.valueOf(TesterRuntime.getResourceBundle().getString("ccm.cast")) + " : " + cast, false));
                        ccmNode.add(new DefaultMutableTreeNode(String.valueOf(TesterRuntime.getResourceBundle().getString("ccm.unit")) + " : " + unit, false));
                        ccmListNode.add(ccmNode);
                    }
                    ((DefaultTreeModel)this.nodeTree.getModel()).reload(ccmListNode);
                }
                ++i;
            }
        }
        catch (Exception e) {
            TesterRuntime.getLogger().log(Level.WARNING, "illegal data : " + ccmReply, e);
        }
        if (ccmReply.getPage() < ccmReply.getTotal()) {
            CcmScanCcm scan = new CcmScanCcm();
            TesterNode node = TesterRuntime.getNode();
            scan.setUecsVersion(node.getUecsVersion());
            scan.setPage(ccmReply.getPage() + 1);
            ((AbstractUecsNode)node).sendPacket(address, scan.getPort(), scan.toXmlBytes());
        }
    }
}

