/*
 * Decompiled with CFR 0.152.
 */
package jp.co.toyoct.uecs.tester.gui;

import java.awt.Component;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import jp.co.toyoct.uecs.tester.TesterNode;
import jp.co.toyoct.uecs.tester.TesterRuntime;
import jp.co.toyoct.uecs.tester.gui.BasePane;

public class LogPane
extends BasePane {
    private static final long serialVersionUID = 1L;

    public LogPane(TesterNode node) {
        super(node);
        JTextArea textArea = new JTextArea(6, 85);
        textArea.setEditable(false);
        JScrollPane scrollPane = new JScrollPane(textArea);
        this.add((Component)scrollPane, "Center");
        PrintStream ps = new PrintStream(new JTextAreaOutputStream(textArea, System.getProperty("file.encoding")), true);
        System.setOut(ps);
        System.setErr(ps);
    }

    @Override
    public void nodeStarted(TesterNode node) {
        TesterRuntime.getLogger().info(TesterRuntime.getMessage("msg.node_start", new Date()));
    }

    @Override
    public void nodeStopped(TesterNode node) {
        TesterRuntime.getLogger().info(TesterRuntime.getMessage("msg.node_stop", new Date()));
    }

    private class JTextAreaOutputStream
    extends OutputStream {
        private ByteArrayOutputStream os;
        private JTextArea ta;
        private String encoding;

        public JTextAreaOutputStream(JTextArea ta, String encoding) {
            this.ta = ta;
            this.encoding = encoding;
            this.os = new ByteArrayOutputStream();
        }

        @Override
        public void write(int b) throws IOException {
            this.os.write(b);
        }

        @Override
        public void flush() throws IOException {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        JTextAreaOutputStream.this.ta.append(new String(JTextAreaOutputStream.this.os.toByteArray(), JTextAreaOutputStream.this.encoding));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                    JTextAreaOutputStream.this.os.reset();
                }
            });
        }
    }
}

