/*
 * Decompiled with CFR 0.152.
 */
package jp.co.toyoct.uecs.tester.gui;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import jp.co.toyoct.uecs.protocol.CcmParserException;
import jp.co.toyoct.uecs.protocol.XmlCcm;
import jp.co.toyoct.uecs.tester.TesterNode;
import jp.co.toyoct.uecs.tester.TesterRuntime;
import jp.co.toyoct.uecs.tester.gui.BasePane;

public class CcmCapturePane
extends BasePane {
    private static final long serialVersionUID = 1L;
    private JTextPane textPane;
    private DefaultStyledDocument document;
    private ResourceBundle resource = TesterRuntime.getResourceBundle();
    private static SimpleAttributeSet normalStyle = new SimpleAttributeSet();
    private static SimpleAttributeSet activeStyle = new SimpleAttributeSet();
    private static SimpleAttributeSet errorStyle = new SimpleAttributeSet();
    private static final String[] FILTER_KEYS;
    private JTable filterTable;
    private FilterTableModel filterTableModel;

    static {
        normalStyle.addAttribute(StyleConstants.Foreground, Color.BLACK);
        activeStyle.addAttribute(StyleConstants.Foreground, Color.BLUE);
        errorStyle.addAttribute(StyleConstants.Foreground, Color.RED);
        FILTER_KEYS = new String[]{"node.ip", "ccm.type", "ccm.room", "ccm.region", "ccm.order"};
    }

    public CcmCapturePane(TesterNode node) {
        super(node);
        this.setLayout(new BoxLayout(this, 1));
        this.filterTableModel = new FilterTableModel();
        this.filterTable = new JTable(this.filterTableModel);
        TableColumnModel columModel = this.filterTable.getColumnModel();
        int i = 0;
        while (i < FILTER_KEYS.length) {
            columModel.getColumn(i).setHeaderValue(TesterRuntime.getResourceBundle().getString(FILTER_KEYS[i]));
            ++i;
        }
        columModel.getColumn(0).setMinWidth(150);
        columModel.getColumn(1).setMinWidth(210);
        columModel.getColumn(2).setMaxWidth(70);
        columModel.getColumn(3).setMaxWidth(70);
        columModel.getColumn(4).setMaxWidth(70);
        DefaultTableCellRenderer rightRenderor = new DefaultTableCellRenderer();
        rightRenderor.setHorizontalAlignment(4);
        columModel.getColumn(2).setCellRenderer(rightRenderor);
        columModel.getColumn(3).setCellRenderer(rightRenderor);
        columModel.getColumn(4).setCellRenderer(rightRenderor);
        JScrollPane scrollPane = new JScrollPane(this.filterTable);
        scrollPane.setAlignmentX(0.5f);
        scrollPane.setPreferredSize(new Dimension(650, 80));
        scrollPane.setMinimumSize(new Dimension(650, 80));
        scrollPane.setMaximumSize(new Dimension(650, 80));
        scrollPane.setBorder(new TitledBorder(this.resource.getString("title.filter")));
        this.add(scrollPane);
        this.document = new DefaultStyledDocument();
        this.textPane = new JTextPane(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean getScrollableTracksViewportWidth() {
                Container p = this.getParent();
                if (p == null) {
                    return true;
                }
                int ewidth = this.getUI().getPreferredSize((JComponent)this).width;
                return ewidth <= p.getSize().width;
            }
        };
        this.textPane.setDocument(this.document);
        scrollPane = new JScrollPane(this.textPane);
        scrollPane.setPreferredSize(new Dimension(700, 550));
        this.add(scrollPane);
        JPanel btnPane = new JPanel();
        btnPane.setLayout(new BoxLayout(btnPane, 2));
        final JButton btnStart = new JButton(this.resource.getString("btn.start_capture"));
        final JButton btnStop = new JButton(this.resource.getString("btn.stop_capture"));
        btnStart.setEnabled(true);
        btnStop.setEnabled(false);
        this.getNode().removeNodeListener(this);
        btnStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                btnStart.setEnabled(false);
                btnStop.setEnabled(true);
                CcmCapturePane.this.getNode().addNodeListener(CcmCapturePane.this);
            }
        });
        btnStart.setSize(120, 20);
        btnStart.setAlignmentX(0.5f);
        btnPane.add(btnStart);
        btnStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CcmCapturePane.this.getNode().removeNodeListener(CcmCapturePane.this);
                btnStart.setEnabled(true);
                btnStop.setEnabled(false);
            }
        });
        btnStop.setSize(120, 20);
        btnStop.setAlignmentX(0.5f);
        btnPane.add(btnStop);
        this.add(btnPane);
        JButton btnClear = new JButton(this.resource.getString("btn.clear"));
        btnClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CcmCapturePane.this.document = new DefaultStyledDocument();
                CcmCapturePane.this.textPane.setDocument(CcmCapturePane.this.document);
            }
        });
        btnClear.setSize(120, 20);
        btnClear.setAlignmentX(0.5f);
        btnPane.add(btnClear);
    }

    @Override
    public void receiveCcm(TesterNode node, InetAddress from, XmlCcm ccm) {
        SimpleAttributeSet style = normalStyle;
        if (this.filter(from, ccm)) {
            this.printMessage('R', new Date(ccm.getReceivedTime()), from, ccm.toXml(), style);
        }
    }

    @Override
    public void sendCcm(TesterNode node, InetAddress to, XmlCcm ccm) {
        this.printMessage('S', new Date(), to, ccm.toXml(), activeStyle);
    }

    @Override
    public void receiveError(TesterNode node, InetAddress from, byte[] data, Exception e) {
        if (this.filter(from, null) && e instanceof CcmParserException) {
            CcmParserException exp = (CcmParserException)e;
            this.printMessage('R', new Date(), from, String.valueOf(exp.getMessage()) + " : " + exp.getCcmMessage(), errorStyle);
        }
    }

    @Override
    public void sendError(TesterNode node, InetAddress to, byte[] data, Exception e) {
        this.printMessage('S', new Date(), to, e.getMessage(), errorStyle);
    }

    private void printMessage(char side, Date time, InetAddress address, String message, SimpleAttributeSet style) {
        try {
            String msgStr = null;
            msgStr = side == 'R' ? TesterRuntime.getMessage("msg.side_received", new Date(), address.getHostAddress(), message) : TesterRuntime.getMessage("msg.side_send", new Date(), address.getHostAddress(), message);
            this.document.insertString(this.document.getLength(), String.valueOf(msgStr) + "\n", style);
        }
        catch (BadLocationException be) {
            be.printStackTrace();
        }
    }

    private boolean filter(InetAddress address, XmlCcm ccm) {
        TableModel model = this.filterTable.getModel();
        Object ip = model.getValueAt(0, 0);
        if (ip != null && !ip.toString().isEmpty() && !address.getHostAddress().startsWith(ip.toString())) {
            return false;
        }
        if (ccm != null) {
            Object type = model.getValueAt(0, 1);
            if (type != null && !type.toString().isEmpty() && !ccm.getType().toString().startsWith(type.toString())) {
                return false;
            }
            Object room = model.getValueAt(0, 2);
            if (room != null && !room.toString().isEmpty() && !room.toString().equals(Integer.toString(ccm.getRoom()))) {
                return false;
            }
            Object region = model.getValueAt(0, 3);
            if (region != null && !region.toString().isEmpty() && !region.toString().equals(Integer.toString(ccm.getRegion()))) {
                return false;
            }
            Object order = model.getValueAt(0, 4);
            if (order != null && !order.toString().isEmpty() && !order.toString().equals(Integer.toString(ccm.getOrder()))) {
                return false;
            }
        }
        return true;
    }

    private class FilterTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 1L;

        private FilterTableModel() {
        }

        @Override
        public int getRowCount() {
            return 1;
        }

        @Override
        public int getColumnCount() {
            return FILTER_KEYS.length;
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
            switch (col) {
                case 2: 
                case 3: 
                case 4: {
                    try {
                        if (aValue == null || aValue.toString().length() <= 0) break;
                        aValue = Integer.parseInt(aValue.toString());
                        break;
                    }
                    catch (Exception e) {
                        return;
                    }
                }
            }
            super.setValueAt(aValue, row, col);
        }
    }
}

